# brltty.spec.  Generated from brltty.spec.in by configure.
###############################################################################
# BRLTTY - A background process providing access to the console screen (when in
#          text mode) for a blind person using a refreshable braille display.
#
# Copyright (C) 1995-2016 by The BRLTTY Developers.
#
# BRLTTY comes with ABSOLUTELY NO WARRANTY.
#
# This is free software, placed under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any
# later version. Please see the file LICENSE-GPL for details.
#
# Web Page: http://brltty.com/
#
# This software is maintained by Dave Mielke <dave@mielke.cc>.
###############################################################################

Name: brltty
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

Vendor: The BRLTTY Developers
Packager: Dave Mielke <dave@mielke.cc>
URL: http://brltty.com/
Source: http://brltty.com//archive/%{name}-%{version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc
%define _systemddir /usr/lib/systemd/system

Requires: libicu

BuildRequires: /bin/sh
BuildRequires: /usr/bin/env
BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: coreutils
BuildRequires: binutils
BuildRequires: /usr/bin/awk
BuildRequires: tcl
BuildRequires: glibc-devel
BuildRequires: libicu-devel
BuildRequires: ncurses-devel
BuildRequires: alsa-lib-devel
BuildRequires: bluez-libs-devel
BuildRequires: polkit-devel
BuildRequires: systemd-devel
BuildRequires: linuxdoc-tools
BuildRequires: doxygen

AutoProv: no
Provides: brlapi-server
AutoReq: yes

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.


%package -n brltty-braille-brlapi
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

AutoProv: no
AutoReq: yes

Summary: BrlAPI braille driver for BRLTTY.
%description -n brltty-braille-brlapi
This package provides the BrlAPI braille driver for BRLTTY.

Install this package if you need to communicate with
another instance of BRLTTY which is actually in control
of the braille device.


%package -n brltty-braille-xwindow
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXt-devel
BuildRequires: neXtaw-devel

AutoProv: no
AutoReq: yes

Summary: XWindow braille driver for BRLTTY.
%description -n brltty-braille-xwindow
This package provides the XWindow braille driver for BRLTTY.
This driver presents a virtual braille device within a graphical
user interface. It is primarily intended for sighted developers
who don't have access to a real braille device but still wish to
assess the accessibility of their applications.

Install this package if you would like to see how usable an
application would be by a blind person using a braille device.


%package -n brltty-speech-espeak
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: espeak

BuildRequires: espeak-devel

AutoProv: no
AutoReq: yes
Requires: espeak

Summary: eSpeak speech driver for BRLTTY.
%description -n brltty-speech-espeak
This package provides the eSpeak speech driver for BRLTTY.

Install this package if you would like to be able to use the
eSpeak text-to-speech engine.


%package -n brltty-speech-festival
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: festival

AutoProv: no
AutoReq: yes
Requires: festival

Summary: Festival speech driver for BRLTTY.
%description -n brltty-speech-festival
This package provides the Festival speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival text-to-speech engine.


%package -n brltty-speech-flite
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: flite

BuildRequires: flite-devel

AutoProv: no
AutoReq: yes
Requires: flite

Summary: Festival Lite speech driver for BRLTTY.
%description -n brltty-speech-flite
This package provides the Festival Lite speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival Lite text-to-speech engine.


%package -n brltty-speech-speechd
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: speech-dispatcher

BuildRequires: speech-dispatcher-devel

AutoProv: no
AutoReq: yes
Requires: speech-dispatcher

Summary: Speech Dispatcher speech driver for BRLTTY.
%description -n brltty-speech-speechd
This package provides the Speech Dispatcher speech driver for BRLTTY.

Install this package if you would like to be able to use the
Speech Dispatcher text-to-speech server.


%package -n brltty-screen-atspi
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: at-spi

BuildRequires: at-spi-devel

AutoProv: no
AutoReq: yes
Requires: at-spi

Summary: AT-SPI screen driver for BRLTTY.
%description -n brltty-screen-atspi
This package provides the AT-SPI screen driver for BRLTTY.

Install this package if you would like to be able to
access GTK-based applications via the Assistive
Technology Service Provider Interface.


%package -n brltty-screen-atspi2
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: dbus

BuildRequires: at-spi2-core-devel

AutoProv: no
AutoReq: yes
Requires: dbus

Summary: AT-SPI2 screen driver for BRLTTY.
%description -n brltty-screen-atspi2
This package provides the AT-SPI2 screen driver for BRLTTY.

Install this package if you would like to be able to
access graphical applications via the D-Bus port of
the Assistive Technology Service Provider Interface.


%package -n brltty-screen-screen
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

AutoProv: no
AutoReq: yes
Requires: screen

Summary: Screen screen driver for BRLTTY.
%description -n brltty-screen-screen
This package provides the Screen screen driver for BRLTTY.

Install this package if you would like to be able to
directly access session windows maintained by the
screen program.


%package -n brltty-utils
Version: 5.4
Release: 1
Group: Development/Tools
License: GPL

BuildRequires: ncurses-devel

AutoProv: no
AutoReq: yes

Summary: Commands for maintaining BRLTTY data files.
%description -n brltty-utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%package -n brltty-devel
Version: 5.4
Release: 1
Group: Development/Tools
License: GPL

AutoProv: no
AutoReq: yes

Summary: Headers for BRLTTY.
%description -n brltty-devel
This package provides many of the header files for BRLTTY's core, as well as
header files which define the packets and keys for several braille devices.

Install this package if you're developing or maintaining an application which
needs to (or wishes to) use functionality provided by BRLTTY's core, which
needs to interpret and/or create raw braille device packets, or which needs to
interpret key codes as delivered by BrlAPI's raw mode.


%package -n brltty-systemd
Version: 5.4
Release: 1
Group: System Environment/Daemons
License: GPL

AutoProv: no
AutoReq: yes

Summary: Systemd units and wrappers for BRLTTY.
%description -n brltty-systemd
This package provides the units and wrappers for managing BRLTTY via Systemd.

Install this package if you'd like to manage BRLTTY processes via Systemd.


%package -n brlapi
Version: 0.6.5
Release: 1
Group: System Environment/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.


%package -n brlapi-devel
Version: 0.6.5
Release: 1
Group: Development/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.


%package -n brlapi-java
Version: 0.6.5
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: gcc-java

AutoProv: no
AutoReq: yes

Summary: Java bindings for BrlAPI.
%description -n brlapi-java
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.


%package -n brlapi-ocaml
Version: 0.6.5
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: ocaml
BuildRequires: ocaml-findlib

AutoProv: no
AutoReq: yes

Summary: OCaml bindings for BrlAPI.
%description -n brlapi-ocaml
This package provides the OCaml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have an OCaml application
which directly accesses a refreshable braille display.


%package -n brlapi-python
Version: 0.6.5
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: python
BuildRequires: python-devel
BuildRequires: Cython

AutoProv: no
AutoReq: yes

Summary: Python bindings for BrlAPI.
%description -n brlapi-python
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.


%package -n brlapi-tcl
Version: 0.6.5
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: tcl
BuildRequires: tcl-devel

AutoProv: no
AutoReq: yes

Summary: Tcl bindings for BrlAPI.
%description -n brlapi-tcl
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.


%package -n brlapi-utils
Version: 0.6.5
Release: 1
Group: Applications/System
License: LGPL

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXtst-devel

AutoProv: no
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi-utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%prep
# %setup -n %{name}-%{version}
%setup -n brltty-5.4

%build
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --with-braille-driver=-tt,-vr
make

%install
make install install-documents install-messages install-systemd
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"
install -d "${RPM_BUILD_ROOT}%{_systemddir}"
install -m 644 Autostart/Systemd/brltty.service "${RPM_BUILD_ROOT}%{_systemddir}/brltty.service"
%find_lang %{name}

%clean
rm -fr "${RPM_BUILD_ROOT}"


%files -f %{name}.lang
%defattr(-,root,root)
%{_bindir}/brltty
%{_libdir}/brltty
%exclude %{_libdir}/brltty/libbrlttybba.so
%exclude %{_libdir}/brltty/libbrlttybxw.so
%exclude %{_libdir}/brltty/libbrlttyses.so
%exclude %{_libdir}/brltty/libbrlttysfl.so
%exclude %{_libdir}/brltty/libbrlttysfv.so
%exclude %{_libdir}/brltty/libbrlttyssd.so
%exclude %{_libdir}/brltty/libbrlttyxas.so
%exclude %{_libdir}/brltty/libbrlttyxa2.so
%exclude %{_libdir}/brltty/libbrlttyxsc.so
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/brltty.1.gz
%doc %{_docdir}/*/LICENSE*
%doc %{_docdir}/*/README*
%doc %{_docdir}/*/ChangeLog
%doc %{_docdir}/*/CONTRIBUTORS
%doc %{_docdir}/*/TODO
%doc %{_docdir}/*/brltty.conf
%doc %{_docdir}/*/KeyTables
%doc %{_docdir}/*/Manual-BRLTTY
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf
%{_systemddir}/brltty.service

%files -n brltty-braille-brlapi
%{_libdir}/brltty/libbrlttybba.so

%files -n brltty-braille-xwindow
%{_libdir}/brltty/libbrlttybxw.so

%files -n brltty-speech-espeak
%{_libdir}/brltty/libbrlttyses.so

%files -n brltty-speech-festival
%{_libdir}/brltty/libbrlttysfv.so

%files -n brltty-speech-flite
%{_libdir}/brltty/libbrlttysfl.so

%files -n brltty-speech-speechd
%{_libdir}/brltty/libbrlttyssd.so

%files -n brltty-screen-atspi
%{_libdir}/brltty/libbrlttyxas.so

%files -n brltty-screen-atspi2
%{_libdir}/brltty/libbrlttyxa2.so

%files -n brltty-screen-screen
%{_libdir}/brltty/libbrlttyxsc.so

%files -n brltty-utils
%{_bindir}/brltty-*

%files -n brltty-devel
%{_includedir}/brltty

%files -n brltty-systemd
/usr/lib/systemd/system/brltty.*
/usr/lib/systemd/system/brltty@.*
%{_sbindir}/brltty-systemd-*

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%doc %{_docdir}/*/Manual-BrlAPI

%files -n brlapi-java
/usr/share/java/*
/usr/lib/java/*

%files -n brlapi-ocaml
/usr/lib64/ocaml/brlapi

%files -n brlapi-python
/usr/lib64/python2.7/site-packages/[bB]rlapi[-.]*

%files -n brlapi-tcl
/usr/lib64/tcl8.5/brlapi-0.6.5/libbrlapi_tcl.so
/usr/lib64/tcl8.5/brlapi-0.6.5/pkgIndex.tcl

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%doc %{_mandir}/man3/*
%doc %{_docdir}/*/BrlAPIref

%files -n brlapi-utils
%{_bindir}/xbrlapi
%{_bindir}/eutp
%{_bindir}/vstp
%doc %{_mandir}/man1/xbrlapi.1.gz
%doc %{_mandir}/man1/eutp.1.gz
%doc %{_mandir}/man1/vstp.1.gz
/usr/share/gdm/greeter/autostart/xbrlapi.desktop


%changelog
* Tue Jun 28 2016 Dave Mielke <dave@mielke.cc> 5.4
Core changes:
   The Delayed Cursor Tracking feature (and preference) has been added.
   Stuck keys are now automatically released after a specifiable timeout.
   Touch events no longer interfere with Learn Mode.
   Support for the Polkit authorization manager has been added.
   A couple of memory corruption issues have been resolved.
USB fixes:
   Device disconnect detection has been improved.
   Excessive CPU consumption for some older serial adapters has been resolved.
Baum braille driver changes:
   More bindings have been defined for models that have the B11 key.
   False reporting of input timeouts has been resolved.
   Handling of unknown packet types has been improved.
HandyTech braille driver changes:
   Model detection on Windows has been fixed.
   Output errors now restart the driver.
HIMS braille driver changes:
   Support for the Smart Beetle has been added.
   Newer firmware resolution of qwerty key code conflicts is supported.
HumanWare braille driver changes:
   Several USB connection problems have been resolved.
   The newer HID-based USB protocol is supported.
   The Brailliant B 80's Bluetooth device name is recognized.
Papenmeier braille driver changes:
   Clipboard bindings have been added that work on EL-C models.
   Bar bindings for the menu now work on EL models that don't have switches.
   Bindings may now be defined that use a routing key and an EL key.
XWindow braille driver changes:
   Fixed-size font restrictions have been removed.
xbrlapi changes:
   Brltty restarts are handled.
   Logs written to .xsession have been improved.
brltty-trtxt changes:
   The -b [--no-base-characters] option has been added.
Systemd/Udev changes:
   Multiple USB braille devices are handled - each starts its own brltty.
   Disconnecting a USB braille device stops the associated brltty.
Updated Tables:
   The en_CA (English Canada) text table.
   The zh_tw (Chinese, Taiwan) contraction table.

