------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2015, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;                use GNAT.IO;
with GNATCOLL.GMP.Integers;  use GNATCOLL.GMP.Integers;

procedure Test_Div is

   Q, N, D : Big_Integer;

   Dividend : constant String :=
      "1000000000000000000000000000000000000000000000000000000000000000000000";

   Divisor : constant String := Dividend (1 .. Dividend'Length - 1);

   Quotient : constant String := Dividend
      (1 .. Dividend'Length - Divisor'Length + 1);

begin
   Set (N, Dividend);
   Set (D, Divisor);
   Divide (Q, N, D);

   if Image (Q) /= Quotient then
      Put_Line ("test_div failed (divide): "
                & Image (Q) & " should be " & Quotient);
      return;
   end if;

   Set (Q, To => N / D);

   if Image (Q) /= Quotient then
      Put_Line ("test_div failed (/): "
                & Image (Q) & " should be " & Quotient);
      return;
   end if;

   Put_Line ("test_div passed");
end Test_Div;
