------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2015, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;
with GNATCOLL.GMP.Integers;

use GNAT.IO;
use GNATCOLL.GMP;  --  for numeric types
use GNATCOLL.GMP.Integers;

procedure Test_Eq is

   D, N : Big_Integer;

begin
   Set (N, "14");
   Set (D, 28 / 2);

   if N /= D then
      Put_Line ("test_eq failed: N should = D");
   end if;

   if N /= 14 then
      Put_Line ("test_eq failed: N should = 14");
   end if;

   if 14 /= N then
      Put_Line ("test_eq failed: 14 should = N");
   end if;

   Put_Line ("test_eq passed");
end Test_Eq;
