.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_source_win32w.mdoc -- create data source using a win32 Unicode name
.\" Copyright (C) 2015-2019 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_SOURCE_WIN32W" "3" "June 22, 2018" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_win32w\fR,
\fBzip_source_win32w_create\fR
\- create data source from a Windows Unicode file name
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_source_t *\fR
.br
.PD 0
.HP 4n
\fBzip_source_win32w\fR(\fIzip_t\ *archive\fR, \fIconst\ wchar_t\ *fname\fR, \fIzip_uint64_t\ start\fR, \fIzip_int64_t\ len\fR);
.PD
.PP
\fIzip_source_t *\fR
.br
.PD 0
.HP 4n
\fBzip_source_win32w_create\fR(\fIconst\ wchar_t\ *fname\fR, \fIzip_uint64_t\ start\fR, \fIzip_int64_t\ len\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The functions
\fBzip_source_win32w\fR()
and
\fBzip_source_win32w_create\fR()
create a zip source on Windows using a Windows Unicode name.
They open
\fIfname\fR
and read
\fIlen\fR
bytes from offset
\fIstart\fR
from it.
If
\fIlen\fR
is 0 or \-1, the whole file (starting from
\fIstart\fR)
is used.
.PP
If the file supports seek, the source can be used to open a zip archive from.
.PP
The file is opened and read when the data from the source is used, usually by
\fBzip_close\fR()
or
\fBzip_open_from_source\fR().
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
or
\fIerror\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_source_win32w\fR()
and
\fBzip_source_win32w_create\fR()
fail if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIfname\fR,
\fIstart\fR,
or
\fIlen\fR
are invalid.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_OPEN\fR]
Opening
\fIfname\fR
failed.
.SH "SEE ALSO"
libzip(3),
zip_file_add(3),
zip_file_replace(3),
zip_source(3),
zip_source_win32a(3),
zip_source_win32handle(3)
.SH "HISTORY"
\fBzip_source_win32w\fR()
was added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
