/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * JDK-8184893: jdk8u152 b06 : issues with nashorn when running kraken benchmarks
 *
 * @test
 * @run
 */

var f = [
    new Array(0.22473059911669058, 0.37936138524238905, 0.6598164896426695, 0.8473251126841354, 0.13966211202490586, 0.3363408077081699, 0.1124530704076403, 0.35196237381031725, 0.1391075329448631, 0.0774348857572511, 0.040788552466655026, 0.578223872577002, 0.7878116889880223, 0.6683180943980573, 0.6085683968944555, 0.46265132749777416, 0.6995862330250513, 0.8028956420072801, 0.06406047321930364, 0.40293964715500374, 0.4049071890166408, 0.1384334448495762, 0.5490211960349374, 0.3403322854906483, 0.6220093084262148, 0.9495063207590343, 0.557877888602694, 0.6679300644637294, 0.5872694819138794, 0.7870738696802239, 0.06278266010349487, 0.6868676662034118, 0.4532102287975046, 0.34559588799287677, 0.06335746614711024, 0.864538850048429, 0.14624405458360623, 0.5389497644100412, 0.5943641652782875, 0.4625279329246983, 0.491317676119149, 0.8650148232328535, 0.03019694480921309, 0.1966312737803, 0.8569049832463319, 0.4991392607732764, 0.8620091958901047, 0.46732964616580286, 0.05133581229689754, 0.1983076347898155, 0.991450415921004, 0.35629856016954176, 0.7102378160261886, 0.020677953797395565, 0.9844032562834222, 0.023020206501066176, 0.9549064265093706, 0.06925894204130945, 0.6587745224828979, 0.3552873690325379, 0.6727079202768542, 0.9538503247896698, 0.8423081132472684, 0.7283661044353082, 0.37315971970449413, 0.4319692604865978, 0.12955224199614834, 0.5098106210185925, 0.20712004807686668, 0.7373391244922173, 0.9915266262918603, 0.5104004097739981, 0.40155962309913906, 0.43361697176716774, 0.6473003853133594, 0.9263959164246134, 0.058675875427863455, 0.24138883538005418, 0.693604396969933, 0.4442861903714519, 0.9956499535927338, 0.17806242812657513, 0.6067669179087847, 0.08642784415490912, 0.06013552935651123, 0.5231394997147735, 0.8806744423646573, 0.06445176409610132, 0.1466077425332203, 0.5754506213459197, 0.7451245862244323, 0.3770403025946236, 0.9599892400554731, 0.9042874421103411, 0.12085126550410086, 0.1396541982166436, 0.4255099587897361, 0.8129687754107302, 0.7106669331419376, 0.6660152559138441, 0.5275456165519148, 0.031228525023113685, 0.9005803862630969, 0.13462729532423934, 0.27521979120704165, 0.23191473415201025, 0.4504129542682228, 0.2683440699226487, 0.4388426159836726, 0.8278409949137917, 0.7903497576665394, 0.8309703235323783, 0.6787989572652314, 0.646232883096835, 0.10802687396567545, 0.9021075902238087, 0.6972875336082327, 0.5010633861300569, 0.31016930251832286, 0.8299337077178389, 0.08335185284246338, 0.38767339481486207, 0.37345883832945226, 0.4813314867630222, 0.5929322847903181, 0.009424264586126885, 0.5612245854880129, 0.9097579320937778, 0.7082085388954654, 0.6127314550397606, 0.4757133691210853, 0.8434728859623618, 0.45429011982871914, 0.6546798072791992, 0.9401112355590746, 0.4602218485266363, 0.6163518211620092, 0.6565222961048249, 0.260151174695323, 0.7591944643595271, 0.6966000950222276, 0.706715679344048, 0.5020561414213284, 0.46705688675705903, 0.1779956198657865, 0.4687487471258409, 0.04173119918228718, 0.8220826135344491, 0.9204456867044707, 0.22186906312471955, 0.7895315951272026, 0.7688830554627059, 0.8052202953098117, 0.41691716472337415, 0.17559869222639035, 0.06596555967319617, 0.0646334320632489, 0.4648275915372291, 0.19266892068451447, 0.5593232824772181, 0.08657140363246618, 0.9919582525518721, 0.5364257111575192, 0.4074878314838909, 0.8672382740468186, 0.5942611221585938, 0.15787757664083513, 0.35695210976308944, 0.7005279881965641, 0.20140874518645846, 0.34791048609644026, 0.26159739939884175, 0.13872154632678546, 0.5223425753248816, 0.8110760532653303, 0.9157352840021228, 0.7367468883361374, 0.6853106508993269, 0.05384145637290472, 0.9276016190072793, 0.6010279999485689, 0.10831428676366994, 0.8119409184615838, 0.7986161466425137, 0.30398905917260766, 0.8399837383039684, 0.17213277383685743, 0.5934482345976743, 0.2965680982117477, 0.09625603098837299, 0.5055801020492964, 0.5869053419144994, 0.553634361873304, 0.4848280284543657, 0.32323704418832433, 0.05588782162318784, 0.8209917951467298, 0.4572108456048619, 0.68803680980127, 0.9481299776216138, 0.497690929822701, 0.8573121636419035, 0.8743418709383862, 0.5041737824081999, 0.8836600017783166, 0.045825162935125174, 0.5520302090276339, 0.03499854115265011, 0.25020533911133924, 0.9713042282126128, 0.8907563382052597, 0.9649560876449508, 0.9497202312140859, 0.7316591630415593, 0.6293391653350137, 0.9381376682684677, 0.5709802029028622, 0.6239009299004008, 0.3358935275713171, 0.2560253473848184, 0.9676923510766821, 0.4153240110188259, 0.7962353884194374, 0.1652573129779037, 0.8405046506743309, 0.5859116499436617, 0.711255808702096, 0.5465629793901757, 0.4364708225592282, 0.589601825581641, 0.6583720206515206, 0.36940025959473577, 0.845005004794247, 0.761153605757043, 0.5778284103572596, 0.8715541703100554, 0.31564986871301115, 0.3557048853532424, 0.8815341380714322, 0.7989323539266023, 5.208099596394344E-4, 0.34971410543454184, 0.6502882424625596, 0.1980195242054389, 0.5330773924531077, 0.05483021045554104, 0.2846572497062476, 0.1919298044697566, 0.894913386395615, 0.30033654763764095, 0.40543382605005085, 0.8907219821286885, 0.09354439236490819, 0.9251659289481555, 0.7615201828708048, 0.08761966979024316, 0.2767125466264655, 0.5870860492871073, 0.3962425641281291, 0.6750048849311957, 0.04251568934662664, 0.4445052751446933, 0.34751849251873435, 0.7775297265031805, 0.8697080581258668, 0.09545118324881219, 0.7129618286868309, 0.44441788966363693, 0.7888086004120416, 0.26862509874005513, 0.99792468544723, 0.3690041693068633, 0.6421918418325487, 0.15303801390599836, 0.2826399553389368, 0.5107863956760695, 0.5401253950403008, 0.925584456105643, 0.8940414644774572, 0.6837412406258211, 0.40975743668490794, 0.9900125775322272, 0.9485034047354789, 0.14438145155258375, 0.8553461927487759, 0.6761001701368291, 0.3436544398763587, 0.9640091295608385, 0.9005628617219729, 0.6644482710289142, 0.5205863536195463, 0.5018457021301936, 0.56748827883683, 0.200154997064793, 0.5921902672725938, 0.6091962302494937, 0.6619628620118109, 0.23773419908413584, 0.23901902681105613, 0.28953204126287735, 0.5812381169968754, 0.019995204660696597, 0.11098660717830877, 0.4153522259950878, 0.4374173926611037, 0.23520083155790872, 0.34138099573347924, 0.7599112522867701, 0.2989625498306443, 0.8196734163111405, 0.17908023044792054, 0.04037621592739504, 0.8925819918908542, 0.6771191180081727, 0.6755254791037054, 0.8887044301294883, 0.6791050859874399, 0.07129314541326315, 0.8249193593118102, 0.6675077172537537, 0.8194865174523404, 0.21522956762486922, 0.5492813854861014, 0.8303970705166176, 0.18087366810474403, 0.6281112843503579, 0.4444067247782988, 0.08977767628534172, 0.19770869458040452, 0.15995715091370377, 0.25843873845117094, 0.9997906127677622, 0.09912643866613546, 0.1946546819237256, 0.6616791394691597, 0.6880747028989687, 0.741448331360002, 0.4334686729580175, 0.984424365600904, 0.3772477330393217, 0.043361145448257865, 0.8340072150626705, 0.24903050626629453, 0.025483579662838207, 0.8114088955722585, 0.7337285416555789, 0.0030733804425160383, 0.8852879419161939, 0.5647151730583674, 0.92242340673197, 0.17238386066915157, 0.03055192338828905, 0.8203921822360903, 0.4447093944942072, 0.395903554439499, 0.9341894628346032, 0.18488177517897342, 0.21142510761743394, 0.07871910647019231, 0.9921411786180376, 0.5115129074726665, 0.07791373823103787, 0.7052979964629781, 0.4842534907528385, 0.33084923325078264, 0.9075371519478541, 0.7918625567380456, 0.8385186031238926, 0.737938980260511, 0.28036290857714685, 0.225003006004298, 0.22238770907235128, 0.9293690303005198, 0.9298186465949911, 0.6330445001314019, 0.4233459704390482, 0.6230638928277503, 0.6942094819006052, 0.8673470314618916, 0.700664545827808, 0.6650590876420026, 0.7553456771500269, 0.6326311802047667, 0.7912216420473469, 0.23001776356026882, 0.2031295727095478, 0.7985870410698116, 0.5345109055875178, 0.15604877155523222, 0.5128020975687134, 0.9494371469588063, 0.6454320844319053, 0.11942255675086255, 0.3506510669719436, 0.28378873696987783, 0.008185550986822276, 0.5510714420003956, 0.23433446275512615, 0.06402468867136979, 0.4905689993177551, 0.4242986612686672, 0.9655742771877144, 0.43264645060824314, 0.6852003115423262, 0.30191112381167007, 0.42582725658619247, 0.5623961169974067, 0.17266868620327758, 0.32102819601175747, 0.2796409575111799, 0.7876495001356187, 0.8713412266143301, 0.11510939280269306, 0.3657549143311586, 0.5764854122081865, 0.7895293510296655, 0.025281948550709976, 0.07260824679586486, 0.9460008256402193, 0.027946314255403393, 0.336838721952461, 0.7927666951106165, 0.19785557525274677, 0.19386297263261176, 0.6918158587184146, 0.6298835747171903, 0.6566943476165423, 0.4830957524374938, 0.2748486706761608, 0.8921606872824193, 0.43100757511378596, 0.5619379996190029, 0.8470433798592165, 0.5478768827782503, 0.08415725937981522, 0.0383709334275153, 0.2113910505909924, 0.7414033227740701, 0.5027075138124086, 0.75036891561811, 0.23328993496647954, 0.672226381618712, 0.17986364667515786, 0.31883858758574024, 0.11103024961580776, 0.6248503777751094, 0.5937381285019407, 0.41370905730876506, 0.19363582277339608, 0.7040540399698424, 0.3533252503105231, 0.9639164299063581, 0.27724518309075186, 0.8778260965794066, 0.3094807091128361, 0.10550282002956368, 0.9762537835755514, 0.2594071831378989, 0.8838662642513649, 0.006776130693756932, 0.4617290016016672, 0.17021631913333268, 0.45573391606734104, 0.8354538216380951, 0.5871472147716205, 0.4170423591059802, 0.7645877540380963, 0.03994038406885303, 0.18029265911699788, 0.3897320330128834, 0.93617580749394, 0.8053646900396645, 0.07019581959540966, 0.039707678773220456, 0.9199286401183505, 0.014729898050766965, 0.23927891070621043, 0.5349997146734675, 0.8378748973585726, 0.29650543993227996, 0.3434144629587851, 0.4040800342905865, 0.9882286595917552, 0.7722168638413365, 0.7263926720841128, 0.27863444111117486, 0.02125697862573961, 0.9310660371331426, 0.9703316677014107, 0.9245133200557699, 0.11070046702607073, 0.6533408845199545, 0.9698542878983488, 0.11045214422981908, 0.7809337638344886, 0.7803498552630933, 0.49539400945457757, 0.0057537995561164346, 0.4182163846999474, 0.7858438984244812, 0.2197815590480594, 0.220977428636826, 0.39379944390304444, 0.04236400313386235, 0.22230270185401713, 0.3097792865144664, 0.15731643393993344, 0.8956800997774621, 0.05570732182015181, 0.535402974984973, 0.6208017912417807, 0.2614629221407738, 0.5641883695386561, 0.9719179333495613, 0.6468438359098223, 0.7405572353712067, 0.7741383322736177, 0.5581567335162132, 0.4787935578110113, 0.31270150767723115, 0.34453072535330287, 0.5514029601297621, 0.506614159034552, 0.5132654810366355, 0.26006192828337593, 0.9382334589158138, 0.8488709208631678, 0.6235538036963482, 0.6777289182242224, 0.7515199291450211, 0.8495244578789404, 0.812450239456549, 0.09630675166530434, 0.9154465899673649, 0.7376049132703544, 0.3556538597121788, 0.3082290520587532, 0.1945022947788243, 0.3785085285094061, 0.028484921487193504, 0.9146637122212918, 0.0577567196430836, 0.2575720770867874, 0.5192146727060403, 0.537115156227985, 0.7863319902672369, 0.5797446922141793, 0.24210017920864757, 0.24267340907075086, 0.9498330689019024, 0.6435908658429788, 0.24278158716354503, 0.11506965349823273, 0.45660077357619033, 0.4535221953572536, 0.9834256752196463, 0.3499863326684517, 0.7430041278733819, 0.8710697138462027, 0.670976589797897, 0.7306098816418091, 0.30858910143472384, 0.47417259998867933, 0.44910069993517454, 0.8482021597326679, 0.7267535722261301, 0.6928732160277183, 0.21288935809500742, 0.9725066475376049, 0.4647184251186711, 0.7204723349428355, 0.025109907666961417, 0.04809405470155992, 0.3319180132795412, 0.16111267188741762, 0.11377168550049976, 0.8952910347158533, 0.14253319273476717, 0.36792272989321506, 0.21300046089346425, 0.32812483383417057, 0.22574256299766582, 0.9502671465037242, 0.5726913286486744, 0.5667561062592598, 0.7463690998001795, 0.9843137095459444, 0.3071365927291554, 0.01816051069318858, 0.4089504967525428, 0.048041324511155614, 0.8788015492762148, 0.22635931423294142, 0.009863463085503343, 0.3199773288795391, 0.42064821227582483, 0.5522881461810771, 0.47498356869051195, 0.6303664664755688, 0.2888826867933474, 0.9334320116861973, 0.4744641179551943, 0.5341378407031756, 0.7077295107116497, 0.8946437677358858, 0.4415685994871631, 0.18695076592124082, 0.6188118925942081, 0.8341024520932601, 0.8390932282635405, 0.04876367922886227, 0.8799439469315826, 0.49215684127408565, 0.8147674352168257, 0.21378505136135617, 0.7716173844308685, 0.4258384115057293, 0.9661220290605363, 0.47132866932797324, 0.36419174195816395, 0.2581175894779686, 0.7956656661542552, 0.03901052646682446, 0.6747734487903203, 0.44851554261235416, 0.578812809209374, 0.27788773340882345, 0.699996402497342, 0.3404731557272137, 0.7898568987606152, 0.5985545001755807, 0.34939225902623217, 0.2809180355631222, 0.9353846533588125, 0.19787415971658795, 0.023766127186922947, 0.6787591084378354, 0.6298789009939888, 0.22794033049071383, 0.0839691469667061, 0.9715776127969346, 0.014858691578599759, 0.4920240243672074, 0.7376867574732674, 0.6035724713726319, 0.17075721465303895, 0.7866781521677653, 0.9353371945841727, 0.2828569633432465, 0.9998394878599128, 0.564834465838136, 0.7109021788179176, 0.9824924543113845, 0.16881335210617643, 0.6816422022576106, 0.029487537579495737, 0.3771844708514015, 0.09138890438485969, 0.6029618289106676, 0.6106386479052587, 0.6663552261071165, 0.6038931785654369, 0.6058413062546861, 0.38491176155648077, 0.024345603210555344, 0.9411481712467575, 0.18096608621405152, 0.21092918252089699, 0.2397889268684047, 0.8551719937603953, 0.05898876350006543, 0.23112238775809213, 0.4587379446737928, 0.23586490830716123, 0.025807546915553647, 0.7765943184085031, 0.3299151495353455, 0.39069251766834945, 0.9662775910921213, 0.04500794079927928, 0.26549591635216496, 0.21948132806025844, 0.38150244697119073, 0.8701354815335134, 0.9771232440513583, 0.880792107891584, 0.9617678343408563, 0.7776786475217797, 0.9243911005592236, 0.18793936036222303, 0.665343303821421, 0.17919713850040508, 0.8218235775408805, 0.8955752419745945, 0.1527917316552806, 0.9944591774494177, 0.8904149822815862, 0.24185966550362503, 0.35709062249594126, 0.21225414491529393, 0.11108608134339804, 0.5965878679235647, 0.4317833152400524, 0.9006845708268076, 0.33994988169507223, 0.8322502839330662, 0.3125419179682567, 0.9601803426818591, 0.7790702406656039, 0.0828494550552995, 0.6519385260634037, 0.4759556529612764, 0.9614346451327862, 0.884401285613113, 0.9428844544596608, 0.8713548036706031, 0.10515290985619474, 0.3013992962838442, 0.23311217860340516, 0.1895101777084618, 0.41943106959036613, 0.5351217112090791, 0.951237986908259, 0.7379619570139664, 0.7036601016145182, 0.6825133037539242, 0.014357980494462352, 0.019365872161527076, 0.3709975760207058, 0.7684751755423105, 0.5677936445323477, 0.3411416919934994, 0.8491090362800299, 0.9097473050370518, 0.41951783082239147, 0.7478918414512903, 0.16327623316324025, 0.48517013493588057, 0.4749552789566893, 0.95264600904774, 0.39086663676667976, 0.48496334256975693, 0.2522668033556402, 0.7564643343538529, 0.591199401290946, 0.7907611665326075, 0.8638894540838973, 0.040658050096676335, 0.7611308670478938, 0.9984951698143012, 0.6870197478883586, 0.7918632615578002, 0.34422223918117223, 0.5378176113905899, 0.3138904374323729, 0.777430073260864, 0.8301410774045276, 0.264608977434756, 0.2721061320497242, 0.427065683354398, 0.020987336242877852, 0.40721580277630154, 0.43596633287010733, 0.1963966576564926, 0.6125234935711392, 0.7324160421577043, 0.011619168513934963, 0.1890925468441459, 0.8408277801616139, 0.0637108663819923, 0.47205276661985285, 0.0964189359346701, 0.07867830356560146, 0.8323931155436074, 0.84234544018334, 0.5765649117748551, 0.4310147953349548, 0.1709448130763369, 0.2912600354969792, 0.040816773545570784, 0.5751144718868171, 0.16866695476545535, 0.07218137375292821, 0.4396257439389356, 0.31865628481146524, 0.30104675445288587, 0.474560479432807, 0.0488445508346832, 0.6076385635022064, 0.7172193416119642, 0.5964427965803859, 0.4448839548293144, 0.006152463159963095, 0.02398165631145399, 0.4293218158813801, 0.8272671465768389, 0.9913038488707613, 0.440168805547422, 0.9584738304123938, 0.598036356699738, 0.759114965136234, 0.7118039744270649, 0.7250930566014385, 0.6396922782441579, 0.6210258159611426, 0.9762850617693227, 0.57096126003383, 0.046824383092233246, 0.4856554313094429, 0.842972252465458, 0.09204900518187265, 0.16131540273281975, 0.36677057657745216, 0.3178928643836272, 0.6643608464573844, 0.6369813110327072, 0.33595020138455456, 0.8418810040480348, 0.7734998440437131, 0.9167334148011843, 0.8472220619841561, 0.6343210546707909, 0.7788416258627043, 0.9438265592859753, 0.9009868258103704, 0.7387661301886055, 0.17387172733055045, 0.1484836226156513, 0.08583486022124398, 0.6520533630013687, 0.8661544478357388, 0.7521631788508109, 0.1393992573774866, 0.18514021645655498, 0.9935650001791476, 0.21396381297368894, 0.3031780313075526, 0.25173715415626696, 0.3178313529109462, 0.20713483441482394, 0.4112974110440424, 0.6099136854173045, 0.29209595333155725, 0.8583901910742271, 0.34947714760411075, 0.19220626482852154, 0.48612140966768314, 0.10869848980730668, 0.24799793134182213, 0.5513584094750116, 0.170928636722962, 0.9614489105472948, 0.5312600817999495, 0.12167433912850956, 0.5140698423514364, 0.07236908871927672, 0.7365616693360616, 0.45006978202012626, 0.017402752765257046, 0.605297896656713, 0.8360130819870781, 0.286254609703796, 0.541146508855471, 0.5288924213771115, 0.64804487985488, 0.4380834869282947, 0.50116413060885, 0.5615749242568816, 0.8087534534991927, 0.5959629102751351, 0.6008297777225949, 0.7855025354942312, 0.6883699166331679, 0.9093035529090978, 0.7645037946521204, 0.5450683032401828, 0.5844248281872734, 0.9583596213306665, 0.7765523035868668, 0.6214197406261922, 0.5007218325898243, 0.9063973590564088, 0.4980119274153342, 0.8317063938263618, 0.8300216313792813, 0.039987059108345435, 0.43241489127598043, 0.14024575051816224, 0.2983769981593003, 0.6093144835726618, 0.8429531647315515, 0.08852229697982528, 0.6003486005372397, 0.8657585982045126, 0.5850747319273143, 0.8519119157125931, 0.25687028645737453, 0.4605851290740407, 0.31176924769984027, 0.5132497709428663, 0.36132198821065287, 0.9164555983543886, 0.7332139703703802, 0.20683696434619125, 0.04440679664108582, 0.7125546662715937, 0.16811534269346418, 0.6312069352375917, 0.6847184597617402, 0.634488611986914, 0.7109953863175614, 0.0549505237789677, 0.11942434386778122, 0.4317105286241808, 0.957836374243323, 0.3471235225519189, 0.3682778192725381, 0.49807889094565405, 0.38191094745019727, 0.7522385504118243, 0.6742133354137204, 0.24525745586587677, 0.13228946602247627, 0.09956860494086628, 0.9850663862226327, 0.07401666152761122, 0.23942974127042127, 0.88746697758836, 0.3534997919706131, 0.3650977138845094, 0.955418931609577, 0.2156342641858605, 0.11600643364125829, 0.709152208583403, 0.2308514386865843, 0.8517398952018718, 0.12689805172414614, 0.6743722217987287, 0.1359898879053033, 0.8135322892054805, 0.7694786071800723, 0.7707761707754248, 0.37077169934511933, 0.7235483548363935, 0.9441394899275829, 0.9117190274457735, 0.8763866870104559, 0.8507592586016481, 0.7419035032201422, 0.5960451994961657, 0.9605654407086816, 0.19196631522842433, 0.0519831731763003, 0.23840536760113384, 0.2793828578379982, 0.16548720299339648, 0.9232080812124961, 0.5606094207961965, 0.4802945671579364, 0.49064959091019333, 0.10171502696550805, 0.723489344360345, 0.30428820937532475, 0.6088351679693234, 0.8010839451825429, 0.9265976069548397, 0.4694462375790208, 0.5652944454809787, 0.4261415176934008, 0.5321678190825582, 0.7138796900114851, 0.6156786711451842, 0.6679432813564188, 0.3801166088017517, 0.9629079622402459, 0.9472118786318464, 0.1149844649448909, 0.8524664286662553, 0.703522258342678, 0.8116529478524371, 0.28447867472628385, 0.4184212608962281, 0.2985856744752915, 0.055673734280263676, 0.7675825158315942, 0.8454283479084951, 0.15388587558300526, 0.5040061519297493, 0.0037333440212662383, 0.996910826384725, 0.3630712691421374, 0.901687327140464, 0.05180657522605259, 0.15395760586050833, 0.6986650016536684, 0.15395914375075548, 0.6095878167353987, 0.09610843951256798, 0.591765582011628, 0.41585420099595916, 0.4480943436862541, 0.7554736171839339, 0.0487066976270184, 0.1782276221781458, 0.37356930800776533, 0.1187795902585983, 0.28986319029620644, 0.8729699022645888, 0.807511145149725, 0.19353281837689962, 0.26395373895038254, 0.6773633443360831, 0.08389016028232965, 0.2773462357285983, 0.09060541825464619, 0.13602050878237304, 0.6027425165682212, 0.4735740624236592, 0.9146089240824659, 0.9385701973416052, 0.05062160009208039, 0.3817523220059257, 0.6172075034002238, 0.6922325217250773, 9.255701989392406E-4, 0.15794363938524647, 0.32292676690041355, 0.8106518435352726, 0.34090883361884095, 0.6879373830515843, 0.6648663594022256, 0.7038321809687207, 0.13722456347037193, 0.4453563455168612, 0.32703889907136263, 0.2987468747150718, 0.7481339981436974, 0.717074276023643, 0.46925524138551744, 0.5461705063341314, 0.21805772439162985, 0.26994889311254067, 0.25821951230760143, 0.9765077275272533, 0.24893316240274677, 0.2057272502216545, 0.8779113846396233, 0.5558702516766522, 0.3328809983913549, 0.7050818079913498, 0.07299680162071664, 0.0633797947070176, 0.9519734831811869, 0.5970867443021092, 0.490922974596105, 0.9616512456294508, 0.10343514615685656, 0.20704618878202974, 0.831517000264165, 0.2646369619709871, 0.7923969272272872, 0.7334371015199989, 0.08732176495484945, 0.2204899557842538, 0.5493626555717193, 0.48383136316162934, 0.9635670792383597, 0.7218294613619897, 0.47583670307216386, 0.6600133219710416, 0.9035873963442502, 0.23177004069059937, 0.7991002938254864, 0.024110001469575204, 0.013662366771583723, 0.6713009488509303, 0.4259127596828355, 0.7004035258773802, 0.5806698292534371, 0.15207973390800744, 0.5249540086628257, 0.5715965365881883, 0.8066053320141692, 0.6584303468189863, 0.7391124294792565, 0.21365259869079622, 0.8459361447872196, 0.7833123998090722, 0.23126216130797672, 0.07993571128142363, 0.22492185541448462, 0.4052552474661941, 0.40096275890732036, 0.6932242955532787, 0.24644780660692778, 0.756726664161416, 0.77455312202905, 0.9332767517055548, 0.03958123746474873, 0.6791327828481124, 0.26740038803169175, 0.1179770002175079, 0.4999748834769804, 0.9856222580208369, 0.744604231607519, 0.46769017454809325, 0.4854059628114058, 0.7600944819151476, 0.5652455297910403, 0.7153103042083834, 0.280153139515846, 0.1092878215013946, 0.5853074369711585, 0.07858292767434016, 0.5225778812000177, 0.3545510426079679, 0.915686275457985, 0.5466379366042855, 0.5021906629345818, 0.9008768283065084, 0.5842485521017055, 0.4492683725489621, 0.9756467104906963, 0.05300363624113946, 0.13467924795509856, 0.5753438302395879, 0.4255298584052297, 0.8618681830606182, 0.10990610067600837, 0.6858473075008865, 0.991447232641388, 0.6794176647778318, 0.3141731201419251, 0.12737717508207458, 0.13987145149051083, 0.47576733195051524, 0.7253760135491056, 0.393556309130911, 0.507331452973485, 0.12991547646901536, 0.9380611314830686, 0.9046430434211065, 0.250966367530004, 0.8437045802769245, 0.05752845791296579, 0.9797394791716135, 0.6711219371548813, 0.5484440871198686, 0.0367687551338568, 0.9613444748730902, 0.832582036556698, 0.6745863158644156, 0.5505030786899114, 0.7186002093750836, 0.4041926334678507, 0.93707430069811, 0.6343830884378924, 0.3034327474011276, 0.9610492921129107, 0.852456062898222, 0.4824487874334259, 0.36288870156077446, 0.5490833277416405, 0.5485874181080024, 0.9922297090910649, 0.021321461585078194, 0.3987960057575306, 0.0537209235750119, 0.8744145655598812, 0.33768202676234804, 0.29305403106657724, 0.6590058458883583, 0.4028037413296869, 0.11602139530690903, 0.2432737815957654, 0.13690033958677605, 0.17029726072169427, 0.8014125127598798, 0.8089856786375758, 0.5677236520972638, 0.5379611500688112, 0.42885173373582564, 0.6076841431959997, 0.2775526786708069, 0.8167528207937067, 0.1093010725729402, 0.3050330598642389, 0.9228936419121692, 0.6052764336536871, 0.3348843561065733, 0.6499099486290757, 0.07103666020132282, 0.1219771752512937, 0.46435147926775555, 0.9244367231738875, 0.7197269182516767, 0.816473232339311, 0.11027723866082129, 0.5160590247881447, 0.07576326661674371, 0.022262977444000964, 0.7910619537848081, 0.18689949997322575, 0.5693613285843231, 0.9218337921930322, 0.13365334977121435, 0.015025510855246504, 0.5195947448762381, 0.6352384547961153, 0.1170103021080755, 0.9129344880525306, 0.08595505380332702, 0.8144937195787815, 0.3316809699581317, 0.09047577541288987, 0.14204679922496488, 0.7286947070978392, 0.9974687971189137, 0.8225903102614219, 0.4896614646611174, 0.4585283309963335, 0.529012267304157, 0.40666477704640425, 0.39495018458085696, 0.48390743914815615, 0.7682051234121741, 0.2499601981674605, 0.7731415985001636, 0.6447366385533992, 0.612735740601333, 0.6144892486475974, 0.47422816690082137, 0.18235993729962996, 0.6616256474727814, 0.6648808282853397, 0.02927050843379042, 0.3280294025038277, 0.6714991744716885, 0.11418394034393609, 0.9054458586735256, 0.6947727620761679, 0.07141710052236461, 0.9432276170501087, 0.7876937110536292, 0.5503274326907472, 0.5194593520954635, 0.38106724910972334, 0.65578772453329, 0.9013471079750217, 0.5008431823033286, 0.5772121264507126, 0.4578899624656476, 0.20287636916224705, 0.2652145066858459, 0.17074237312593943, 0.9951197792323203, 0.42212765280134124, 0.9798521656593772, 0.2670885472676081, 0.22639664088547262, 0.13188422065597827, 0.8358760330161281, 0.17016020718651137, 0.5787921992710907, 0.2863913931611419, 0.986151674903749, 0.5856746957639009, 0.005853928342046122, 0.3413879880778238, 0.616435611501451, 0.9109504524938058, 0.4748391460955952, 0.41996844492319163, 0.1554071723195921, 0.6570946025324752, 0.283524255984843, 0.29725539090069286, 0.6145839606672383, 0.011426941074273111, 0.1082317382281166, 0.0794014319355486, 0.31572012461806487, 0.041148270909592166, 0.966942795761758, 0.5862281800707845, 0.8111375120675215, 0.06367350659600424, 0.34484054555713295, 0.6118492555427409, 0.6315421676317483, 0.2647152440731695, 0.5743559025471471, 0.4339133012165345, 0.6062292160346764, 0.7321167817987401, 0.18776358040591723, 0.16964206935499615, 0.8921817104555392, 0.691598072326284, 0.36760316282725836, 0.8356278478552062, 0.5214198393789965, 0.8799919190419686, 0.8086765981897039, 0.2583930059463503, 0.2300589322341564, 0.6722119993091429, 0.27509957404292873, 0.30400443347078965, 0.5678858665620795, 0.7901078451496463, 0.8868613917083352, 0.24757360659291594, 0.8038655755555286, 0.16452708529993298, 0.7025741439961322, 0.4872630786203618, 0.9408402239014169, 0.796317726682215, 0.4785686311139392, 0.22245865719033275, 0.23178585472764468, 0.26766900439141117, 0.5792210991441272, 0.16205566824786533, 0.9503423630132587, 0.8921016963987046, 0.8893714178882919, 0.8063470312843879, 0.8099346072266516, 0.35958478585770615, 0.23691980492327758, 0.35478963415600606, 0.3486536026761795, 0.13266724136811192, 0.2721657993956115, 0.8319646680369279, 0.8011689395385589, 0.7801797737510993, 0.9701798924000962, 0.595336776254192, 0.464294183366027, 0.8969741172283309, 0.9234745241041448, 0.9909557272675036, 0.3294297415514913, 0.25133200798802957, 0.37446780615029396, 0.5570335422570892, 0.8029581646126819, 0.3260899415604629, 0.5007102914928749, 0.8403687571980237, 0.6647691493574949, 0.4751902488100248, 0.8105707386721644, 0.5868792531464233, 0.02544265668221113, 0.5042822356414385, 0.6330546351756798, 0.7950432837415118, 0.9342203827749043, 0.602162063945643, 0.5926545611158563, 0.8798380501782168, 0.4627472261622001, 0.19925386475489937, 0.648608924227268, 0.9848039177325612, 0.5436660001973738, 0.5099980140946101, 0.7476718720970554, 0.30115141582654337, 0.5785001532183622, 0.22792774318082087, 0.39047343497870635, 0.10536759010625818, 0.84586104923464, 0.08537822940036877, 0.4437762453854075, 0.11056682837914789, 0.038867506760078996, 0.764186897227057, 0.34441092611280344, 0.6418705867400756, 0.8397672675098329, 0.9494078074129947, 0.4353993123262655, 0.09238960374169258, 0.30010142471032863, 0.15497662414121516, 0.5507511387137393, 0.09392126863698735, 0.9363543873953055, 0.31842716874650334, 0.12264639470764149, 0.8452633426049458, 0.8738836922775247, 0.061174519891078805, 0.023191916493725984, 0.08108515661488835, 0.07602519824070031, 0.9415433762494104, 0.07266753999778564, 0.23558583536599687, 0.6806212065903987, 0.9896349124863092, 0.6471538521388309, 0.4577081991253442, 0.7328202485118692, 0.30628912758727367, 0.10065962251120619, 0.2684665209606497, 0.15084908531732333, 0.5328138240069308, 0.7803442220519693, 0.8159847608057234, 0.5905586998333323, 0.5538153749020156, 0.25815626557100846, 0.880131510082469, 0.9848981640934003, 0.8823807670433348, 0.028186780159073055, 0.006176470762703001, 0.9260712824081203, 0.795023841862499, 0.32626149409452354, 0.4056827830356944, 0.7309827074319359, 0.4332236104720144, 0.9167734040244413, 0.5528881925197179, 0.9846819904675524, 0.7690457270472828, 0.6614835373939786, 0.7261175205434316, 0.5918649810860819, 0.5442527830188608, 0.43599403728140795, 0.09630741108853635, 0.8830944448730565, 0.03547299063390008, 0.4918248778836959, 0.3485140659996273, 0.12025250308668078, 0.7724109526766884, 0.6755010929876866, 0.23731317243766425, 0.8248393603569041, 0.1417480886524899, 0.010785092145439878, 0.9232905147391397, 0.7130847033784833, 0.14629465159449406, 0.02616448624004508, 0.41536099747762767, 0.6634391264803555, 0.4571189168565768, 0.8669323192730813, 0.9524423915615077, 0.0648648018301955, 0.29579384294408617, 0.6696738853407656, 0.6980498238794519, 0.0984462452698921, 0.6145646720066357, 0.8966999998057434, 0.6926654791379576, 0.9901934482760054, 0.5041558919310082, 0.328943865562802, 0.61127743509929, 0.03951119502577394, 0.7520994149709765, 0.19806483192930902, 0.5072703851971196, 0.2756601802332115, 0.9988801237199083, 0.5019788006752508, 0.38889042247493455, 0.9236365899234725, 0.9948591551982987, 0.8927624317932615, 0.17079453113938148, 0.4712491748983737, 0.04784902065934682, 0.6518533029359185, 0.27073505781078466, 0.020773495474858072, 0.8693789354926417, 0.17469677128260785, 0.8802183660421903, 0.7814153138137068, 0.6771027705674134, 0.07546471143647271, 0.7280153830873188, 0.012916329885436673, 0.5914660868223713, 0.49219976833314716, 0.9766918835870022, 0.4659869250474298, 0.07666280868121578, 0.42371384928889466, 0.7448644402262297, 0.38185254665064416, 0.4190759756317374, 0.9617971701850602, 0.6316774039545815, 0.41105139264314283, 0.010811281098447756, 0.09577012485562575, 0.5350354616373346, 0.39072328255833144, 0.511596331430252, 0.3611370376078561, 0.0014153166175389087, 0.7799801099406554, 0.7992319307530664, 0.9800774731836072, 0.3226186837080952, 0.6945514272107689, 0.9869466633929416, 0.2987371269538456, 0.6036187684285536, 0.9047485269390811, 0.6854194008085135, 0.2647572202951871, 0.0656903282903778, 0.864893126869952, 0.11789878669149634, 0.4082073812156283, 0.9203035533489122, 0.8277081780865572, 0.6587626725773454, 0.2900641802315783, 0.2518001072492848, 0.3637690818819874, 0.8590247363213713, 0.6646035959767648, 0.48065961289890435, 0.15396644811798244, 0.046709088958326594, 0.6655521941617121, 0.14420317673049854, 0.7520318516500167, 0.14567851382795627, 0.1705689706200224, 0.9278701578055475, 0.12453049293855678, 0.44341520949107005, 0.12460545870507278, 0.1077430973766429, 0.1673256083678455, 0.6564176094207427, 0.009919245603914995, 0.8237849316878895, 0.07037164686922026, 0.7912907021501222, 0.8389917261214908, 0.8932918240066535, 0.35679417350412357, 0.9802709311431198, 0.0163280840178609, 0.19535357510129836, 0.6575664575802916, 0.6818417042430901, 0.16609386507750734, 0.009653169229952296, 0.7996940539207256, 0.38025885261872894, 0.5547688080086133, 0.07672566293505156, 0.5836705533695378, 0.19221949245625747, 0.05147576778474294, 0.5618358613669644, 0.7050684233738885, 0.5945723463181347, 0.6633685298900984, 0.5509233660340531, 0.6354818491894202, 0.8238811104791277, 0.5594390251646567, 0.18460239527861433, 0.9196383415986588, 0.36681671270106797, 0.1533314665321478, 0.04499316847795909, 0.26834899060594586, 0.35976820403327137, 0.2542266166054483, 0.9502002062582718, 0.031067611210623625, 0.6467267157158048, 0.5145870521571673, 0.8825428223565408, 0.11718153464328906, 0.7064098549201474, 0.40452973049168817, 0.3791809856091741, 0.20175739326212627, 0.6527591043975136, 0.7248196008873264, 0.3475698746170154, 0.09931802746693241, 0.03735622270682093, 0.23395416323810092, 0.933214839424148, 0.5183267507189393, 0.2379687275501089, 0.3095354098427928, 0.7634877764588207, 0.019408246891493453, 0.8043489272252796, 0.6901023608540248, 0.6188051315424009, 0.8919356504765286, 0.2505747353435024, 0.25082380826443396, 0.3412562451276926, 0.8364658963258571, 0.43263454092001263, 0.4549274390112621, 0.5808106898484636, 0.7946063771150473, 0.830622918348598, 0.592468289330673, 0.8005215831107139, 0.0032478318772647397, 0.7668272955829116, 0.16901552131332775, 0.814681134931664, 0.3666997474511592, 0.8341504617750856, 0.8390639842727605, 0.01767385555219314, 0.5381163252938176, 0.5837274395653819, 0.09245238156152047, 0.3763120028206378, 0.6807024143619561, 0.8262593815012154, 0.4967977123156948, 0.20472645952869117, 0.7395404817199472, 0.7385014021607854, 0.6749310053873067, 0.7184257560873798, 0.1964813881687515, 0.33450498671583395, 0.35354694800544184, 0.37292496365130734, 0.7033929498658632, 0.760630014982592, 0.7577559154854109, 0.032384796241797464, 0.6931621609135601, 0.30400538989270554, 0.34595372338284913, 0.08499104220618836, 0.05319845334746265, 0.9660310438889065, 0.38040091307000456, 0.7243428920862376, 0.2127865990689487, 0.9456786547865561, 0.11113009713754729, 0.7499080172229257, 0.5434901094343575, 0.40176225892700634, 0.414276161744775, 0.40464145732591095, 0.8009067590460717, 0.4190134616098351, 0.570651066641203, 0.9641541530567646, 0.4464299522037971, 0.1897113927061056, 0.4963610652435885, 0.01935633959604699, 0.07927115612002267, 0.04077976832092378, 0.14449135382774014, 0.6532897623888774, 0.8818498722072993, 0.08567916251791519, 0.9853590514970462, 0.002901963983636402, 0.9357595442797695, 0.9610856675577478, 0.4425623804041495, 0.017804871727653993, 0.5008692182844151, 0.3202614458428953, 0.91303064742642, 0.5805989178876865, 0.8667222980375502, 0.49818676168533294, 0.531505438676409, 0.5371331998414537, 0.18324526617986003, 0.037937268849507766, 0.15336100907433214, 0.6001109187755966, 0.7568810572020226, 0.5734540692267465, 0.1243975746398096, 0.5357388619296473, 0.6586129113571454, 0.9007684367540437, 0.2822181499126327, 0.520657944583573, 0.13194655428669333, 0.9379070161139603, 0.29102628647575945, 0.06518220116290452, 0.2117697534120394, 0.6731173240873034, 0.8501581287943892, 0.43891119264720735, 0.16910999498527568, 0.13171756228098286, 0.5363893241363604, 0.1060708400245911, 0.8821627730167995, 0.8537888250990561, 0.041033522346827334, 0.28047669906420514, 5.641274523381368E-4, 0.3680916966608285, 0.3450758198187005, 0.34380212211623074, 0.8177330146676656, 0.6720031835122343, 0.9390613017111046, 0.5358734706399004, 0.09521054218424829, 0.7829348055940901, 0.5391850275595771, 0.022003461541990288, 0.6932744091113291, 0.01360527717469584, 0.8770065352833066, 0.16991238762283878, 0.7537091221719356, 0.7417068273357156, 0.04743887940085023, 0.6275766438752748, 0.35346297735951493, 0.09391717367805497, 0.5881378659991919, 0.5833824520873823, 0.0020259690536404973, 0.1448736306125299, 0.9331447779171738, 0.41125230524974565, 0.0907126023214554, 0.9436400167791562, 0.13461149029087982, 0.7559502005863633, 0.4186363582385243, 0.923360835391908, 0.7786644823790158, 0.997561058260944, 0.21801396014067997, 0.024211351888534516, 0.8349393413888471, 0.9491789378871274, 0.6805384452322798, 0.16541638715426943, 0.7740458138165192, 0.5881272304505103, 0.8469124321874527, 0.5390244198480125, 0.6631981370422052, 0.5985736923703779, 0.8632343580920013, 0.5662880208734136, 0.10747322252163061, 0.5121916617074417, 0.030781343924119353, 0.25691535589842673, 0.8426354339148756, 0.27355836364065, 0.7798350017384851, 0.1421218589421407, 0.5051931162396008, 0.12826984673334307, 0.6835471339056604, 0.9143248603125343, 0.606328745233608, 0.8342913578085956, 0.8944443671376101, 0.39948856981982284, 0.01857108782263306, 0.3308513846183747, 0.9340221658333607, 0.5125402999458352, 0.34755436313435994, 0.1642255923980408, 0.5949800361574183, 0.40194317517717426, 0.4059361582858195, 0.16604738675330233, 0.8260018539791166, 0.07642474012513467, 0.6325216368091765, 0.10731962082341451, 0.8605859507840294, 0.42502468644572744, 0.706869360302658, 0.31009175297028635, 0.5242821799767414, 0.6910389778862929, 0.7981294298564765, 0.48880576584109003, 0.6087937128199119, 0.14110212793384236, 0.8565920686529322, 0.4146027361698207, 0.4367538019112124, 0.8825628748153068, 0.10740073890488155, 0.34842172134759386, 0.2575886094075178, 0.5254728815475949, 0.4381108736690241, 0.5725110555037435, 0.9127291540771861, 0.6599223212744938, 0.6852517126257557, 0.7650116534892558, 0.2875368018651562, 0.9251197091126945, 0.91977499278931, 0.4085607027002477, 0.42765862657901443, 0.783528003608053, 0.7072515225911701, 0.9014032977091587, 0.8391297018147579, 0.9815327822165517, 0.975902472372325, 0.5482887835572041, 0.41439229019881574, 0.07753216454773948, 0.5640291388279444, 0.14846713485002394, 0.6305018752308603, 0.3490028296974834, 0.7381316293657647, 0.46939059134378425, 0.1511430694403183, 0.8520097146774465, 0.9739832305564825, 0.49726389706973273, 0.730678729358463, 0.39979184445888516, 0.07515369441136388, 0.9893762615872789, 0.3663080452418661, 0.7514700714419411, 0.26695177395627623, 0.5181868666677284, 0.9735103901843075, 0.35758736287781356, 0.24848314323262466, 0.8934250187205851, 0.47030378281572527, 0.5961054651603626, 0.311497162763698, 0.5760048236982308, 0.047447645429621765, 0.5506466765294185, 0.5419218194474663, 0.4563436248375774, 0.5745720904355984, 0.032182692026755166, 0.8084633811922182, 0.15971233643650373, 0.5463165172110759, 0.7260373843774404, 0.7123732238940582, 0.862534914371965, 0.7079125144114178, 0.057983882194892034, 0.923461429861438, 0.45609327292584834, 0.5162476448117942, 0.6163802651726045, 0.35966302145784657, 0.7778829429904659, 0.8902975960937148, 0.7417030766651463, 0.480939139541979, 0.5459040414070518, 0.2839167064330418, 0.200500781351575, 0.5630223863571934, 0.5774608505827379, 0.9743274718181184, 0.697704397137503, 0.19249182417294186, 0.8515826837271202, 0.6012520380166905, 0.3493957231695274, 0.38188987179719047, 0.9829676760662491, 0.41447970007124835, 0.13754847588859975, 0.6420697365956217, 0.7153900538575436, 0.3917659387794028, 0.7989208796759062, 0.06868867081822727, 0.11380058896698375, 0.3743109042391366, 0.5621930713979181, 7.389647247068032E-4, 0.2368894067845999, 0.6336655458771565, 0.6406061782112006, 0.09123505110642116, 0.2056683657122289, 0.8317662567804748, 0.4117742909118566, 0.6936516198419401, 0.7486706522536872, 0.16489996900672466, 0.7720045739150786, 0.31243442081055817, 0.5006528959713037, 0.5927530728108549, 0.23937465114461087, 0.49188178337011634, 0.559225442167996, 0.4452995748133137, 0.9979808254499045, 0.9249213222227127, 0.0626244948264153, 0.3731349040187494, 0.22518419713891413, 0.7517835331989702, 0.8418793982775775, 0.5609638511406553, 0.7243465054852101, 0.9882993856841008, 0.5219175453391789, 0.3593022593383687, 0.0974609179361472, 0.7745270465342539, 0.7986877160143456, 0.0060540315653956345, 0.43524744920236613, 0.6666377715413331, 0.0031727017804040747, 0.9074762166402703, 0.7766967163317721, 0.5084693015072328, 0.47820036915267927, 0.0271468133945314, 0.39570972859470466, 0.5138800803605594, 0.7402516639986249, 0.2919012381293725, 0.30939526822314534, 0.06701538196647916, 0.8760032778110352, 0.5653052527101886, 0.27075094441820646, 0.40482223687292795, 0.13213120768038922, 0.6620833270513785, 0.9078678276599929, 0.7846269002386124, 0.19694152291320577, 0.0810233112015235, 0.6024622902686533, 0.9593153502105938, 0.24368226491095002, 0.6192298756501651, 0.1624534993691129, 0.783633415619995, 0.4079310068775347, 0.7972001309174628, 0.33646833710255153, 0.5573500335549564, 0.005240523721536605, 0.07204751334049542, 0.7425699529072038, 0.27450365395867715, 0.46026462130098433, 0.14530034031670702, 0.8391703577561752, 0.292678237910427, 0.614874989232358, 0.28205396976248454, 0.15300097355351572, 0.06223210061479201, 0.810319462967397, 0.449856609309747, 0.09717975980042692, 0.4626289862678571, 0.8972602821735252, 0.25856040324320806, 0.36182717427350686, 0.9814978541150849, 0.11757106208929835, 0.13647094293383222, 0.040347483538765494, 0.4417741150249912, 0.6230593036575552, 0.9134804253987188, 0.36640586898443395, 0.23325148415312957, 0.24882099274923053, 0.9984703725620939, 0.1797960154422853, 0.03710056539027107, 0.04272248156990077, 0.6361220265327032, 0.013806677323218164, 0.8453865204805932, 0.9675441945284112, 0.30737410798247133, 0.0023600898960360883, 0.6723449814600636, 0.138609623954141, 0.19811862511446188, 0.6421088089934491, 0.7301515622102664, 0.9372620698149046, 0.8023276974889323, 0.8128421260536369, 0.999147418465962, 0.34934090023208, 0.14865549814651002, 0.35896647123200087, 0.0609594031082189, 0.9178477826366451, 0.8436608197363816, 0.9654892251829145, 0.782680044542102, 0.7702829681848082, 0.11014801687015696, 0.02384865294592531, 0.9412494082649555),
    new Array(0.28366992036905014, 0.26572479839413377, 0.6760972165060748, 0.1594070807155985, 0.08407674518323272, 0.6345276093432359, 0.2503593341793259, 0.5880592769526158, 0.24248075789804635, 0.7141663068871488, 0.8561486886758476, 0.6146326000775221, 0.7251127447365828, 0.5302920457016957, 0.995044620330037, 0.5029626431249273, 0.3839554122481156, 0.5027931381930713, 0.6603907258591104, 0.27749190184630057, 0.03186061840842758, 0.8204759601886448, 0.5490929913368424, 0.35302850680592357, 0.43678816450908986, 0.27518869324878725, 0.689259114206078, 0.38104317813851174, 0.39095875711348904, 0.7416982281143004, 0.9993346064635142, 0.5344590595828481, 0.3632521104114287, 0.006231159792085217, 0.037554730225984434, 0.9851153456211431, 0.6269706439988484, 0.44444211928101685, 0.47494659250788385, 0.6415618005917052, 0.1701284387354527, 0.12867375952065419, 0.630778690582827, 0.3095687226073861, 0.14171359685599416, 0.3047246001676829, 0.7462697270710058, 0.31371252856262277, 0.06491167026761857, 0.8199422216585212, 0.54053259323029, 0.2756243418136499, 0.5570669275434358, 0.007311160893078705, 0.9921434670663654, 0.1829652478745185, 0.8361968808178273, 0.7343059725708687, 0.220389751396583, 0.1029184228776715, 0.8651650297064609, 0.8106322188775198, 0.8021651736884482, 0.8949651942066229, 0.587155471978851, 0.7155788195377245, 0.8536439217016655, 0.05993817483501851, 0.3398822062069228, 0.6535574379694714, 0.7302799550293994, 0.4258215765298978, 0.20100537158083676, 0.2755059238012689, 0.25434188240300737, 0.715495325993989, 0.7135149934187968, 0.014184216122140048, 0.9661073128392158, 0.16759581634280796, 0.16738241378648921, 0.8729929676571224, 0.01300564034604279, 0.28889329063588554, 0.37256878635181045, 0.6807965686280151, 0.9404107836502049, 0.5050617840369369, 0.6485184157014402, 0.27933378171313483, 0.8284511963101688, 0.9464445860475054, 0.5765544696048222, 0.8451507419527535, 0.9311170215314695, 0.8563944614974174, 0.9141331251285015, 0.5645929256819084, 0.21710941635844982, 0.14199458067617599, 0.9537017165502221, 0.17824365851651225, 0.9862903562319616, 0.4004427932161868, 0.5239453104711507, 0.49029912375212525, 0.041255842024332634, 0.34910777713224683, 0.7774949076201901, 0.7987205051123768, 0.7304692069226414, 0.963243445595684, 0.8867102046678448, 0.34360612986129735, 0.5475552924173346, 0.7825729417973634, 0.7779382034362139, 0.2940778409814756, 0.870770541758473, 0.7864315272936381, 0.07468867102006571, 0.4980770356737213, 0.8573277409037243, 0.9568834412256285, 0.4914557311032819, 0.20481826256294455, 0.46916868151440905, 0.15020446129534493, 0.022454952618399693, 0.23624842522289913, 0.09994159511563816, 0.1793488214244945, 0.40333329275028607, 0.6317129934877506, 0.2973546300655152, 0.07349529253208076, 0.4889491108370333, 0.619130441176273, 0.6307406170754921, 0.32549398275190866, 0.38660805382694696, 0.8763287572095064, 0.8405822374159659, 0.564011942107013, 0.4116801428830432, 0.4377993827483737, 0.024911007069905344, 0.4944022919903638, 0.1913117932243511, 0.2749748165535445, 0.7669075047069335, 0.140798148054875, 0.5319863681585961, 0.5322385649441007, 0.7886942994641264, 0.39165873846521326, 0.9879749103368922, 0.6362269175569939, 0.9282270016319751, 0.6019728048624406, 0.42025915537882375, 0.012584126213461833, 0.9793530932800785, 0.537549334206872, 0.21929646565890148, 0.9421839697270621, 0.20952213037303402, 0.2603037918533544, 0.2800363492354935, 0.1679318643767782, 0.1752951837726291, 0.6481733493120029, 0.2638873680773711, 0.22361405852923744, 0.792714960616498, 0.11927232466151627, 0.15987138659285005, 0.09786122910813533, 0.48776281235339536, 0.7871241578202142, 0.6659923505325074, 0.7691456594855146, 0.651542258003725, 0.712284568097092, 0.45188479628187594, 0.35183302022266616, 0.5554930406809455, 0.13539535231659372, 0.9350972139081656, 0.07866068694726136, 0.3438538254562499, 0.5776862391555412, 0.8059038117090273, 0.11161680829673759, 0.7137555117812916, 0.4771680441376368, 0.16932762902441456, 0.22104538848386301, 0.41774134014582476, 0.5922367969127035, 0.8380968723020765, 0.7019043213928206, 0.7791740287006285, 0.7491359701379907, 0.006545671120479879, 0.5064552932686666, 0.9979040961221535, 0.6356992684313016, 0.2630088398666689, 0.46426516459540357, 0.14173796768505253, 0.25102421113686346, 0.6570503692497319, 0.6332508736038731, 0.3686577683132458, 0.3092021956631905, 0.3279032960942895, 0.2796011384814733, 0.10540993403747645, 0.36495825476022803, 0.021788467326710137, 0.7197594648642289, 0.6199924365478973, 0.6800296407140041, 0.6783184401992438, 0.274255232659277, 0.6687358490098245, 0.8813391556436067, 0.1499817761053972, 0.8810204382772887, 0.6730863354925093, 0.2754957717074322, 0.03374239413180524, 0.4949317765657276, 0.18686373431969405, 0.27888148845866434, 0.5400771563665423, 0.260669298479972, 0.2516812040733072, 0.7985601230779711, 0.3023145163015164, 0.5875837267986198, 0.6063773751989882, 0.5564700478940692, 0.03792563925311698, 0.6781173500918999, 0.6157259014418447, 0.28783980666021813, 0.01345877712695931, 0.7654236104269204, 0.21435129992705793, 0.46449167067888486, 0.33609665697647684, 0.3011830001260024, 0.12369424501124049, 0.6946750728773632, 0.19735553657566063, 0.6012142004128481, 0.09303313009598901, 0.23329842435159787, 0.32823394198637834, 0.00433076678217903, 0.9399834023449088, 0.09990414821965599, 0.09015796327495984, 0.42899527122565373, 0.7215595383948952, 0.14645841120317094, 0.8223590156733582, 0.3226747990519815, 0.45379911280019414, 0.04300394948117792, 0.2938593086976389, 0.3904025480337181, 0.4161122779427868, 0.5564502905361967, 0.3670288470483678, 0.16190250829352326, 0.2259340036534473, 0.6862527425067316, 0.26971737286068764, 0.4107352944124266, 0.5499204529016503, 0.1904580582411859, 0.19425352051178169, 0.6742750491493608, 0.5298452244548891, 0.7865709063329182, 0.29414218877648857, 0.6399286594050189, 0.7445149505069241, 0.8439221346779991, 0.5330807986304791, 0.9608605266380315, 0.8034376121857346, 0.6976963845652787, 0.2559535973709224, 0.14358695320238812, 0.4736418822498415, 0.80950296458733, 0.7977529496485388, 0.5101565997367689, 0.5779586184165034, 0.8753506794017657, 0.9239144048315515, 0.8792343969621261, 0.771240797886633, 0.6391136047033422, 0.4043430311240507, 0.533258246527371, 0.7004115016116347, 0.6080518434845493, 0.5634459207602519, 0.24293922546014324, 0.9848941251282857, 0.08667721221972735, 0.21977612607745567, 0.6057274431791292, 0.9158926059973975, 0.9462308241793251, 0.03143165104983814, 0.7214677402492226, 0.766154008467787, 0.32926611094595937, 0.8971422089538532, 0.27632045478556744, 0.12625934189692467, 0.05230705667058322, 0.7280159066061493, 0.4351242143695818, 0.7391529925479705, 0.8142782812507874, 0.6012067412817211, 0.5527295722852855, 0.8915349795220049, 0.4443800553527777, 0.034302960274107286, 0.6064332686375414, 0.538904388250761, 0.33030782396987446, 0.8780252943508722, 0.42449512014352864, 0.9904563868377213, 0.8561926838390176, 0.11486356524328134, 0.23982062800795534, 0.16069911708822604, 0.14936532633100974, 0.6725683956496409, 0.8332441145393576, 0.10657127797498833, 0.6860229350236057, 0.21395480256759714, 0.5474488109812762, 0.8120047454163635, 0.33810488123947713, 0.7482628144277416, 0.7504118512204595, 0.9562908867402374, 0.2571599089706279, 0.8243594675776942, 0.9063636531003304, 0.708273422095642, 0.585713397404364, 0.012355848203235542, 0.27260272081408776, 0.42530444543278845, 0.36262076791085396, 0.35775149181179433, 0.3821084186733523, 0.5040645577790961, 0.14611891439549285, 0.5010082220830235, 0.8947462848870099, 0.529761852905736, 0.8167644678778604, 0.1954933196709403, 0.10396103668990297, 0.3008888923967671, 0.7421740593006566, 0.028022647003038803, 0.371205171313274, 0.2686305470024367, 0.9864587854953185, 0.248771788578532, 0.026951550342349195, 0.42317984117135543, 0.5294707108723296, 0.7511135817023317, 0.8249907998909293, 0.6836329578538467, 0.5244569088329336, 0.40697861811453473, 0.8658152937677874, 0.4037986241728452, 0.46744231330733976, 0.15962489435993354, 0.015243265798515204, 0.6931709073460842, 0.7776395371482722, 0.5032416918258362, 0.23603849054231618, 0.8704793007149632, 0.6954101663189947, 0.23760151260107365, 0.9231316526027735, 0.5166428171534037, 0.5927791682138981, 0.676013646965062, 0.2871523612372463, 0.2746200422378813, 0.7612295748516018, 0.8061212884150594, 0.06633096084736645, 0.7555605004278908, 0.4924824956953102, 0.25562362058319676, 0.36343202478722303, 0.6538267724306048, 0.8001925948788084, 0.29879335295590936, 0.20223208039624951, 0.44787133248583855, 0.44396730470646095, 0.5546987938881922, 0.477156407639716, 0.8696155007868737, 0.011843131975832977, 0.47432935913140273, 0.33004073179116034, 0.6618923893175988, 0.6933300785809909, 0.191361754658264, 0.6295854677875939, 0.011679754019502386, 0.03236110675526904, 0.8200935516755062, 0.15192193145674104, 0.44626250572306225, 0.3879605932272503, 0.8241099545436068, 0.264810895500178, 0.9101289621404083, 0.050171630121050415, 0.6505381892697153, 0.4033461518819169, 0.20231871523969158, 0.9597597046546611, 0.42728363122251956, 0.3916367394155188, 0.9471044196980903, 0.7624354181425195, 0.1544304148704606, 0.712793306927955, 0.7953033291390639, 0.4918167177982006, 0.48602828598115577, 0.15864585903897188, 0.6091790142559356, 0.520077007901376, 0.8947770019505695, 0.9009709196563379, 0.9708076472722704, 0.5412022665570773, 0.739658049429985, 0.9176088683776543, 0.47194669440260295, 0.25900671354080596, 0.5153529461520648, 0.8797026847832661, 0.8928589827232244, 0.14053341354934568, 0.35232622709186023, 0.06039147920643628, 0.5582082642586339, 0.0651925932969244, 0.6577403971135137, 0.5606437906045029, 0.8700567769833863, 0.9509667728386616, 0.6399091266067757, 0.16451667772705347, 0.2611596183315704, 0.47123895533769855, 0.34278408623372525, 0.4339789964305373, 0.5861643758482492, 0.7892761778704087, 0.7320096743550494, 0.2325379336886363, 0.27398868330876414, 0.8321273379133589, 0.3203694992658498, 0.7272600613437797, 0.4015626823333479, 0.0016711672599750704, 0.797986707177176, 0.06037968946672723, 0.21728711358493258, 0.3777763351812711, 0.14143009106470916, 0.3045383489544107, 0.5419717576212364, 0.40701231148151185, 0.7159165587507941, 0.019801425026630293, 0.9056834914013837, 0.790076554386565, 0.9560896200180588, 0.7159492561206604, 0.2408467875028718, 0.7820796903528552, 0.3133929082593996, 0.7901413898059703, 0.44510371331551624, 0.4020569491016247, 0.29184623476073557, 0.057904580882785606, 0.15185470139168644, 0.11155119256545509, 0.5590714438580244, 0.8244965284103062, 0.6020651723164864, 0.3668386875458629, 0.3157040107227832, 0.5540488591783299, 0.5978373919872095, 0.07534607543706306, 0.3338650925036758, 0.585494549595644, 0.1364108419887412, 0.3940328528429502, 0.3341587255727021, 0.01713637418380043, 0.47266830695425943, 0.495990880819115, 0.6606967039318782, 0.8358147026845956, 0.03888962617014946, 0.901238409908404, 0.5349438616795568, 0.6019845474753848, 0.8624080403196005, 0.7186633166999177, 0.5217148583907322, 0.5186130693289983, 0.8649890879570126, 0.6782962068334839, 0.22444288704761106, 0.5096604829090625, 0.7021657024026674, 0.14657080555480073, 0.6418795443527979, 0.013009165733741557, 0.6064268544474589, 0.4119559595483625, 0.0646746894663135, 0.5530565139737686, 0.03507204615953918, 0.404319569754664, 0.8678234726737645, 0.7997897154086773, 0.79170699734002, 0.6686117417613557, 0.06375756712879177, 0.7440112349453206, 0.6897706593701866, 0.8519308582265359, 0.020895676560666487, 0.8224859181767832, 0.7571476038225067, 0.182762802297312, 0.323758836726194, 0.3121321422662455, 0.44283343151617605, 0.4221602964362807, 0.3532934692924139, 0.07898054489203532, 0.2797857857139162, 0.5488555820092343, 0.7998357826460003, 0.8154762398193528, 0.9825066569329158, 0.0037766733144264375, 0.9861889396688187, 0.22880108673760902, 0.013566408349716896, 0.6641634022089452, 0.5745743004764868, 0.2532448313777338, 0.24019390112724204, 0.84345663148299, 0.9587564818139762, 0.25125516189799457, 0.42022066051337004, 0.520360061869317, 0.40143171095410524, 0.34064848882058507, 0.9060819694926885, 0.6889511050176964, 0.7670073083421897, 0.43956446062971233, 0.13624091826778895, 0.1914433610584626, 0.5211897324775113, 0.3560991421038562, 0.19531620217078494, 0.6461801424668187, 0.5213374062593903, 0.26615348367827696, 0.9673580612424988, 0.1156651082333735, 0.005323857357005912, 0.22088451216531446, 0.18113121822389144, 0.9729121158232295, 0.10169517518088633, 0.9042492880108699, 0.9519273440529075, 0.01912372571094978, 0.1301957681236352, 0.7214822127326409, 0.2613437277486851, 0.28168366259824884, 0.9392747527529755, 0.44094862147224045, 0.18462937628822484, 0.0786755862608125, 0.5359744057673628, 0.0346688986763406, 0.5746130359069046, 0.8746166820688428, 0.3036417660481545, 0.06690844426645648, 0.34189221688689175, 0.17182160491977772, 0.17419260190004038, 0.9655813323906648, 0.4328763119878887, 0.18278842737295398, 0.22419716364417475, 0.7778162412237682, 0.10044086066457347, 0.3112250625101898, 0.29784495376781817, 0.5588851258239412, 0.08636400161035218, 0.5328111709867113, 0.42488591931073727, 0.3727965921417823, 0.8903805027931905, 0.6115170583021216, 0.9979337274488498, 0.9932078284758304, 0.38760238812270975, 0.7132775523135246, 0.9010564184762717, 0.7849097410585373, 0.67421971743501, 0.38604581417080197, 0.040368430908028996, 0.9189924095555496, 0.17080891227739214, 0.06372788375313665, 0.017377102331756045, 0.028898892516999064, 0.6932397798680768, 0.22122610102940488, 0.007126028509130911, 0.6499272309238762, 0.4130871891832366, 0.05879566554166815, 0.25571645641550034, 0.30134216194308083, 0.37261654397849175, 0.12614498753682024, 0.9955772523915767, 0.8681091625099995, 0.49382714534688354, 0.6101876974894374, 0.9918925832597274, 0.01836570703103102, 0.8267007840808483, 0.1050801297064764, 0.3798860493674219, 0.7530956164510689, 0.1187174308740978, 0.5591547771372706, 0.9301987514166774, 0.8260739896100361, 0.6558638674277529, 0.7505870770873163, 0.38838776030681854, 0.6950022783053755, 0.7247754476855589, 0.08210932030401863, 0.07461095927939176, 0.8688537470399446, 0.9763141820820016, 0.7048114937680332, 0.5008526161821338, 0.0018021998283069829, 0.43280209666397684, 0.9820464821418653, 0.3655839432678085, 0.8507074661477675, 0.8742912535675614, 0.08668274752392235, 0.9195408853464555, 0.26098303911259413, 0.8636668304562355, 0.08842439196582252, 0.361341840158677, 0.6747733038313104, 0.7260435635687998, 0.2326452794475199, 0.6179555484115091, 0.26571829884650233, 0.3848295709550362, 0.2381603854478036, 0.5925696723596032, 0.6961868822631431, 0.07499619198082264, 0.348583618786516, 0.72119909607104, 0.6657090877211677, 0.603505830692387, 0.5603990635085083, 0.46941193296095884, 0.8734418804695211, 0.007514735164620201, 0.9205975521876607, 0.22184069131313244, 0.7528524122029208, 0.17288090426541125, 0.037708666616736664, 0.8696847001362871, 0.35340536430752467, 0.21867167386394604, 0.9822836622474405, 0.28519952395771764, 0.04189257585586359, 0.2277799086110771, 0.5663618396985264, 0.7872071926464884, 0.27514403900755147, 0.2094212636580175, 0.5861794986990801, 0.6479513067679006, 0.5562115667706736, 0.01619938178813074, 0.9883571199035389, 0.6691593077771285, 0.8277178654933288, 0.30658972490399194, 0.07702655988374896, 0.8639634355975533, 0.9789148538227052, 0.5431071818299299, 0.817837527904892, 0.3213713142344714, 0.8470973066029673, 0.447086186645116, 0.014508250977975812, 0.40126560636161024, 0.07936898640542522, 0.2929164623816869, 0.634562200099093, 0.51045183154765, 0.4873601750366445, 0.9177414222088247, 0.8431194809128901, 0.8440618955792526, 0.07534700858032073, 0.347040429432914, 0.36708762864678646, 0.641660514371733, 0.7513246546282455, 0.49218006193868535, 0.6568235354660744, 0.7036904788782304, 0.8409380003329278, 0.46293372291380697, 0.9383144988750318, 0.14143159559084495, 0.9157745636240957, 0.6561328662990469, 0.6561530449238343, 0.5924376275098558, 0.12037706234992418, 0.9310271498181003, 0.9960567282347311, 0.42345450545042196, 0.13643303668534223, 0.8625951992817058, 0.14541088496034926, 0.7641115984693739, 0.15795204955635478, 0.2759613071473256, 0.7012883759589545, 0.567217966486917, 0.7678412977941472, 0.008237741461066372, 0.1676275236577066, 0.27528333394272775, 0.4041430792552889, 0.11852618641745694, 0.796725392694233, 0.08792366972533339, 0.1832980972832201, 0.5724762159264558, 0.12493091408360035, 0.27109969743312945, 0.20815121596652564, 0.7647123799792591, 0.42839784199766495, 0.4266757754507021, 0.13001671613685184, 0.11060581626078525, 0.9819853037896682, 0.14957594622162007, 0.6569727238850964, 0.3382803624951355, 0.4428691978934536, 0.039852649497689296, 0.9046553417509767, 0.04240686392505699, 0.9001549935920229, 0.6082731451632868, 0.9711747600649594, 0.5232541011231411, 0.13275878996598012, 0.21656689209993574, 0.8843773234196519, 0.9276279579126145, 0.400049662866109, 0.8272674226389958, 0.11752907061198514, 0.23274535599224733, 0.6532238884243192, 0.0031200329904081947, 0.19859741720928625, 0.6697528683611553, 0.40010704784828344, 0.29231669170792396, 0.5486599727735649, 0.7705145892433993, 0.5820572994496258, 0.8633580764542369, 0.5765702975200089, 0.3394572060184007, 0.7288696721326376, 0.01213162552203828, 0.22986249230494427, 0.30167507518845005, 0.34605708992016937, 0.953834277475899, 0.6559776759635084, 0.5591613949209293, 0.9586116021199723, 0.13365660690535353, 0.3632473934850282, 0.6989463012248651, 0.4863244384853155, 0.1426850868130639, 0.2876701334933789, 0.6400861515454204, 0.6579714572208678, 0.20926749331318206, 0.46936897861234295, 0.08086294658447868, 0.9851459862140721, 0.15112604101972926, 0.6217199840655616, 0.913216453899428, 0.4112482361656261, 0.6197918798213026, 0.7364921037812565, 0.6083456403129032, 0.12711700416446414, 0.4464731105678712, 0.009941551436402851, 0.9455806433951899, 0.20201569003412911, 0.9072584703922629, 0.7976546230452709, 0.35603974830497076, 0.6171613413174213, 0.7655966471686881, 0.010034797396302086, 0.5832506355230117, 0.008712108832192422, 0.021281783961129674, 0.3456814171948429, 0.3248286813654512, 0.9281048054975702, 0.3977133018816268, 0.026508824607506254, 0.012469591595085316, 0.7098612149745565, 0.7329881871897059, 0.24630640552106342, 0.911927474931525, 0.10045784386706957, 0.6054228092431135, 0.37354148291666645, 0.2803132585442816, 0.6465808144342584, 0.7203898008064996, 0.05955870424323173, 0.4049633782954176, 0.4670640340538441, 0.8128956125002066, 0.7949310733194891, 0.9662912619935502, 0.4400351298865226, 0.079112383140171, 0.12956912880597782, 0.3164495541409582, 0.025270557974163665, 0.44011756207941855, 0.7262968329335157, 0.9462945521298876, 0.9114874740574956, 0.26238347699342013, 0.6529535390000987, 0.6250578588226695, 0.4292768788382798, 0.5120980423555362, 0.8346839939906866, 0.4402954291595358, 0.20260897153912594, 0.7041870650260763, 0.385928769627342, 0.24009739279702036, 0.8253178306519671, 0.4219476172896556, 0.6207299586446923, 0.7852061318115356, 0.4437001139403838, 0.6294908782333158, 0.9003181001487216, 0.2556048884919926, 0.0023375418683598825, 0.4767318256727404, 0.11854783709018302, 0.62430230390759, 0.5674811025052816, 0.8054529230627397, 0.5486018495744052, 0.8104529619229226, 0.5808102162384162, 0.10500676205850668, 0.9784833170941342, 0.454617881258903, 0.11610721917550659, 0.23751302157894705, 0.5481697594621151, 0.6208828839366367, 0.21236425956962368, 0.8549432454852955, 0.467901566921856, 0.723717170015569, 0.13906560491122022, 0.06427607178036554, 0.8449312653721442, 0.5018678303366129, 0.012865767990699273, 0.5619455771491836, 0.17515998329575166, 0.9172508598948522, 0.5296096340937717, 0.15509281502639916, 0.666439969468639, 0.44371288679157983, 0.7016178142778355, 0.31467123464257996, 0.45192330010479653, 0.3287017061610288, 0.39738707755936575, 0.16424489963603672, 0.9246883624611889, 0.060298296771508886, 0.16933164469779005, 0.09835752627229954, 0.8789772792847776, 0.4527266610360353, 0.32491854856123525, 0.04563993075843431, 0.8787294279513382, 0.4753718782361186, 0.4475261707693068, 0.24436176913819874, 0.2906970302006866, 0.19350127036998, 0.6055819697239437, 0.28192324342255304, 0.717281006014707, 0.9632969706599795, 0.3020118311452652, 0.0648210666404272, 0.14332655893091573, 0.3294728554804426, 0.8107599799704621, 0.3319122453285561, 0.9714693926211444, 0.9106624267152073, 0.9231153197757541, 0.30133798832606196, 0.26222546712478145, 0.9259286014634216, 0.2838059822327409, 0.050259880023531656, 0.917868267790438, 0.9151603321929936, 0.4353011586969161, 0.26659827989724105, 0.25323927517315414, 0.6367847962133742, 0.40848531134216837, 0.08325331779456668, 0.3819893471296154, 0.0881384378715453, 0.1988465594516976, 0.8078269882479489, 0.11334940112242686, 0.08700367673133302, 0.749547826407662, 0.4946541343490959, 0.6023810210127182, 0.8772327708448392, 0.1262256781472212, 0.47098941992421584, 0.8257593073245058, 0.7770436575719679, 0.4130880867028214, 0.12548622617658023, 0.06549090666250279, 0.9754873419645409, 0.48585976030897693, 0.4946425653662414, 0.9745729133082799, 0.20074989719747827, 0.22434922910537203, 0.44167783442014996, 0.4714490914850116, 0.13336678198794472, 0.9158890644697134, 0.5123440853300395, 0.6642214962926095, 0.11809065671421604, 0.5706271754969066, 0.8734636057773004, 0.24092783645427818, 0.9400683238953786, 0.6206231426096125, 0.09252435028608319, 0.2787953193873225, 0.17414642911166833, 0.006931027395833178, 0.9004534571390469, 0.22323436143591424, 0.8905394035541921, 0.9723255228478193, 0.49472835352106537, 0.8664364845737399, 0.3057575542500207, 0.9720560899670221, 0.38627391171630543, 0.5157925781043907, 0.3046069460154791, 0.9909891415339144, 0.2711332495105748, 0.18394888543277077, 0.6272368730328354, 0.2127257775618302, 0.916688606307682, 0.5551703997933426, 0.9146249299956211, 0.4247587415027534, 0.5922482861347375, 0.6867817790638393, 0.736553530891836, 0.7634585970628365, 0.1451040174370466, 0.889808710000547, 0.1880460072561586, 0.40365650168487277, 0.4257029195575269, 0.9995431576364888, 0.6333942083488548, 0.5798164388352279, 0.3993666366284957, 0.2946081196980016, 0.7013238960939466, 0.8892671818911135, 0.9470296791761188, 0.6521990590383149, 0.690508075046445, 0.17269054292251818, 0.05375799272437054, 0.13753000495068957, 0.1315525119196178, 0.39303883189682587, 0.811347757725506, 0.11711531743603876, 0.36974176736395625, 0.8412812734309946, 0.4200935801505786, 0.15836785813690724, 0.682248203959019, 0.6858556839204306, 0.16485399080229768, 0.4320977069488571, 0.6241703209321302, 0.3524279718830269, 0.16183212828778948, 0.06984543682316102, 0.009681157913194016, 0.47153910625834716, 0.525026940122599, 0.9445869568991385, 0.17773084245074922, 0.16394516404466386, 0.4851013230068164, 0.6411975722231575, 0.9661626390853844, 0.24693314031351843, 0.9084507373273136, 0.9621647184994732, 0.12376457645091421, 0.5396214133593946, 0.6105463037680467, 0.17439053107582392, 0.7266937856333291, 0.8212306552417324, 0.8351647975305366, 0.3445269390894019, 0.5338741886593882, 0.1535370135371118, 0.2799070994972961, 0.5331373383864675, 0.11538261900475688, 0.2171966052000689, 0.08844572414825413, 0.32208065672560937, 0.01850203336529066, 0.031356612264480055, 0.3012314532978184, 0.13486511132820345, 0.19803528668815706, 0.9269443563664457, 0.3589274322466304, 0.07632061908484078, 0.4306359805774185, 0.9262534875769676, 0.38662902784749564, 0.5657901321227259, 0.4573280180722057, 0.7449215910663345, 0.1519660429150962, 0.8671420300559708, 0.15404884604396096, 0.4771211739779726, 0.7864734340903561, 0.7292571216016842, 0.11696565208374188, 0.6507619275389749, 0.587155568452941, 0.7422453287915841, 0.6674779030653387, 0.7467290182842725, 0.4739581719289938, 0.6874988659508322, 0.43123350797031457, 0.4646585019088343, 0.9689008738193949, 0.11378984848788043, 0.3261503478085772, 0.9874778465709645, 0.8839130074834262, 0.6069726508876339, 0.006348301434999759, 0.2479157030487087, 0.2569537031679049, 0.7374519541894581, 0.5520615472312346, 0.7324119869190001, 0.45978662975379936, 0.46742951421346024, 0.4700149147424145, 0.671335537868209, 0.8158188157081379, 0.8790444249314024, 0.8744116209483296, 0.5591437920855789, 0.5127022230111902, 0.44487254002306253, 0.05559465594840096, 0.8240944973390621, 0.07193541621938493, 0.7038529700878777, 0.5116071637985454, 0.12434718247198528, 0.14649196911726725, 0.12856077920716413, 0.9172919574333367, 0.18576764666013224, 0.9575413193396711, 0.17384642917280968, 0.4362342043355404, 0.31647612254113655, 0.2526168702278987, 0.9822147289582103, 0.24276502223167773, 0.7341557279172044, 0.2701249957013422, 0.987916612017084, 0.11440837898619471, 0.6243645734111662, 0.8288779433343753, 0.7095797100459608, 0.4795672565789778, 0.41157184217824283, 0.3263725143543399, 0.3503042615126222, 0.36090913980794115, 0.06936388693137596, 0.1258253633618479, 0.4345033800467676, 0.24182555596253874, 0.4222438495564548, 0.5395153118588986, 0.6023672970134355, 0.001503491299272297, 0.2986742510221061, 0.3747713902118135, 0.8556837883484488, 0.7135614411813247, 0.08348871890574538, 0.7989850499802339, 0.0028475598136995517, 0.28386629026240684, 0.6875260100238252, 0.10131373842463376, 0.7862438609373128, 0.6150617450006473, 0.20331507743960286, 0.7812819319512136, 0.1917923305516569, 0.22850274573324092, 0.54786759649686, 0.27827535150879, 0.738289130571176, 0.04870467454390237, 0.20711025899322577, 0.5709624784652587, 0.12328698152042172, 0.3610797580967944, 0.7912157566560344, 0.8219669490402182, 0.46260417566183554, 0.7906478531493148, 0.48606816827515553, 0.22065345374043088, 0.5021548027664979, 0.517572069679405, 0.6433248729368638, 0.18567861405222807, 0.6036449932527712, 0.8447843232961656, 0.6900138649474565, 0.12899763734315084, 0.009780402209985328, 0.6636297392760111, 0.2583312819444116, 0.05430648334554933, 0.8799825533487026, 0.32537286845929847, 0.9372816542672824, 0.3654381544642439, 0.8542128602283166, 0.9195729054531935, 0.3300288473890707, 0.39402124782326187, 0.45035458861942035, 0.9847489558713461, 0.16430256577712932, 0.32074742541420787, 0.42970504638808127, 0.23242046284502704, 0.04793242386785457, 0.3608840411924147, 0.37548138082458016, 0.9525224568857968, 0.0875573287737833, 0.3122068435333708, 0.12084504779878191, 0.38635840021557666, 0.995784778191466, 0.822316670006252, 0.33580197958368785, 0.5026684841732432, 0.5005516722669939, 0.02234378617621735, 0.5364362434329455, 0.2930545511649554, 0.8401639393918559, 0.4953317410371054, 0.015287248137314968, 0.9149174204875493, 0.8784696781782737, 0.9001319115033585, 0.7082820707439863, 0.7532257372207801, 0.9068466856715699, 0.9554296762067778, 0.8114854490174562, 0.7468506644987929, 0.5131615163019565, 0.9035610104642962, 0.04003205617914474, 0.13086346559607576, 0.9925847147465022, 0.020068238119700932, 0.7819574273747398, 0.08310813117681315, 0.6511220571887115, 0.2124828062887143, 0.041244731235804744, 0.6315248244571334, 0.009949705032254785, 0.2606110274344706, 0.9872568888135665, 0.5781138012542254, 0.3571164158021686, 0.7906390230235102, 0.13182453464973642, 0.12609426859579975, 0.31290338944262475, 0.6466614319358099, 0.6406124495032761, 0.35872557331956967, 0.07610864643736792, 0.925777541738593, 0.05198807649440651, 0.7114231842188601, 0.8007489908114537, 0.57668794465018, 0.7244676334192536, 0.10321570561887228, 0.11615002173129796, 0.12676339062175612, 0.6629168275270019, 0.44925273948447886, 0.14812029716855069, 0.7988471744048989, 0.9840349356885265, 0.8629881532703536, 0.5248829448908843, 0.006590618553650396, 0.17325182562714359, 0.9748270957628741, 0.7586645247152477, 0.9759111292756584, 0.4580204174664112, 0.4434388421014004, 0.0823168758146281, 0.030201120380329294, 0.07658696347503813, 0.9166024788006087, 0.2900754031924927, 0.8982043736159815, 0.9566747948565661, 0.4103652965712453, 0.382532461794286, 0.2560170818725819, 0.3351171571202016, 0.31845893889651766, 0.8481324005190387, 0.5984580041919628, 0.1473276586643626, 0.038331864154147466, 0.2269701417140847, 0.45009289652269013, 0.5945974603985995, 0.5058205749401329, 0.1974027821629576, 0.8724862174791846, 0.15756058633025716, 0.7673967971843247, 0.8019595261925682, 0.2017929613975029, 0.4657695366080501, 0.08709092476075675, 0.5862622954641641, 0.9595919591597355, 0.8561759392952664, 0.9846072780752388, 0.36314563632005714, 0.9199016884862031, 0.15741154494915321, 0.03180933389094864, 0.033891166920599125, 0.3866078078558367, 0.22211709969464943, 0.19666882027783772, 0.3994685195036569, 0.8380718183866938, 0.9961679649002994, 0.01693493813735003, 0.17690119520517877, 0.22947823396071232, 0.46149676826854424, 0.9101953767595162, 0.4993521686105973, 0.4085173802195615, 0.6183153489787978, 0.4826642285248052, 0.023250769487187628, 0.2962898847921105, 0.7828892934525, 0.7859459252667252, 0.3917592703724262, 0.7128576155815414, 0.868620400396807, 0.08918864774218649, 0.21110334995606295, 0.9856556271471771, 0.9910435715802668, 0.8834545103535045, 0.8847679849123183, 0.7690178453489903, 0.691446597032105, 0.5157982388099491, 0.6202864263857646, 0.8243589463300269, 0.30917242110655707, 0.062459340075513126, 0.6743267235644781, 0.8630938579136171, 0.549265497452063, 0.7937379366588525, 0.4340064990882577, 0.938164857413806, 0.08997496333156152, 0.8575375075499014, 0.24584365583912104, 0.28508601372781184, 0.15372928568698518, 0.6142223370753581, 0.9984768969286253, 0.959703503125497, 0.32554827761338256, 0.39235158348111066, 0.34126678604213967, 0.09740893693666453, 0.5444604297208576, 0.30301558585720745, 0.07811434182878851, 0.12733285488558355, 0.11634421534965533, 0.14991431457681526, 0.7143110398302989, 0.8150836073722089, 0.8007148688346389, 0.4029822896899141, 0.35396050073764584, 0.5788866094344348, 0.5093280802987757, 0.6652773684802923, 0.146488566289513, 0.12651771623639807, 0.9210751933660012, 0.05601606923593139, 0.26298523170673205, 0.09421354111533786, 0.36549506697258494, 0.45705108284974916, 0.9465985691571801, 0.03378067406525398, 0.6563295242154984, 0.6257516037931655, 0.525926938034762, 0.7904147226210041, 0.16690105291222213, 0.7641605557138648, 0.4063327461162577, 0.04127943977450288, 0.3306929952473252, 0.2524667954651766, 0.9613272363090608, 0.5236846582066366, 0.9233636291284134, 0.9042452358997547, 0.9346528062442439, 0.27174162643436317, 0.9365276427721917, 0.2815809096503188, 0.4334153746589865, 0.0016627049234859692, 0.5889898080557161, 0.3201075220259667, 0.8435962115999771, 0.6384118067046396, 0.03771698686228653, 0.7571554166497083, 0.031499241970897596, 0.8602009972393334, 0.6486867477874035, 0.6306170594701386, 0.00816623305180697, 0.4523675555341746, 0.26685180158985056, 0.42180333904720657, 0.8285188141617056, 0.20845512393995758, 0.7848115370597373, 0.2524768323997951, 0.8729630102224315, 0.09386136912264953, 0.45138311307017387, 0.914413539088665, 0.8164185131821133, 0.3962038099309283, 0.784116446807537, 0.4092573006916592, 0.5282112511685393, 0.6265946177691762, 0.6538986914325383, 0.10709638401296884, 0.865994689925031, 0.007303829482041779, 0.09514575981502149, 0.5941049246971124, 0.8278414777373874, 0.4838300664864428, 0.6616793959748853, 0.7727565753616145, 0.8088743565329807, 0.333186470588965, 0.6962406513390551, 0.8025311563158277, 0.7722805043725178, 0.6052488155310488, 0.7106914831635385, 0.024699915495483782, 0.9892816698526256, 0.8303017248403403, 0.18430810556890376, 0.10168832129159688, 0.6286076912322953, 0.6534582170805374, 0.47917131869014684, 0.219679879301939, 0.8832481350680421, 0.31541644050853135, 0.24451028864557, 0.3525385084452768, 0.5107333373963026, 0.18905697038504665, 0.6359584169826644, 0.2657904290447718, 0.6329228598975174, 0.9026728293190984, 0.9110305493693271, 0.15132183860481352, 0.3922550621192801, 0.93316349713867, 0.4787335101528505, 0.5266112011104522, 0.5936394318825179, 0.9363133783526699, 0.2790724310656181, 0.3067302960024937, 0.7746487112710015, 0.496314000564127, 0.44731753252420603, 0.7630115249549544, 0.24139499664497166, 0.42297857988603815, 0.5782476794734239, 0.41919329373370595, 0.4834502404187987, 0.20263637701105675, 0.5471877980397356, 0.804019231641248, 0.0383985790280893, 0.7174836125825358, 0.7675098461931059, 0.3786813572130393, 0.31508412076390824, 0.888206346308634, 0.9683678601904773, 0.888160764425799, 0.10434418774396093, 0.4659803644867764, 0.0617893906014394, 0.8474342089807079, 0.5069953675888673, 0.8024917387048217, 0.4348471902031602, 0.866678600938232, 0.7910653952658664, 0.06041081947510818, 0.05048676801213314, 0.04401925881551949, 0.2537408640869985, 0.9917917293160528, 0.06968663413670984, 0.7100325813688838, 0.5082276264925327, 0.10815832427673422, 0.31797972736451885, 0.3951269985742154, 0.7416964171295385, 0.7935766524458516, 0.8109664775299551, 0.009090906339241478, 0.3977140358089909, 0.6708028694755556, 0.7263008815356121, 0.8715095515825587, 0.4250357319315139, 0.3206351643444465, 0.6637328621834202, 0.41241762983799324, 0.7043617946671318, 0.2758864471222774, 0.7701420492297082, 0.07446824269864571, 0.5156378241283025, 0.06393460283471941, 0.3230989292321408, 0.19106225443549174, 0.9407043787379705, 0.9555951473580547, 0.6643415432994259, 0.38929719138246, 0.909578601738569, 0.9931011559143528, 0.9536572154033468, 0.3722582914122623, 0.19337677361626848, 0.816263781007735, 0.0740103903623005, 0.7720882499997603, 0.022863455900478336, 0.7834257697159062, 0.16035910292124833, 0.13343671338932106, 0.16883934459171301, 0.892609802302685, 0.6474543345696727, 0.9863043567495456, 0.25905657050513364, 0.04830223657132915, 0.43601800641495847, 0.3979604244884557, 0.8260768200807257, 0.2906020728220997, 0.7620470664995922, 0.35552696071931633, 0.08146373746007907, 0.706003669234124, 0.6205921494458533, 0.8239863983165527, 0.693928693026647, 0.8728715462865825, 0.14321176099848076, 0.3487842233789261, 0.912524275948103, 0.8597036157411516, 0.1574035469551781, 0.6278613778341243, 0.22070719928972227, 0.9905694525458004, 0.26666652140546676, 0.5648659296887247, 0.3330690584810223, 0.8196480135167112, 0.1814492027103921, 0.9334574819283157, 0.7537590506747676, 0.015579561205102288, 0.7040903296963942, 0.9320313586473696, 0.3041002793665838, 0.1463842893549535, 0.7249607431702898, 0.5888542162475735, 0.9966273721905834, 0.6769906471252859, 0.8223655991703233, 0.1895167244578425, 0.38374946919926467, 0.8439538411361608, 0.5753690705420963, 0.6417726296212265, 0.04146996903493161, 0.45573559667937424, 0.4965537280498451, 0.967247998552792, 0.16207002429245887, 0.08195415575888709, 0.5708298019651593, 0.915168389292644, 0.32439020153578835, 0.5413031205383901, 0.7467597282662868, 0.030165552294384446, 0.3863205236948314, 0.07537682149523728, 0.368466189353143, 0.37438965785025313, 0.10133657119094719, 0.10442851932057307, 0.45904235015287387, 0.5035669148775255, 0.4993947823333633, 0.0011275625914041187, 0.9704854432915399, 0.2273062992159195, 0.29222766111513565, 0.8896697286463473, 0.6005257102616967, 0.14587391488827728, 0.5640554866205756, 0.08013488959687298, 0.5433248500486009, 0.9488163934325223, 0.7909581540571063, 0.38177482916316374, 0.5888690590943882, 0.9852302094736924, 0.7956269214841974, 0.20395305366015481, 0.3149840744830784, 0.6711364907526799, 0.5889426383510935, 0.04974743434704032, 0.7262504798955223, 0.886335879356824, 0.17580371711315534, 0.7347661739459409, 0.5856995387179805, 0.6312818455407767, 0.3098532006365776, 0.42251577656647377, 0.858021162749218, 0.8639246987723566, 0.8702314447531144, 0.35769930836792607, 0.1371174556282474, 0.6171427848187665, 0.0032070463241706815, 1.1241830560881905E-4, 0.6661862760959608, 0.20929128754784454, 0.42251537144725715, 0.114343016417228, 0.5751216975841926, 0.6035635637266126, 0.29446060112698247, 0.2542702972736285, 0.2578687297328367, 0.7462732254147789, 0.9473138363548838, 0.9963974450509715, 0.39147247600158863, 0.019829885079579612, 0.2392661185684407, 0.22234139899790195, 0.9589120823821868, 0.7830954475331755, 0.7951722381685521, 0.7283423746622532, 0.7794126454395934, 0.3399713682380139, 0.4795471499283811, 0.44844466714810327, 0.4727789996505912, 0.5764824110958414, 0.4117540292071169, 0.6180394274594136, 0.4883971980154629, 0.9372851519224069, 0.5490490878028923, 0.2757490652092296, 0.814901135483576, 0.3744447932024676, 0.36412495157454516, 0.6041724505927354, 0.2531028140313102, 0.3944870875527323, 0.4260211769926354, 0.7437980644746052, 0.6826371931152418, 0.35414658984931335, 0.756746709796192, 0.8794328500511996, 0.5818732357475326, 0.7108964916780153, 0.6806859431248039, 0.5947820307703422, 0.17099488215601488, 0.021259130355471667, 0.5098363823776395, 0.7183554778854891, 0.9397570843290091, 0.09806084701989659, 0.815152633889116, 0.14266447940854232, 0.9942735054659769, 0.8872080931383189, 0.22274784865416808, 0.388711930736256, 0.6112941923724915, 0.3052267857746024, 0.6434306158424294, 0.009068737835935647, 0.623783078721491, 0.49071991049926733, 0.595031317309127, 0.2753669739825493, 0.7782065728523934, 0.6660634094209528, 0.809199224804819, 0.9798309184200137, 0.0017963661452888857, 0.08007362598068168, 0.6278274936995932, 0.5955047483237472, 0.5971506407857836, 0.3080443308328853, 0.7889902288685461, 0.4861258525980636, 0.7418901748919959, 0.5224647484172716, 0.07825230100423308, 0.3341309126941433, 0.3126865327823056, 0.21589476861560963, 0.9784389326561825, 0.4640718366770962, 0.9758319115796458, 0.25688696507714537, 0.8894287593869797, 0.2787566874195341, 0.6906210886257659, 0.090509595176129, 0.7092607598521523, 0.5967207734548473, 0.25716795952599847, 0.3569383548733822, 0.5688218860373768, 0.28217149540734476, 0.3068805412187877, 0.19474913783382242, 0.2946087391469251, 0.19233979091784736, 0.18166978332266903, 0.019957986393053018, 0.7375332128306231, 0.13221017273021773, 0.47706927787160036, 0.6275182843045367, 0.4504689019814785, 0.20289048260248055, 0.6347943863611015, 0.04889953427396576, 0.32321097073267935, 0.6574209621068632, 0.8618709204320326, 0.717536012238847, 0.690749486617842, 0.136612364965089, 0.826315050295141, 0.14334779122548313, 0.11923227692315497, 0.9475407449278352, 0.03344782646746047, 0.4782005588718071, 0.5437200852054076, 0.868616465379049, 0.5222787808885596, 0.06608456766265891, 0.6828135004212041, 0.8176836433736462, 0.5379954750626179, 0.314957581432849, 0.6874573063716555, 0.6033953753345496, 0.1344465903979678, 0.0016102064273282313, 0.7947051198354066, 0.8951491875025617, 0.23960793630156518, 0.4265765616260532, 0.35195290374246546, 0.49315616674674057, 0.5773730930935289, 0.6730267947834655, 0.9531273309792517, 0.9577564247246483, 0.9806104186111476, 0.591742424849841, 0.5855408758654365, 0.6658822451776606, 0.053281402506877185, 0.03368950232612056, 0.6246025913133278, 0.4026100845830308, 0.8435155773219772, 0.2823682160621771, 0.2332995997000925, 0.6670304559212245, 0.17488966544762852, 0.6000323579592468, 0.22434142601106333, 0.9742052582153166, 0.549759511569046, 0.2950353186725937, 0.7250853019827246, 0.5687697328235182, 0.08634557155516753, 0.7419742910847027, 0.048837645356217485, 0.13077653405279077, 0.7803737231060692, 0.3419672297304789, 0.020853087091935563, 0.2506674344243266, 0.49242503186607356, 0.4973123685559281, 0.6333292759172248, 0.6777981161855652, 0.4537495527515343, 0.2929434448461664, 0.31092196728367194, 0.6057297839520133, 0.7561511490970293, 0.7265077917682596, 0.25678167558155873, 0.5475410979192826, 0.24565095825862382, 0.009559339454398907, 0.318839838250326, 0.6757024609001295, 0.4749900382020237, 0.6742712948667413, 0.5670485164970273, 0.8535940220707889, 0.8866321120740807, 0.9632387265165719, 0.30450485332327215, 0.9695377681684512, 0.1957793740345345, 0.2543542460508724, 0.5488675157850995, 0.5992531314963718, 0.022016196868248517, 0.07840485061146041, 0.11519940004374485, 0.4689345193543697, 0.17854626192640455, 0.6239513553496717, 0.30734682904117394, 0.6686884637517211, 0.6695913036066486, 0.49221653576373836, 0.8821929163545804, 0.07485689881398294, 0.3693702856623555, 0.8641216410237879, 0.3895983084840545, 0.9797921561243068, 0.5601798920017128, 0.17227540342218572, 0.210569861896442, 0.4989386849479692, 0.9924485745310112, 0.8326335207151315, 0.6171741442665719, 0.9276149882774588, 0.8962381726004489, 0.583710557561928, 0.9599389251988574, 0.8536788583635931, 0.4215183937540893, 0.5056406422478553, 0.6519628598416183, 0.4972977001101987, 0.31364128175079353, 0.8470469885987284, 0.9636798642060742, 0.4453350077196703, 0.2407941223263732, 0.3745944915645135, 0.768201038334502, 0.6754030599180432, 0.08181101848436012, 0.07826390682516371, 0.2843842918960606, 0.5234207709726724, 0.6555746813616671, 0.714799878611163, 0.5532571605978231, 0.038555198107088295, 0.8273419027996265, 0.8524492198038013, 0.8531464542553696, 0.9907134938628056, 0.6626773754570959, 0.7920200762627181, 0.5098433880073916, 0.6482921591948513, 0.3162821381187587, 0.982456535790562, 0.5903603943245807, 0.32767838061114485, 0.6408549030749471, 0.32353724371574555, 0.7823121549631296, 0.6310382693065668, 0.08022548327127199, 0.0539708256669984, 0.35567967623690633, 0.2352154304253644, 0.271351446300352, 0.7600747827801368, 0.4796932327901251, 0.07210218994402673, 0.9213706838329517, 0.40838892428899765, 0.3247960406129371, 0.749635412433409, 0.948754066982782, 0.2049877576857485, 0.31812783943113454, 0.10260724778508046, 0.5817039838854974, 0.5149214284137349, 0.6406930534754013, 0.8337709416746449, 0.09229587841320097, 0.03712761705351397, 0.5553560005180865),
    new Array(0.3082600528519165, 0.11146194172001767, 0.9233218815397397, 0.4370311423986575, 0.6981292887474453, 0.01776715248962457, 0.5537874455046635, 0.43991341583891674, 0.8388637936405646, 0.7220298693841628, 0.23864963145854867, 0.5813203577282771, 0.3559927547747528, 0.28019042174099595, 0.20013415492091113, 0.647693895226257, 0.8474824674189011, 0.15843276941873585, 0.8094727798440308, 0.7355367086930492, 0.1663731027255414, 0.6474161608452194, 0.20153355225660208, 0.42853396806159505, 0.13816203940482352, 0.8765747517852407, 0.07091717009360154, 0.5818388518290251, 0.3687262865356524, 0.11479511446184576, 0.6651749099825155, 0.4354755292557527, 0.1511151988138102, 0.5603832008331817, 0.7339678998026387, 0.31104103369199376, 0.8633336784932845, 0.6210833717275105, 0.4674009835128978, 0.4593631482510403, 0.6642756533334675, 0.7640141148928262, 0.26242947544966955, 0.7214985809902695, 0.7412559543762255, 0.37573679812700067, 0.4931498856285841, 0.5414318815541928, 0.8401283096393136, 0.7142745083626352, 0.32895102861841574, 0.526062294599601, 0.3177661124775887, 0.957750753724701, 0.04391503791926321, 0.1865422525983501, 0.4967215124774015, 0.5584184851415888, 0.1915224803662694, 0.7147579288333689, 0.6731676593472705, 0.5962016116117453, 0.4806294080920712, 0.6497183810042173, 0.7317678314890593, 0.592473223452899, 0.18184846794605591, 0.0708470751769843, 0.954904341528344, 0.29264587889375304, 0.4178803500271133, 0.5186455003555721, 0.27873926282954853, 0.2552506389937299, 0.7470056150168544, 0.18792549029862005, 0.9448676274789605, 0.6955339183622175, 0.0358612330753586, 0.06478337555047986, 0.22386356572391508, 0.9232017636695403, 0.735790101111762, 0.5857154930189916, 0.6458081624967793, 0.8867937229971369, 0.3264661253254443, 0.08575153846841688, 0.9629274445496412, 0.7912692417692211, 0.8711610444431466, 0.7722082241831624, 0.8907575125952085, 0.490741480673634, 0.3399338141923792, 0.21164280086059706, 0.5267933040399561, 0.37489498829022183, 0.6001867506708234, 0.34981238666650727, 0.22936633819208996, 0.7654751039264721, 0.7484474812087507, 0.8979212686775091, 0.6545356085723755, 0.41833859753435454, 0.7628992150538291, 0.5131656394374208, 0.5950655445281069, 0.5869067692412192, 0.2930959790952945, 0.5775610261683144, 0.2431030739474298, 0.24446321140734262, 0.7714639231606487, 0.536264689214197, 0.5069560504866527, 0.4855910654090626, 0.9306033632675602, 0.6950818406259839, 0.05241295359015041, 0.8311448155224117, 0.24107062813121183, 0.09657060381595617, 0.8103342219213358, 0.14650460914950814, 0.7462326631084365, 0.5951380635634039, 0.7947838040414652, 0.1494613670671875, 0.2639516057731297, 0.5337453385909817, 0.20975854410763295, 0.03193367538390535, 0.9492702545906216, 0.4883169823367822, 0.987612850111041, 0.5488179982056788, 0.767933788191808, 0.39067602237408205, 0.09856409513713005, 0.037626035640156985, 0.5174970207444823, 0.9668029544637768, 0.19820417809653268, 0.22416440840196783, 0.6509304800247837, 0.8344430316092467, 0.43873113247833995, 0.3423630378814949, 0.3070525795990001, 0.7925634668939691, 0.5596540637052911, 0.050460875701901275, 0.6327796167734632, 0.8048880191095988, 0.6950137361243471, 0.8611085161204518, 0.6940988182453103, 0.9307134152262004, 0.6866997599410373, 0.3195490674146273, 0.01583424695087099, 0.9884385891925865, 0.0772352303332019, 0.961890510956845, 0.06468904990343805, 0.050713946296072954, 0.37043780572239526, 0.16458368534950385, 0.7957118175589754, 0.9648452268688732, 0.594656066610993, 0.35657218823522874, 0.7192488910807032, 0.9680618238520029, 0.6808183220568222, 0.707181744448411, 0.8136083245938078, 0.12448738888970212, 0.6763209271964234, 0.3256682126321112, 0.008075376868076245, 0.7491260109204164, 0.3558213341850879, 0.21244505058241414, 0.8915837367285924, 0.2039044462875852, 0.3612909626648183, 0.6873625982899431, 0.7642601208903133, 0.451787257215125, 0.6062215194646136, 0.787012713605716, 0.1422247315213594, 0.5372080956424485, 0.3126676025354235, 0.17088477759591458, 0.3504433136276325, 0.7245373628397257, 0.7148476205725016, 0.40529950730500275, 0.8940913236606112, 0.371032427896981, 0.15931400896211478, 0.10439953024295556, 0.8858043730753449, 0.7366939736932894, 0.059242663026245035, 0.2990766068633175, 0.924353208528679, 0.8406776237528094, 0.9191807539524098, 0.5775674317145897, 0.46969573598539305, 0.16238746806947335, 0.4366313581639756, 0.9955509103573386, 0.940022467651564, 0.4551040083636312, 0.5081415294245815, 0.48893209663038883, 0.4683259240311778, 0.19097606553080515, 0.8201008678351477, 0.5390990055206183, 0.4991886157770934, 0.18843230769705366, 0.588245388591376, 0.13829009378271417, 0.18089818687511328, 0.7865452928651772, 0.9249012150859665, 0.6818123086666256, 0.8136624200833472, 0.5256064742028255, 0.2592919016748432, 0.274200218083425, 0.4516109682389966, 0.6691483628893948, 0.21377147983755374, 0.07800942955356549, 0.12443458301789578, 0.05987548295275291, 0.3476351805483979, 0.7567880335041428, 0.043926534209537405, 0.7404433103341743, 0.2201983097103214, 0.7678720581168239, 0.59135565221458, 0.4897501008115367, 0.2961231478600379, 0.24600217106307753, 0.8435135851960385, 0.926383567235302, 0.31851259441990176, 0.48536059821436206, 0.888443405450563, 0.11309106705672589, 0.9090783852124499, 0.575478497107678, 0.2062709432812141, 0.6596178146147718, 0.31973094565681415, 0.5755660156742617, 0.9462238282212291, 0.16598497857966643, 0.456226690084767, 0.7221684645827596, 0.017837607390913557, 0.4742557109202261, 0.5220479426339246, 0.5566537458101386, 0.5325121777648177, 0.6040637145886152, 0.8894796090164866, 0.531887784885116, 0.2809961264627058, 0.43565547556754747, 0.09488558404820391, 0.6115562394523312, 0.6130400946521738, 0.17392425273943923, 0.1764773673109532, 0.6109419788634227, 0.29737515673379933, 0.3778897715927332, 0.9254060333007103, 0.5445703577390323, 0.6833352185206009, 0.8723048084726193, 0.004798052996981994, 0.04398450498018791, 0.7598576839416749, 0.1715460669235781, 0.3063941051718806, 0.9880156955263711, 0.5132595447386811, 0.14067333736869359, 0.3607398254833183, 0.8482644031741684, 0.32210105222938623, 0.4945175830011703, 0.09441549883967348, 0.8941101852226436, 0.9956126284037586, 0.3928851444141451, 0.7365818948857968, 0.32441902578013393, 0.4615749303716207, 0.8284415094506237, 0.21715727759170966, 0.5972193514783437, 0.0402060587234665, 0.723565483527676, 0.970230975406673, 0.7139687269891742, 0.7025238115988903, 0.6534400198363466, 0.6588566820753392, 0.9816352928657092, 0.7048152878312519, 0.8948734963581, 0.9711590109000522, 0.8236692535697853, 0.5152598125574942, 0.06382120678552783, 0.3027245166664636, 0.540041574714921, 0.004415274340181519, 0.9493037685845686, 0.8365388536511488, 0.5268782836498339, 0.45819256884830173, 0.2773953746575888, 0.2592695459783254, 0.3578206382318925, 0.09010592882743673, 0.046181711169331674, 0.1114838509654934, 0.3020926385906024, 0.37900201503373776, 0.761063547272963, 0.5594298356172925, 0.30835954498633666, 0.7391338737078414, 0.36950908204665034, 0.19729767041853152, 0.2188117579362423, 0.7413605261810544, 0.9453340535620467, 0.34141770517484826, 0.9945106544444691, 0.34741655684289874, 0.20481581844515762, 0.16164066853902037, 0.030884431856414207, 0.39361060371204015, 0.7504236686680694, 0.9101840860017801, 0.2213632100972257, 0.8659751046838083, 0.5326744878767082, 0.4545190220179578, 0.2874945673299625, 0.3458044559673833, 0.39659941923389086, 0.2984089145008785, 0.03548227539616167, 0.37268208095481026, 0.7365335652419139, 0.2840028591612255, 0.6219422001764358, 0.37151155939829217, 0.22141747825240554, 0.20792352484749022, 0.615771240917069, 0.2207304994224254, 0.27252583663482377, 0.6555795734247765, 0.6283765350116831, 0.5008005731453293, 0.4765150421437262, 0.46047154521436884, 0.5511140384896761, 0.9552302195040343, 0.3989081298463675, 0.3290487430150647, 0.9866365323303421, 0.7208018195769343, 0.3266120252207597, 0.336714373168875, 0.2899534401756584, 0.43933799130497864, 0.3127886497972787, 0.19686474153599853, 0.7453558024397062, 0.4502565917888819, 0.5233780544244144, 0.43238751825213173, 0.7969616001850649, 0.8813276290149138, 0.2917980965483741, 0.8378333817087298, 0.9234880481541057, 0.6044594931865697, 0.4768219049638557, 0.9105140289692194, 0.7019592101628108, 0.7040060651625377, 0.6883610899880649, 0.2500688038054296, 0.8404088399482317, 0.31700007760196447, 0.696858762885501, 0.2785814188598851, 0.476239388682436, 0.4478822787494845, 0.8742236243595608, 0.01711685396581586, 0.8347506881848553, 0.634710226035098, 0.8277121646335306, 0.06958812261433622, 0.42145250401542644, 0.14949438037592966, 0.4828934418060917, 0.4111512012904861, 0.28212692044388854, 0.7522230441842016, 0.7478066627272744, 0.0558658298483683, 0.5062085353010386, 0.8863021677536626, 0.5476490108437054, 0.18714858044085114, 0.07190123171069285, 0.60255003722934, 0.4578072853072911, 0.8745840776796844, 0.3355527017983442, 0.4295504421697527, 0.382773678564998, 0.07194905846243704, 0.9531587209243854, 0.870082651507434, 0.7294625017771726, 0.19384296543191615, 0.7884710771041453, 0.19651012362508347, 0.30567130088152805, 0.20210806273863735, 0.41003494636792104, 0.7424241721337329, 0.737906382313279, 0.7982608270936233, 0.10858210428299242, 0.9435027159812008, 0.5475192267042754, 0.014445971934135438, 0.9765591337756683, 0.9674585206930439, 0.1500767454258236, 0.22296250879194157, 0.48317042331914983, 0.8911150182787202, 0.9501153650529862, 0.34320179076824286, 0.1511677045618064, 0.03206230713422498, 0.3919049291894504, 0.8148748857424797, 0.39571936642099814, 0.22300981982525137, 0.2965751588397052, 0.7276970904569819, 0.32104454861790466, 0.5288658678779672, 0.06693421129472066, 0.3502357502228767, 0.2870980184976546, 0.1497391101376382, 0.3735350527563033, 0.18441641528919495, 0.35644417183010935, 0.027470098756787964, 0.7490223421752967, 0.5872223846566528, 0.31055942930630154, 0.9789660554265338, 0.11251849507813882, 0.9474104638353772, 0.7851540459067506, 0.016525120271064453, 0.6217849853942434, 0.3826059141018614, 0.21570622476729095, 0.883501713914561, 0.40812071063637323, 0.930928208001613, 0.7072523279196988, 0.7330768163702285, 0.6874361479424229, 0.2513378192864021, 0.6465794663380359, 0.30856319616149697, 0.4606687839599788, 0.9181844297906665, 0.8603171951938952, 0.9455878579376588, 0.5176815974202803, 0.497974831144373, 0.3890276243409473, 0.20965907132437867, 0.741012820453382, 0.7301686229157687, 0.4952442088175454, 0.007039259638970785, 0.76932216086928, 0.29884855074241723, 0.35251128316842795, 0.5625085392614513, 0.9251049704799398, 0.8784015975681203, 0.9728277502417269, 0.7445187162337915, 0.9372223583319075, 0.36388572497779925, 0.3215003772049563, 0.836400564288629, 0.39602206186544997, 0.4555463389806823, 0.24126292189015475, 0.0017020426822017543, 0.067301169048949, 0.05698591681793996, 0.7616198212584318, 0.37239909561661877, 0.16108851393318568, 0.26777878008643796, 0.6047239785995997, 0.9006338970907076, 0.40220110607928106, 0.10386235890211148, 0.21569996926236712, 0.8578009502569863, 0.2817554946514905, 0.46282538909098514, 0.4431758968785403, 0.1392140586748598, 0.1822915553352733, 0.266252498307023, 0.07488807051489932, 0.3382521332480274, 0.16389268853161987, 0.15757332911519362, 0.7935748433307376, 0.8907955962455745, 0.07466306890910179, 0.611404416177772, 0.7599770752598228, 0.4589292231427867, 0.3061490168364782, 0.8191596213412057, 0.9526143503969922, 0.12230105783524381, 0.9527684122208805, 0.2557454586625365, 0.5981079663261946, 0.8761919626885394, 0.3540382232525181, 0.40344568721570606, 0.5111727893984159, 0.3972629499154636, 0.9993670176110047, 0.7116390765879688, 0.9300018121695222, 0.031113287759302555, 0.5574060912685457, 0.504783261559483, 0.48061912039783483, 0.48019477838349767, 0.3554288003698096, 0.21613645618282484, 0.2328779191967626, 0.7262929568224353, 0.9789350648526691, 0.020978178797077307, 0.42113251631323234, 0.3086990315280167, 0.7876537439577759, 0.6706289159350499, 0.2942141818605919, 0.19736127477121612, 0.051342762999649905, 0.08735798690263896, 0.7321925800295317, 0.14971802697394088, 0.09726333706925572, 0.07030751032882199, 0.7215061499662079, 0.620578812634133, 0.33093061422531045, 0.2838500477379784, 0.5153961468233978, 0.006334218883762954, 0.24272054496443352, 0.5523359720089649, 0.3231806807081261, 0.2479388181584542, 0.545138811007617, 0.3689759815213871, 0.6697569363619389, 0.5915261332843403, 0.39903388363243464, 0.4416432766570437, 0.14582071723197232, 0.611178062316621, 0.28176390710863564, 0.044668808629408474, 0.1296445755812129, 0.4352858050902152, 0.4263023909690039, 0.9232421185887433, 0.20285733691021557, 0.4861027794801255, 0.9174952354252409, 0.505819384077612, 0.4055187277141953, 0.9415047266080582, 0.4701576521275339, 0.21997951430161822, 0.17988539506000611, 0.558635811387868, 0.6334263575440648, 0.7784577253739134, 0.8376151691490802, 0.4610337415090391, 0.6667588462124211, 0.4046257251252696, 0.6517588402368379, 0.9839910687612707, 0.6151980281223712, 0.10047606005849163, 0.22273958664047266, 0.6973236928880455, 0.17499747066242732, 0.22520787266522524, 0.5966221683932317, 0.28038181557391373, 0.7854285350930542, 0.8487996332080989, 0.724325571475896, 0.01105280328893532, 0.00856759873431645, 0.5724944456431624, 0.24203403988209216, 0.24866883767390846, 0.6660880850799602, 0.7669113934136605, 0.2259131717160393, 0.4401472600386166, 0.39055828918154156, 0.4685368259555903, 0.5283396234514852, 0.8593547548976116, 0.2184731918792827, 0.4966370370932145, 0.5382038309106565, 0.5016009018127556, 0.6032240854946379, 0.705174367829755, 0.7244475049459729, 0.29833085874786225, 0.7584374319194209, 0.6680965221985065, 0.1198485288939578, 0.09150062133693715, 0.5555900375335827, 0.5114089269308888, 0.9811678813234447, 0.6127826379177979, 0.2945347853253756, 0.0517283300116157, 0.22212482640153752, 0.04966359621291461, 0.5415474287879367, 0.8785553956513078, 0.8572676765369062, 0.6486601427654316, 0.886731770037879, 0.5262927425521186, 0.6176595173539665, 0.2052924784860367, 0.9110965452374803, 0.4220743127988319, 0.10339962026513061, 0.22111971609849723, 0.8733448632848139, 0.8667603919394242, 0.3233528364182555, 0.970055020021936, 0.6273925572904507, 0.9089928133423892, 0.2390608142829237, 0.7093428911974562, 0.06385906767783378, 0.6059922523732413, 0.9776605904161901, 0.7949941376486966, 0.9322509178273188, 0.8298203664118893, 0.7077374027718151, 0.5171393793169429, 0.24528412368231467, 0.47411741303319566, 0.7823904666645469, 0.057674917484328514, 0.5927686085975317, 0.6438651723294552, 0.6453916238705656, 0.0907395676139352, 0.5997046504166486, 0.16951491431926857, 0.16916876015632365, 0.1959746145598289, 0.4517170494012932, 0.5768578382324521, 0.5474472105657922, 0.43518353169931023, 0.8806803216482366, 0.4653058292718826, 0.6007337503162496, 0.15492196089314447, 0.25436365050432075, 0.09978841913224135, 0.36942984290519465, 0.3207123339383616, 0.44615235149161014, 0.9052616416253046, 0.16721194688796703, 0.46299211379579597, 0.9743773831333954, 0.4678629745825187, 0.8464183141598798, 0.6205680231010715, 0.4955127021498438, 0.5930357654348681, 0.8875335325436985, 0.5042633265994807, 0.11147551986399562, 0.9484861822865814, 0.06646325447929968, 0.4716086950835793, 0.10849201253320517, 0.8286236542346546, 0.8761433335324998, 0.8028417704419626, 0.6834669420995756, 0.6171759725528707, 0.5831292460286539, 0.1991444715080971, 0.9335226526456255, 0.5959585011283292, 0.7851631169666903, 0.3859605967501456, 0.8853490248927475, 0.8503165088612943, 0.6023168080738214, 0.1974013445185807, 0.6232331931455796, 0.15554822363893084, 0.18216223896655648, 0.5421596020044147, 0.6381136527701177, 0.8936558733304474, 0.028520242465865597, 0.2070182304893441, 0.36473040439931526, 0.24606031003721707, 0.77369206228331, 0.5409517259831722, 0.49991932465697586, 0.13545459608372457, 0.4056780638593387, 0.6809843821296023, 0.10232514148824601, 0.6487606009539737, 0.6347410558616868, 0.13038261841178223, 0.6622848345083607, 0.9631913798538567, 0.0377716996426225, 0.18042270286680884, 0.3003582816425122, 0.11871241163253698, 0.8542664196452628, 0.8788894679619493, 0.003961567699085178, 0.33273203216399716, 0.8243289827488576, 0.9916256585063536, 0.3437830482107813, 0.9366421207810031, 0.25695858829232787, 0.6778654253832919, 0.42513998173563583, 0.4288682171952134, 0.5959889940436257, 0.40574981433822754, 0.9241599248911967, 0.5853774153135333, 0.1113950457012608, 0.9713358966695209, 0.9346469313629154, 0.0461319875244407, 0.9852837120249143, 0.35257538721441517, 0.00872042727832012, 0.30476474162332456, 0.9847393793301539, 0.5291528070729893, 0.21278989091648282, 0.5687925066770816, 0.11779364492971645, 0.32973684821820193, 0.24015594290155706, 0.5289717875982063, 0.15414220737530315, 0.8301132683322127, 0.6225045477287461, 0.6789410046346922, 0.6588328806310528, 0.8188311368125115, 0.8647879291616517, 0.4600816428789777, 0.23499970662764025, 0.37140875737670753, 0.8914617672856966, 0.17157060820993786, 8.205282540934E-4, 0.6298093954285894, 0.5367757622971296, 0.28188461803364107, 0.9362265752373964, 0.47081111221387884, 0.9377901729746418, 0.5055567531531328, 0.6264940241480687, 0.8650588524373732, 0.5960183107204349, 0.7677741242784863, 0.10269932956942673, 0.3780016246256557, 0.5620709446165552, 0.9694450359693836, 0.933121462407163, 0.4445806507061575, 0.6674057270213161, 0.28665276578253385, 0.4550261807836219, 0.7614494832255424, 0.9782606241380809, 0.5909521899589086, 0.052868251213725515, 0.3836703316392802, 0.6790775543289526, 0.46075488972409917, 0.6867999342152153, 0.887245630436948, 0.40619854002739475, 0.16908678268923327, 0.4544750987347992, 0.26450692836763057, 0.6473434103623735, 0.9792920516097922, 0.8294899411225777, 0.05629863712074901, 0.19835482519347458, 0.05779586330421649, 0.3614031588365264, 0.5930568787968059, 0.8259224864216936, 0.32182733555090803, 0.045129538426725624, 0.11629851685191461, 0.22347552811426952, 0.5800436427885461, 0.27160282625736865, 0.982699419983873, 0.0671582364084281, 0.3952849199522991, 0.25695517737348994, 0.11485485260515493, 0.4797808887508721, 0.20122857715369213, 0.11406210836224873, 0.3559791008578578, 0.49286433666521645, 0.33850128279409986, 0.27815331166412216, 0.4102155527301906, 0.16037304814518305, 0.8408451080273066, 0.8272912791853888, 0.6058922461172702, 0.8224582991737999, 0.998224086784106, 0.3488715812614094, 0.805972407810927, 0.6435095835531376, 0.951296229446385, 0.39489958642176026, 0.40811316478198145, 0.9560388710556453, 0.8304649820989894, 0.24165045927462658, 0.5261596833327487, 0.13039890706298662, 0.24276329179837008, 0.6234207245255009, 0.12556667546244027, 0.6600635209576732, 0.23111277677407993, 0.3454312946333662, 0.09715204641208297, 0.9031739717047632, 0.18303896584135204, 0.1975429116304377, 0.9967530621985101, 0.45328246564245, 0.5497131305035111, 0.38829759595640856, 0.4527680540618715, 0.4257003751544939, 0.6512301428259963, 0.7979000226807533, 0.0492316678524658, 0.04058494876943397, 0.29032087173317245, 0.709105243456515, 0.8289854639941937, 0.7598752677863817, 0.3742364477811939, 0.31658019018163874, 0.4296694102717833, 0.8924146945732124, 0.25333141418323046, 0.23815821351698385, 0.26467461778542223, 0.020073207330584375, 0.024911000425032026, 0.4555076022516509, 0.09186064427310103, 0.8174103154805459, 0.6221974844413706, 0.597085897661624, 0.774756149954576, 0.8383951061194939, 0.11080955524849878, 0.24285448308132684, 0.03412422997988984, 0.6259269928751271, 0.24893716737694405, 0.9780784142894727, 0.5121892057250227, 0.06337692727020128, 0.03243424545158502, 0.2526387843140956, 0.5274845360390163, 0.23209594765935138, 0.6423398609967829, 0.7126360023464902, 0.4851965327789085, 0.16481382130063893, 0.9398782038402291, 0.5626642967825557, 0.026042111588866712, 0.7920776100400716, 0.4127762294492531, 0.6899888878549783, 0.646132652126206, 0.06735639677998362, 0.2667773375178327, 0.7359593593166739, 0.7009409119664052, 0.7261648785277657, 0.17751829131189367, 0.035343794429343545, 0.4184012424297596, 0.3855351815892639, 0.07047546242456582, 0.36087021095529914, 0.7893375959590018, 0.722392876764989, 0.18047618635462637, 0.7081132428297912, 0.9778282632831884, 0.28286954370966244, 0.557309067107611, 0.9349654389490286, 0.1997797423354969, 0.06931109898463916, 0.1302574822424032, 0.9302843098714686, 0.8548967059138615, 0.42771729947780757, 0.4219179490284668, 0.12790781475498048, 0.06539888344194822, 0.915574643286551, 0.010455750633791783, 0.6050824329471035, 0.6742495489618727, 0.768521419786577, 0.8794880002410411, 0.7084494563214487, 0.18632489812272524, 0.3040102670707535, 0.8660741027760095, 0.13608711674516838, 0.09786699407174548, 0.10110978649922775, 0.5198323484937505, 0.6707069739414433, 0.5527276394006523, 0.07781401596997295, 0.8199904811081346, 0.3069555233023875, 0.2883241640670192, 0.650704506412921, 0.3622171976445834, 0.3448725305225119, 0.38989237642977026, 0.006536436291196157, 0.8233705683363576, 0.13191009416746258, 0.45853585253451346, 0.14129708521674378, 0.7398384020789885, 0.5275172127815245, 0.4167351869247381, 0.7295113548990749, 0.8939346858099074, 0.8371467297072165, 0.32439408290532534, 0.07504523117281914, 0.8928552903829005, 0.9166429645867825, 0.25916443999618877, 0.3643852423793682, 0.8459850865538985, 0.38331957747448375, 0.5267051329145809, 0.19434825406727763, 0.3988878996206331, 0.3866393671974254, 0.20969487067451142, 0.8784024207088833, 0.7660995752034793, 0.1892586789974634, 0.33883211780312483, 0.34925670249981267, 0.8198836511822141, 0.8883011823463698, 0.7747202146880181, 0.5701032281276616, 0.7383979868553981, 0.9670768025813479, 0.2264492889542672, 0.24287279527666017, 0.1942601287387934, 0.009063591117264624, 0.700850778118099, 0.2590908867276084, 0.5732876880493645, 0.8288217934383278, 0.07581455111070601, 0.7773978338681076, 0.25322984770966506, 0.47861064968092815, 0.42172239478506324, 0.03152343294467275, 0.5435942370145508, 0.07483041855949901, 0.15696618350139036, 0.9734828313204076, 0.49021343091037495, 0.1550135744667822, 0.11668252758907738, 0.6389871046692884, 0.381983612262773, 0.3239402090081259, 0.13825015626473236, 0.6855385669349436, 0.4622474746662292, 0.27655524955267974, 0.8227603019360286, 0.8984072098860533, 0.04358224352124218, 0.8957154633123011, 0.7185842584659329, 0.5856614734678756, 0.9522931251799003, 0.01439683124116442, 0.2913264286383983, 0.6906529674149096, 0.9877008592056526, 0.6048436538661367, 0.6938653471384433, 0.13883139479975914, 0.8713520294170582, 0.6112429096607803, 0.5308491562204627, 0.4054923521153805, 0.982568898516562, 0.3778584521715883, 0.5239258069874553, 0.5420375835754659, 0.029295494034208613, 0.6411615717470499, 0.22715293272422332, 0.9305532786639328, 0.6869850478744123, 0.3523457563910819, 0.7164456866476359, 0.8499892077318932, 0.15331327074350387, 0.17571534115399967, 0.48258553696577355, 0.5319474617398264, 0.5127909105464661, 0.36878875077852713, 0.5942265787812578, 0.7600665640504388, 0.7828883157287729, 0.8915595257153659, 0.5655002624809575, 0.2242130557615225, 0.5220733468292664, 0.015208536921080373, 0.2622335683479097, 0.77916926020115, 0.9202036062314067, 0.4046640746662299, 0.6114592493861521, 0.47723247906423505, 0.3630023371777037, 0.6347562247982108, 0.8408115622010971, 0.7451176006684221, 0.5648873395686046, 0.36631517077041176, 0.4675642568203875, 0.35778139900082784, 0.4982101366122934, 0.9564131502503016, 0.28148212317724175, 0.925263490179223, 0.5120028435717775, 0.10605286073004716, 0.12132120216263309, 0.4533655734292861, 0.2296183567289125, 0.25895508451159854, 0.3317271292829721, 0.16496702296849264, 0.042189218233809056, 0.8567011501883522, 0.4054445436236298, 0.17600135370560976, 0.273618929907114, 0.22833690123406136, 0.46516552270724265, 0.8085950342497882, 0.38285923871864624, 0.8466462334026515, 0.9200078547578356, 0.29359626897387514, 0.8905153610732669, 0.9186540062411865, 0.8435293277031435, 0.3656979684903442, 0.06936057677482488, 0.794519991703829, 0.36334694316634564, 0.7865861748751484, 0.8221305419896079, 0.47683648134829393, 0.6268453436269699, 0.14502105028597112, 0.5850066546395624, 0.5914441849501196, 0.7131215564625533, 0.3774847084641608, 0.5414872130504876, 0.5412325827644746, 0.19822847611257666, 0.3290063434029604, 0.9088834194430234, 0.20599206030946593, 0.9489420948266368, 0.3310018230280748, 0.5684675189202487, 0.47423747835746566, 0.11969331383426085, 0.2114416763318403, 0.8503381212313912, 0.09702343587771001, 0.25796744027586227, 0.37238731595960184, 0.8553578100492455, 0.8391238568460692, 0.8853899510891026, 0.5709128783591183, 0.29905667319099316, 0.6695496630918801, 0.9148803443285306, 0.8216556539922262, 0.4961848309286392, 0.78123015164035, 0.7886702985735575, 0.4027153715570805, 0.7696354760264394, 0.5587845626987417, 0.2776463724298508, 0.29134859754566145, 0.2637498867047309, 0.22366324336222732, 0.46939135197180837, 0.48188164465416927, 0.8695541584151505, 0.7775376115780058, 0.590462884070469, 0.5454913845969097, 0.7282667639350195, 0.03767136141495364, 0.9578614297626715, 0.47998048282265726, 0.5694554507673603, 0.012105706148362705, 0.5353042332304507, 0.36739929620001766, 0.9615100939642942, 0.5978436835556475, 0.28183576790617726, 0.6083446358083293, 0.4046385473564236, 0.60181977220515, 0.7234692135940303, 0.5339903268169948, 0.0803801358686217, 0.38229291263291587, 0.9529676392788142, 0.010382880395279459, 0.9866718536735485, 0.9874023010486664, 0.5685374770603071, 0.2442606698242803, 0.13379027256477105, 0.5279769643652854, 0.8991213482656535, 0.3756327349474399, 0.4540318987548754, 0.6632921637083271, 0.23214067432372176, 0.5995788680170926, 0.08678365151835066, 0.5013160378718982, 0.6589532758289226, 0.4982102067030414, 0.7406740783670261, 0.919093118397796, 0.5839548448838153, 0.9834551532115354, 0.9057849283720706, 0.29426138909570443, 0.9051671839002134, 0.752312822113044, 0.791442105656593, 0.9053019681255218, 0.3673203789528102, 0.4384421451417574, 0.9988936417849572, 0.8059720415777063, 0.6128501555815719, 0.7074319707224466, 0.10322179789678576, 0.808472731441748, 0.011895415518842545, 0.387823113377075, 0.5151251703533497, 0.3202556131614519, 0.4392953427497488, 0.3559311630628055, 0.2207459045733554, 0.17097316322603495, 0.7847494237164806, 0.2997440842150647, 0.25650595636669926, 0.2389294856357559, 0.13171772618550714, 0.675646151098482, 0.06595600032378357, 0.6404898469353302, 0.22130282431177617, 0.14144604842959818, 0.20692865669635618, 0.4812588013686483, 0.02926923118561764, 0.500163206221144, 0.22982784249805044, 0.6844380238532749, 0.02751918238664708, 0.7212535592804061, 0.9316741663406876, 0.2096272531702068, 0.975759455933504, 0.9194320323262655, 0.6055662094043919, 0.05443237331020112, 0.8947558950850634, 0.2659758649044368, 0.3515059588578735, 0.7915970247774061, 0.20948812461816912, 0.6833693183935058, 0.9920757754705487, 0.03597522978947054, 0.9186800172645435, 0.8313769166496594, 0.6452439201777216, 0.15851421327708592, 0.04659566413839589, 0.3311091622355522, 0.5466139723286956, 0.7685182646250985, 0.56365521597066, 0.3933704943291241, 0.2847230231663018, 0.9708158300898525, 0.42433809833824143, 0.01855700313665698, 0.21553236970280965, 0.17105390213947413, 0.36400613149961003, 0.7175966632960603, 0.45604371396093624, 0.250194838490885, 0.6206924276428173, 0.266902646844943, 0.5220125623595689, 0.2583929375103764, 0.8035663818357103, 0.3550357521637608, 0.3710200503533403, 0.3887791827294299, 0.7166989786130215, 0.10474937081699687, 0.3397030299463163, 0.8832841866318418, 0.06491671919687081, 0.3613164013471596, 0.22273174053213407, 0.6954813188770186, 0.6179467050236959, 0.32651473043172485, 0.5311630230324034, 0.18953289602840395, 0.5897190911871689, 0.587373416764435, 0.7890865471456122, 0.889674507939996, 0.7016077685216846, 0.8397597336970255, 0.5800199943315157, 0.31127383994480917, 0.6415534058622192, 0.6391121651400604, 0.9382990932372838, 0.20235176296820745, 0.4054278796571682, 0.32410250435515575, 0.5957463974532932, 0.1035554079876333, 0.31266274575588116, 0.8537355507214393, 0.5401925573668117, 0.9949241651808458, 0.32507819835352336, 0.6743725123144759, 0.31996266273449203, 0.9393911543332886, 0.6660137929210983, 0.8903897510570015, 0.5372291678089925, 0.055814612204659886, 0.6362754906759226, 0.9506620054035113, 0.013172105442776139, 0.8584346722945904, 0.9540781727805064, 0.782785161429831, 0.17917624391372788, 0.9850030205415328, 0.9080765272284388, 0.8079304308023735, 0.3508342555284186, 0.6024343025132743, 0.1057414564878627, 0.5514485244290256, 0.6753134039469842, 0.32667958925301344, 0.623753099664902, 0.62781850249922, 0.7076828634059013, 0.3226240675618578, 0.9227457009592878, 0.7232629550231785, 0.768087754550919, 0.3601622885398402, 0.9756536927973389, 0.8253278893913106, 0.4591946760599206, 0.9942065887135949, 0.6770720204062126, 0.35595141293509047, 0.9821230909251009, 0.7092345618058518, 0.7504584942610456, 0.053022964311502885, 0.17911552853043322, 0.8230847725446909, 0.050669344200504396, 0.41516057855126154, 0.5524891554572016, 0.18005979976509623, 0.3712335333509651, 0.27541064075380706, 0.8619495693997653, 0.17999822429320156, 0.6089355792321811, 0.6018010045402343, 0.28613763210559906, 0.4878287763472082, 0.4126903106134546, 0.9361548791398757, 0.5493183814032562, 0.8472205870429154, 0.24935741354657515, 0.9772997916081848, 0.860410767800078, 0.7822961802767716, 0.1560574772179154, 0.690781703135533, 0.9890957189289143, 0.6129743224501898, 0.3167152997963222, 0.9844221597547301, 0.3125289777880983, 0.13236246933464102, 0.9999704563057924, 0.42753134511212276, 0.20622461607697562, 0.4987189160152018, 0.3262592368968459, 0.7113181560067692, 0.7239637955793984, 0.3798575909588716, 0.7937853343734178, 0.5490135177239717, 0.1141226690012257, 0.1544689406591978, 0.4862623727084523, 0.49645063902532793, 0.353602233843761, 0.022682490719427628, 0.4097233842727842, 0.7373222295310701, 0.5455820748396252, 0.2072981329725554, 0.4613581280900929, 0.22206090822309432, 0.723609013772253, 0.03746467665283437, 0.12025236162220565, 0.6752662981004612, 0.332070551331066, 0.5981856849272458, 0.0680671573427526, 0.8938281401393572, 0.41189263239922114, 0.8018844389937807, 0.5971109734638556, 0.4463718220532482, 0.3103392500392167, 0.19236118108998923, 0.8439207618089343, 0.35437899225945213, 0.5550818669563874, 0.526827523903259, 0.5983825641025926, 0.586312802743611, 0.3852442417657034, 0.19830427237098525, 0.6815864979514916, 0.22830345506904515, 0.3159186634045824, 0.8585208085761836, 0.6600243052043534, 0.008426512312870948, 0.02768747100674862, 0.18055533007999414, 0.9694026190300228, 0.44633340938790134, 0.8189737921476236, 0.5608071414065261, 0.3582583746727793, 0.2759691655056453, 0.8365836760791244, 0.7014935364030995, 0.9297274120730427, 0.9463399623228901, 0.30859156825116507, 0.43771555931677997, 0.9592310910073902, 0.9437689613777043, 0.04375943253986547, 0.8772382750923212, 0.09650974888918018, 0.39880587732384465, 0.5329697136972221, 0.9064831129850202, 0.5223463610021024, 0.9419320448319947, 0.09069049615063263, 0.3828305988563707, 0.12348702457432748, 0.054429387748861746, 0.6082809346686778, 0.8811847728466888, 0.7736797725658524, 0.22425822314444355, 0.6559839382872976, 0.6918504360790441, 0.36441682460973013, 0.06151559766395176, 0.8667419114148641, 0.87712734113057, 0.3158794148526428, 0.15402206937239227, 0.7625108998683551, 0.5856263059029636, 0.916748620667814, 0.8508117071295613, 0.4425366983756217, 0.4961638055531804, 0.9909597500321898, 0.34977637446714416, 0.843096836682339, 0.21719349487780548, 0.07014141153764475, 0.43544239235874826, 0.5994999862457677, 0.7030843654048442, 0.4623949839669389, 0.9638334980270904, 0.893674717109402, 0.265156950120666, 0.35123412337687576, 0.7236014364384991, 0.05446723110795848, 0.5532404091894871, 0.3329177609377284, 0.6160813485448992, 0.0928083058875574, 0.9626152817719557, 0.6060744398329225, 0.19165606765884025, 0.8001972140745849, 0.2815575776938676, 0.3644297861460587, 0.4557900869776146, 0.5164908384565462, 0.03630210734273365, 0.8116127048768651, 0.5153200489871688, 0.18177385030217152, 0.9130942885058306, 0.6164305662136979, 0.0740657853042519, 0.8271263312885418, 0.8411007954607461, 0.5576669935759079, 0.0065519384795488245, 0.23039308649040113, 0.8053018931102041, 0.5693704467244861, 0.2396072754607662, 0.06559879548574876, 0.22508901297443196, 0.3907656434706146, 0.9538347057274345, 0.5084414300577522, 0.7821428202301804, 0.5493340401715224, 0.6804225022733688, 0.9253364276907545, 0.9102694681982882, 0.46127337903564825, 0.21349278885543577, 0.9697721055680637, 0.7702227051794517, 0.020460767246979428, 0.3841606083294854, 0.1372765745809167, 0.42414275506995835, 0.1652075081547486, 0.649703261456327, 0.5890853294459512, 0.09709313456442115, 0.5615081950557974, 0.13971596754978532, 0.8446376583735484, 0.8672788325634672, 0.722150270934614, 0.27085682890046725, 0.7643187954129356, 0.8618808943430514, 0.592964917542244, 0.29276038794999426, 0.0964047909357626, 0.052043215492318495, 0.8806635441169375, 0.1599254202633782, 0.7459546456153726, 0.038400238820963106, 0.1711187883704629, 0.9378599909285613, 0.8384347796379986, 0.7976342992881708, 0.19261239119519624, 0.5464921623638744, 0.59714911673359, 0.22090426975702016, 0.41548713978928653, 0.019832547984640625, 0.03108708118173531, 0.4165878427347438, 0.547803356021641, 0.6181003009908161, 0.4385914862206097, 0.1726316674875339, 0.3860149541846305, 0.06700192376348812, 0.7722868759269965, 0.6779051430013783, 0.9103441315721154, 0.9185773102962957, 0.9819978597593514, 0.5873052134186093, 0.47644745048639026, 0.5290058161156661, 0.5549265879821504, 0.7819608599006783, 0.4481306432151819, 0.43099007743049256, 0.6061468050663023, 0.7237380999266072, 0.6402831638918666, 0.9418128087678056, 0.03751194162522298, 0.13234695665943186, 0.49686766406312566, 0.6928880515965217, 0.47936255939506656, 0.8237044893679862, 0.015713824610449123, 0.39260520296280277, 0.9569589314732938, 0.939808796083626, 0.050029575446016716, 0.5414899540278647, 0.4823522421730735, 0.47323044489836896, 0.7659574195653859, 0.007183949141002399, 0.0624479683325444, 0.9434300605724288, 0.7161671591184037, 0.33647063259290655, 0.9353034930288507, 0.31746146383409823, 0.20139045218472906, 0.43255157132553823, 0.19924130247404803, 0.7842220654753761, 0.3349669820857568, 0.7580044100378053, 0.3831482886403109, 0.7892630566310929, 0.4998857767667011, 0.5373297405595114, 0.9213701874335457, 0.8162744546226015, 0.6934693277154576, 0.5277209060751906, 0.9428999621584842, 0.7617104010485921, 0.5917623578276989, 0.8026675316192085, 0.2620978041239117, 0.3906229592810564, 0.033851122260742605, 0.6502297046816605, 0.9669687539540501, 0.2846232985057633, 0.025752950938570995, 0.126296639371427, 0.5410644456114562, 0.8969908144857862, 0.29418016063968955, 0.022870152285374812, 0.026362954694008178, 0.8153030805969482, 0.8823962417218991, 0.012389730560144807, 0.3370210195976703, 0.09855987907766017, 0.27354653670526874, 0.5113425166456861, 0.467681379277768, 0.6036271488811417, 0.05125937246069434, 0.36987846816092096, 0.005057093286080616, 0.5449278224286218, 0.16297802143280105, 0.8388767399520394, 0.0478037483522642, 0.1416578033620567, 0.4383975196511085, 0.3918870637132964, 0.3672299772600721, 0.09840767005501583, 0.13354515269981704, 0.8865949935923426, 0.40018484259524545, 0.8379214078528202, 0.920456310388541, 0.2389379469236499, 0.45550082718218887, 0.8588256911204502, 0.9230627726340768, 0.25272436497558515, 0.3366591629485335, 0.32651434647597743, 0.11182368876567661, 0.4985855346086462, 0.4358841779843824, 0.021974374514164285, 0.6127937389518415, 0.16831590621064707, 0.23866188003401867, 0.07119175243762232, 0.2612373256456392, 0.644134531809538, 0.0927170607230724, 0.4568760667244298, 0.03556146430577012, 0.11712627816853194, 0.041772694175475245, 0.17459545587575365, 0.8442538775149921, 0.96509899301662, 0.5019540050097813, 0.037014204457468836, 0.5066774794511101, 0.7573181973782217, 0.5674886798316092, 0.552777377790831, 0.6679861058233847, 0.6920583304649379, 0.7723942783568813, 0.010687990892899846, 0.8190899813455599, 0.9926359714374502, 0.2061322068721977, 0.8851744517801841, 0.5545146766046347, 0.288566445286483, 0.9837473002707686, 0.9456466811163928, 0.6941599717734049, 0.29071257625775526, 0.20480064580208324, 1.916656626970159E-4, 0.9193802271029549, 0.13277050375610444, 0.7004428730046445, 0.03316025694311975, 0.12947108917033578, 0.5961639722292381, 0.06426358428643464, 0.6065490588462615, 0.8115622882311128, 0.06139530344837285, 0.6900922189572839, 0.786682068076815, 0.3350792549518118, 0.4361276416156119, 0.7987142397302939, 0.5305492451726795, 0.2313514914998397, 0.4987497142897209, 0.7255061015515215, 0.4202600633558372, 0.19960872130911833, 0.06590094740742092, 0.06228092192569268, 0.8694215876651511, 0.7925207477250277, 0.14341117657599922, 0.5991763995584453, 0.44185306074898034, 0.4776002766975298, 0.7523360053713685, 0.39620520816761406, 0.7208992298345802, 0.0452023700444113, 0.43524495700661114, 0.7291272999423197, 0.24670765912288017, 0.13951845675105, 0.5426470495032465, 0.10059270720382696, 0.3991853260366721, 0.025876597582275784, 0.2754137499245919, 0.9850422780265528, 0.7459527843361501, 0.5758234795952366, 0.11628678145672722, 0.4846429477599977, 0.29746468298663353, 0.8508786338549202, 0.7220346004852785, 0.6135733802330159, 0.3155675099349947, 0.5965143882141335, 0.5675475723968024, 0.49926443936845943, 0.8071170580659023, 0.41982963390367556, 0.6341388487016449, 0.39173868762238817, 0.6008789140374357, 0.4175497521421686, 0.21654431332393465, 0.005981254977530437, 0.9537883637806216, 0.545398418972077, 0.48659160170237103, 0.3873145872465431, 0.9617456499338026, 0.07555197155278415, 0.7962346556578347, 0.18603742893891995, 0.6604760463580269, 0.07580006051914989, 0.8286269472407801, 0.9551287667935523, 0.5935841782551379, 0.9622015285640788, 0.613133147554288, 0.8436052143763095, 0.7977848207852343, 0.8264373449756076, 0.10865512521807219, 0.8481604477776151, 0.6093931519726529, 0.41972744490006364, 0.5293755367351665, 0.6070037841052908, 0.4315091569364694, 0.38709177512497817, 0.8379978628084058, 0.5723540186236483, 0.6179329542339487, 0.5889002087714261, 0.863789261017308, 0.2818343073490396, 0.9276985724333563, 0.12106997795542962, 0.3162082911149322, 0.36405209861110577, 0.5832159771566879, 0.9509333034545341, 0.5596267922011736, 0.8599378001553917, 0.8253621790383673, 0.9227119736986354, 0.3906315222844642, 0.418954723017986, 4.643212104631367E-4, 0.25469978669708726, 0.21661751922883732, 0.938081957431182, 0.6369686052812803, 0.5496675707822188, 0.972862163448852, 0.2515105835720477, 0.673691062101094, 0.7706700012750861, 0.8349949778332486, 0.5502834017524171, 0.9868974962495853, 0.5963469614325088, 0.28475519659803783, 0.31364651536129273, 0.6300611761922317, 0.0629767391696544, 0.3691553584574845, 0.6676711172818852, 0.7479991081234568, 0.42495202852330616, 0.05664612077324893, 0.2517418125112483, 0.9561886215557918, 0.7210140812494166, 0.4386034812677393, 0.8697980478451591, 0.0864179078135906, 0.6204942521428772, 0.15043695704865634, 0.430753273208463, 0.591525673136672, 0.7419761827729017, 0.7938428629427662, 0.9413062475169853, 0.5748365686226536, 0.7862060319486778, 0.3302043032626013, 0.6043974148167202, 0.364000703649474, 0.5057423234542242, 0.38486559467694104, 0.39785270433004427, 0.7842968161810262, 0.745750889098931, 0.15298528645807707, 0.8602961545461519, 0.8030609333757784, 0.5335142465373529, 0.12989885724533734, 0.19520141172259375, 0.014752941882880677, 0.46863959479856043, 0.2023984419091751, 0.21899197173866491, 0.5152760052035663, 0.47161235149137704, 0.7320638298208869, 0.1253882197411097, 0.07451462433779121, 0.2852579649200856, 0.13775494201008842, 0.5157390632966979, 0.15765901983604502, 0.9918367275191793, 0.1416034980170492, 0.6538647782219164, 0.26873515173539997, 0.2079126897341429, 0.2813169431330629, 0.4439765753739474, 0.29386095456669536, 0.5497994062274094, 0.5113355872326417, 0.20152773888947217, 0.007101246054079358, 0.4243015715095938, 0.7163591964382044, 0.8893902067882449, 0.6683950334925752, 0.19263400691468258, 0.7429868660019331, 0.12553928272614256, 0.6908808576825977, 0.27981426334640014, 0.11869004254102133, 0.9334685131443815, 0.6840469949144369, 0.8574892347822836, 0.9720649634702648, 0.9028456536411872, 0.7894851090339867, 0.3150698298471625, 0.7942881818897712, 0.15545996125790273, 0.11762765243233952, 0.8522121298528179, 0.5889240872593349, 0.27029951892463266, 0.26670052475261885, 0.1750974092550196, 0.6457114078137155, 0.11163727893450726, 0.35922416487189224, 0.4596275641539944, 0.6436808677987952, 0.32529259164460034, 0.7667481964802715, 0.45656617100393126, 0.03993359723680323, 0.12077497833272, 0.7101057782504576, 0.8568202500314309, 0.7326364248156535, 0.8408049091684642, 0.22032556529676817, 0.8094708259573027, 0.8002660193580181, 0.7347467395255021, 0.5244409392061905, 0.7908254069703762, 0.7138612769389032, 0.2987766590740262, 0.7807875219550392, 0.8596789652373598, 0.795019592569036, 0.5231485399390505, 0.22998144624169492, 0.7021342678338568, 0.8495987952301, 0.39570919250024283, 0.25062288800580246, 0.7687464923718128, 0.8455639785470744, 0.050853791601355725, 0.5128702476325288, 0.23742096677791247, 0.22314400786182254, 0.024401093851949218, 0.408382583050934, 0.49740732780267005, 0.9264399128255819),
    new Array(0.17740721379437674, 0.20172903664007924, 0.3428967140799446, 0.5278535238099639, 0.9857259990621785, 0.8962156678806003, 0.08914368773664305, 0.8801810258590972, 0.05716289092911753, 0.6361818132947834, 0.37969765857981275, 0.5759433604300472, 0.9343579642712966, 0.5781694718756735, 0.5402432281407132, 0.11950133781809169, 0.46907365301939763, 0.5549707645548928, 0.9527128570597645, 0.12473025651899794, 0.3123508908620367, 0.5294103297066286, 0.07274915469662524, 0.03950489719695904, 0.3550371615183737, 0.7888207140631427, 0.3942582520739323, 0.8679733674912754, 0.2744782929973921, 0.06652078553315643, 0.8767097906835533, 0.1125733366890348, 0.6957057559372196, 0.2932082921408493, 0.09400317441103112, 0.6899721999422771, 0.8592394144115496, 0.47902979718627003, 0.6381335769428355, 0.8885882261937419, 0.10266560047221518, 0.30619220390166557, 0.11655554737247265, 0.5300770787308922, 0.90943830097579, 0.3723321189121066, 0.4190559288387973, 0.3731439144533576, 0.7558919848939726, 0.6664607088716153, 0.7981119588722424, 0.4552686073511434, 0.49624164952502403, 0.7821530151795909, 0.706124259645686, 0.5064075082165023, 0.5653865647942122, 0.5767527421517014, 0.2635790244099141, 0.7884621539544746, 0.8506220320163055, 0.470714700197998, 0.6941070960858367, 0.7152818815915171, 0.6859030452665286, 0.3478087085533209, 0.055572124966761116, 0.39019354812114104, 0.05609272528692666, 0.06476066309716522, 0.12073404993450831, 0.761528401739737, 0.7636675327008129, 0.9080073722922016, 0.31669789072227694, 0.4413426987450929, 0.0066400525794408916, 0.9455941914600019, 0.21927237025083535, 0.3585051518131186, 0.5439996787881624, 0.11384505993560912, 0.21652652209164214, 0.324550744436104, 0.3837599364877944, 0.05128720100598372, 0.6052466687869783, 0.27917728513216, 0.71874104258162, 0.14641326391241016, 0.5646604009378394, 0.45198742445179463, 0.6565045769424936, 0.001215885280956286, 0.16370790821336845, 0.9280554777730919, 0.14239677235783132, 0.5290312293591922, 0.8013051654153388, 0.13712488506032816, 0.3584457378221533, 0.20307907708509643, 0.2534580296452926, 0.5997190018015668, 0.7958969511685771, 0.5511894104463493, 0.806749321319444, 0.8581739164424348, 0.14546071227154223, 0.8525560366600345, 0.7946363463616173, 0.8965793192665984, 0.12688380468481497, 0.133960371506751, 0.2211590029824787, 0.510839110705025, 0.3882473087524422, 0.9857593124978237, 0.05607399824450998, 0.028540890555334042, 0.6454309736611589, 0.4220329520556816, 0.21609371072174344, 0.49804924158884967, 0.30347405456730814, 0.9946395462549529, 0.20882276519431098, 0.967215015266025, 0.9041013401960714, 0.6375265317949865, 0.9091497049356462, 0.7543187082419583, 0.8774721004430724, 0.26549809860208884, 0.9622643924873834, 0.6773431533306176, 0.241249289740732, 0.9807411923383708, 0.8631369062046804, 0.052396857731472624, 0.08637449392386365, 0.8507637639957155, 0.849206733781674, 0.898086162942518, 0.9164739948894058, 0.6130000678584036, 0.36119586973494455, 0.18986102121484627, 0.1666098937558469, 0.3341899801935767, 0.9763730808046502, 0.1968352697216068, 0.5171296699594994, 0.006740404098491082, 0.39926086976539077, 0.9033096388588749, 0.9396561769461195, 0.29962867384022174, 0.30669060544873583, 0.26820137503540675, 0.7647994494493549, 0.19800928267424556, 0.5872754313084997, 0.6078117927153635, 0.4449608393155162, 0.06353697658120683, 0.7897845440792308, 0.700838853184606, 0.10063863821629138, 0.7265204779534478, 0.4005666354182109, 0.30926926187139425, 0.3849339168987377, 0.5813732138025711, 0.9070841317362259, 0.6847600355899115, 0.6784939343088827, 0.2984284704942567, 0.472784229881003, 0.28734751594065255, 0.13591999373553254, 0.688038154584982, 0.4479465211547241, 0.3817966732494613, 0.6447049459906848, 0.45697609178144416, 0.8718111024919494, 0.39663176866433236, 0.3290556269033731, 0.08251799202439203, 0.5832052530780245, 0.9318645979555156, 0.8334937321714719, 0.7961719807025006, 0.5500509625471305, 0.08366427672008059, 0.2549179422220691, 0.7168853181800867, 0.5525489837973605, 0.31768792569371884, 0.25684936578603124, 0.5026539763261015, 0.41050004848455, 0.4675194450917569, 0.5958712753731464, 0.49981406361306324, 0.5321372673608433, 0.5606388960537807, 0.017813063072057544, 0.2608948285904572, 0.6800083273253223, 0.08157258882234286, 0.24001769382081883, 0.47476509045871507, 0.49885932935270305, 0.9703497581300965, 0.5260706473192008, 0.8069064930250671, 0.5311373838268924, 0.12411889015103383, 0.1806577601873186, 0.8829981631276017, 0.15764205599117243, 0.42075283399405494, 0.14475822531693538, 0.6655991899477243, 0.14402035324134432, 0.3154987063306517, 0.7551679014606385, 0.7715670973369876, 0.24821381344883864, 0.8752050733590089, 0.6473877035122693, 0.8569514570073881, 0.6496307305121122, 0.7093853871468028, 0.7272003498066779, 0.05645393822680067, 0.7977297325479418, 0.6333533124760412, 0.11379795504974144, 0.6061474872734814, 0.6458661176073048, 0.05589209271104456, 0.9661122950353271, 0.20099851377727596, 0.13566536430709009, 0.022396573233244066, 0.14403822745182027, 0.3428381382044221, 0.22785310852360718, 0.5641534948780049, 0.7275301176349362, 0.9197797283719996, 0.737384453250576, 0.50540142923213, 0.5190899671905984, 0.52468149391401, 0.7238796344292926, 0.1620390987278758, 0.7889552753694762, 0.568104756459099, 0.2127873837794786, 0.42932700578188876, 0.6873332560281293, 0.07031968644344866, 0.5783609759308866, 0.6006538513973875, 0.9443178241115483, 0.1272623446921054, 0.0064464264953458805, 0.8854157076403365, 0.7056639832222346, 0.43694783610587895, 0.07324589159189054, 0.0012829311628796969, 0.6113839894433564, 0.9456965687677497, 0.6256340343018356, 0.40460574225337087, 0.514168328454737, 0.627631630346689, 0.8292685704992007, 0.6924363319045109, 0.5559239410621515, 0.6462572309904724, 0.46265042693382163, 0.46062201660951496, 0.6732606125237248, 0.6635296172533155, 0.27845341679917957, 0.43464997939302774, 0.9865462833798126, 0.85968320752801, 0.5278567509922429, 0.0034014978131077234, 0.9421905914679014, 0.3061766512014137, 0.5492782771414677, 0.3806993596065874, 0.5241049449664943, 0.6944748494314497, 0.6598201509917534, 0.4955092504142753, 0.3278269142662984, 0.06498444011124171, 0.4559027538740392, 0.36888209004524974, 0.7995853751087759, 0.10331196245095164, 0.02897679263028763, 0.1742014268637534, 0.4826223652959911, 0.7751157435598448, 0.5328675651048829, 0.39702549620701777, 0.6843758567921144, 0.5561732834560171, 0.0012192259416657913, 0.5117915954940498, 0.5806678575602531, 0.2808884766966898, 0.3066714678139376, 0.37487551243433537, 0.4068303302879759, 0.6803139412385979, 0.6778143605083524, 0.09697637692121364, 0.05074080532036929, 0.009865486897372655, 0.2456318466916968, 0.5025233045710473, 0.05902903584434349, 0.777257124981731, 0.6780581796251689, 0.40977694463205294, 0.7952543578558073, 0.4727870404140121, 0.07943523901895333, 0.8725256579672479, 0.24764307908733718, 0.3769560234888979, 0.9810736667567532, 0.21275242770629355, 0.7740139798027332, 0.9745015549889546, 0.4297839206158359, 0.1433754463156377, 0.8928092797867063, 0.2392825788317593, 0.8931578253104044, 0.5311415255693602, 0.08168719669389779, 0.07105120590846892, 0.9435452478577077, 0.3819784856271349, 0.4289215789562838, 0.4629991100608848, 0.4570844960351068, 0.4445886781990781, 0.8978930284027851, 0.5580686045647302, 0.36980930709137005, 0.42279300687297394, 0.9112450594683583, 0.6123689557563552, 0.8697688158154655, 0.16311081110933212, 0.9388174581062698, 0.025640737418516246, 0.27226184212062365, 0.3412878951388466, 0.7822592053303414, 0.021562690251758054, 0.7246998657091572, 0.10996125930430256, 0.28926073676235786, 0.264796342079174, 0.31827812285334, 0.8893761150828318, 0.30163610462539914, 0.687016054857873, 0.145547523359983, 0.984046673459479, 0.744023250696866, 0.0607732883738894, 0.3361444352064509, 0.9904794332897667, 0.8937604969369052, 0.407895525620216, 0.12734995587641418, 0.024553654084099708, 0.03753611737406648, 0.1582217760443686, 0.5818131161313322, 0.6418807753574196, 0.9166972137961933, 0.08482832203841473, 0.6516879843745592, 0.9504408200636717, 0.5906423801283824, 0.4334998945912244, 0.9065976275914724, 0.8220203357576966, 0.6065129800286929, 0.3370526814240338, 0.3922523464935076, 0.2974531690959302, 0.6534356002315098, 0.5592177964884276, 0.7672138243229005, 0.25039194967159695, 0.20085823629663202, 0.8481448084440508, 0.0772104382592681, 0.12531441406714694, 0.9730616053133454, 0.696186559901542, 0.26957358883429994, 0.0976956585766342, 0.49571548132681564, 0.1004787641108591, 0.8247785094511922, 0.31775383250718126, 0.3653900658512237, 0.9979280889896504, 0.687737219445281, 0.9939029415325343, 0.33922047212449746, 0.4085755473038031, 0.01840572248374628, 0.9480239762718596, 0.8194618748126805, 0.9629023290903644, 0.1494307373691569, 0.9318908196154118, 0.8164623559787589, 0.41149744681860934, 0.5379763693324897, 0.4325652495998513, 0.013618517878508873, 0.9196080331091199, 0.42953440178114843, 0.9143009850712664, 0.12916910981331753, 0.43444426720700513, 0.41343621693286736, 0.44547365053856414, 0.3722200873341561, 0.17971331915924404, 0.04294860632894404, 0.4412803042000354, 0.4241843532375946, 0.3797072307314079, 0.2172494916475105, 0.8164281085693206, 0.041857687471976046, 0.6443721589164503, 0.07824360248873163, 0.186759016904397, 0.0746421269188069, 0.05713721085103962, 0.7620928234079415, 0.8847334675571792, 0.41596684733947986, 0.8988832975045694, 0.4634989922556314, 0.4609225870337872, 0.1677454269584252, 0.11428336033467157, 0.9201920417281895, 0.03213547980043663, 0.08674803885338711, 0.08084761771629889, 0.6057395324291929, 0.30653387663511544, 0.2030552731582821, 0.9763582753262918, 0.6307084198676921, 0.36706403166852763, 0.35330056593733616, 0.05698030782475083, 0.5953733345439166, 0.3267614268772856, 0.25519597519980153, 0.4561861980431553, 0.4115804158031846, 0.7829607952400062, 0.6648760642640819, 0.6937340618564168, 0.4170388164409504, 0.592170600717397, 0.10488339697337279, 0.9442903472784475, 0.9422273200224348, 0.8633475636822268, 0.6281579145129458, 0.2568896045261042, 0.8582664224756934, 0.22453330302050323, 0.09218217365398651, 0.3392756335188579, 0.5335208662501074, 0.35629175535705326, 0.4574727416681216, 0.22526967284691501, 0.057361803633585784, 0.5051130108490646, 0.6958979888561587, 0.12866301921265122, 0.551431222569196, 0.19092487500763589, 0.9968403703238248, 0.05373285837453112, 0.8819161690750124, 0.6050810755031302, 0.09301172328102958, 0.28033189275724024, 0.11075350100469294, 0.258670677780905, 0.692768252059697, 0.6706034793517788, 0.5793505525356619, 0.28572057454196875, 0.20206097869163475, 0.8547263963668816, 0.6053211508788714, 0.4318388914960488, 0.1466970403262602, 0.7446936259424157, 0.39089986156546475, 0.1660741000512802, 0.964375810980977, 0.4979824861714339, 0.8911123963565907, 0.5422410119456222, 0.12600296382538, 0.007073942700887237, 0.07044317736096528, 0.40569153041870587, 0.8670747498636024, 0.22613125492486374, 0.188655912126647, 0.292484272508717, 0.16246386009004865, 0.16274897109202635, 0.4995865084503811, 0.9001342985416412, 0.9617271864466694, 0.16053552664243886, 0.021142173309062096, 0.32260010169716224, 0.11709470651296261, 0.1773937279661536, 0.8404042499193685, 0.3368921515760047, 0.8825885414873398, 0.12471538020516548, 0.7546466064791051, 0.9046633114752168, 0.34025895173466025, 0.9743074396611019, 0.9172454992826791, 0.7093687288854517, 0.6183146010662867, 0.26271917166615055, 0.5568706575229768, 0.9880582629184989, 0.30596222224817293, 0.8267408170639758, 0.7690116520530846, 0.13659240778510195, 0.04106085878944088, 0.08919624128867121, 0.8408074620094961, 0.5680481551950642, 0.8492341334362493, 0.9807532457895884, 0.5633114504644933, 0.08630825945153342, 0.44687357162273744, 0.6313274056640537, 0.5097377793072982, 0.600304004809346, 0.38550492145913895, 0.2937558223229688, 0.31389958802567064, 0.34910782536343, 0.6112783908237243, 0.5727698456222379, 0.5699629580882759, 0.9340490960134175, 0.7408828710781523, 0.9238967667450754, 0.09280542334109954, 0.36125254919405536, 0.11397319311841014, 0.5597720506988743, 0.9276808552170904, 0.9864756257884829, 0.47223886095221335, 0.3554454632640739, 0.6785577792155201, 0.7238475074647156, 0.9365309810377929, 0.07961585555492345, 0.4364111105890355, 0.13108934665280048, 0.8060043516699096, 0.2953311152789322, 0.8319122389176538, 0.016021281330964365, 0.5870194105072196, 0.5715409832434469, 0.5113759904887253, 0.02263895305068342, 0.5745889815920625, 0.2259925269680112, 0.6404870869830068, 0.249768560656647, 0.25544298596637494, 0.6803090040596868, 0.8772430306685337, 0.3312859028200751, 0.7793239095028088, 0.6496951694927571, 0.6237141946725477, 0.5641115984190201, 0.7539143544531771, 0.8125626538603467, 0.2656358034779669, 0.6086714120427632, 0.6588375832342773, 0.30947179794001534, 0.5395111837316681, 0.006236652114628982, 0.2454607612811217, 0.4061366829806925, 0.12881886887954197, 0.25853666495201655, 0.39176952937046705, 0.9218427398401696, 0.08408089289474063, 0.49726189528762454, 0.01537204658928737, 0.5724768576382199, 0.6859634199468678, 0.8345523141000369, 0.8127290890645713, 0.20647242685842881, 0.9262446670441986, 0.33029283899265727, 0.7889964763625411, 0.02232283046608874, 0.8683997348345673, 0.1380139010558774, 0.7704047919329022, 0.2479180148249822, 0.7677154413153853, 0.7984216941599656, 0.3498903774192268, 0.4348117032307507, 0.9802625956384464, 0.8380592653856367, 0.006731017388177274, 0.4746265817449641, 0.3707172220124846, 0.8003266923230525, 0.462228249943484, 0.6801580356298712, 0.1409361512139995, 0.5870639090839104, 0.6860179408491272, 0.7903372332416819, 0.7443567950657516, 0.5211279372376014, 0.35137921530077, 0.5560668922569723, 0.8257042577117882, 0.8538711814204312, 0.9529511832211874, 0.6430440760828282, 0.9311542266424487, 0.5361556334886692, 0.24655630135038142, 0.9480359722015442, 0.07101260253442565, 0.9475128713912682, 0.14836727284394324, 0.066676605309969, 0.0851383666213179, 0.9352874061758412, 0.7394448029731573, 0.5737032271065349, 0.16074911486028431, 0.9540770652879381, 0.5617112712448644, 0.9806535624785759, 0.7829134501564183, 0.315510535421642, 0.9627156314322917, 0.7213960047013843, 0.859948350040468, 0.5593790130359895, 0.8490827538513847, 0.2824665795608957, 0.7591031048977048, 0.7393655441214059, 0.8423305384859517, 0.6430383098970296, 0.5123267160926158, 0.9800915404414485, 0.4957764746491228, 0.5184498671846004, 0.507578149666822, 0.006927551275768051, 0.9275447488900187, 0.5115720043942099, 0.5680544605660783, 0.4759911160751358, 0.952223838883073, 0.16789219470428796, 0.43987438039677984, 0.838981285431596, 0.5525138350555806, 0.10304861884788175, 0.3581705781968747, 0.1659761322849841, 0.3222415351413046, 0.8256474431305166, 0.5422062746485691, 0.8190462376277492, 0.3334107176767861, 0.6135475910884959, 0.18204725053096815, 0.12051303967979066, 0.73249360738019, 0.8183998070500903, 0.7224835332197003, 0.1919083326592228, 0.25495924611407594, 0.2710776863993316, 0.02430968736162553, 0.9531672745541429, 0.762072982954575, 0.039740261838404844, 0.2887359803757912, 0.8663138753497479, 0.8502904882175606, 0.652617361196575, 0.46761780979604384, 0.3838747005543375, 0.561109117191521, 0.03921003702144421, 0.25035354005451216, 0.21948269453878677, 0.22802801201220801, 0.8664506398468235, 0.6177161588870702, 0.4966101836800678, 0.5373075843065171, 0.6504679132539154, 0.38354744287236286, 0.5510960850108028, 0.9505084602929632, 0.009954675750634578, 0.10715782144468788, 0.6641092528896959, 0.7393280740351171, 0.6937369720124, 0.25243877778656243, 0.28441632851171195, 0.017043588792754805, 0.5629950225344179, 0.4941092412508318, 0.3622992493370484, 0.31590712296779766, 0.5376878017345258, 0.6271808189140095, 0.26219363994955736, 0.45613016582905774, 0.6270854048774791, 0.6226416104346592, 0.34709640079529036, 0.6796316003767386, 0.5559135585350399, 0.9905212786124955, 0.7350171187586341, 0.28051371782745316, 0.1704676050345808, 0.760915478263841, 0.9162245015894996, 0.2542693743798701, 0.763153847976882, 0.07421061185232403, 0.8897656185793338, 0.8090125409795951, 0.6892681428221199, 0.5836645626816421, 0.22871219338703908, 0.9345633942977225, 0.16642329541471823, 0.6166630668759033, 0.015815122683516925, 0.6090084477217649, 0.9448878494160262, 0.3153852155808411, 0.9047244154086411, 0.63739529467346, 0.6162011678920036, 0.7832760632810809, 0.6566586500563895, 0.5635099753874278, 0.6877805731452262, 0.6006376389029663, 0.3783847884413034, 0.5732250771865991, 0.19283825038516333, 0.9408148085926252, 0.34459503369553335, 0.8166947417868078, 0.5277772889921303, 0.9178652354986748, 0.7262449258990042, 0.11671259595118266, 0.41333727232073414, 0.7272679803267814, 0.7661426779944537, 0.601837025244186, 0.3611119915450187, 0.6031382290906528, 0.9440567583095018, 0.40542782711200387, 0.7936631393131186, 0.6085807662151188, 0.45583488264045224, 0.20552693347097217, 0.014305292936496738, 0.800227795713833, 0.8945047361911553, 0.04555538745933074, 0.551739243697055, 0.3636717824965915, 0.36605260892619096, 0.5720871568488648, 0.015062336480892946, 0.9034171911515959, 0.3985533494975222, 0.5535002457228222, 0.4862858629332937, 0.18913982766790194, 0.9105510598379183, 0.30209387166683177, 0.6503410891058018, 0.3094557516643013, 0.19306686584656962, 0.4123002477272789, 0.31665740374932194, 0.36506674573193154, 0.32933653841558863, 0.04890781123796373, 0.7217472433110345, 0.5450622599793964, 0.727357239802317, 0.8717524065215011, 0.018834136015179137, 0.6733229747325157, 0.4725494565589484, 0.5671218990765792, 0.6584120525205002, 0.08638405302834817, 0.021316417422915013, 0.8711583923983798, 0.9427251220621393, 0.009781480920621255, 0.35101007053352784, 0.916831648326151, 0.8975093678131846, 0.43681758108868407, 0.057789442828390714, 0.7135963005773666, 0.7459384399297209, 0.8818469300116879, 0.05108301651628733, 0.5776344310457874, 0.6925680881400382, 0.2795974579180599, 0.43184453884800345, 0.37062421342383234, 0.4291748176529321, 0.7327057586262867, 0.8615169169610546, 0.4762642015254479, 0.7597361504519112, 0.7715594954718028, 0.22959639713708535, 0.5463223891073025, 0.008401216659467803, 0.2837040197255992, 0.7099153918938198, 0.18176753136846968, 0.42215254751682896, 0.2944844871193667, 0.35923885727389215, 0.8795799586515258, 0.6089603100254117, 0.3362585235728398, 0.25649567886280267, 0.7721275777644848, 0.16258350730232396, 0.23042871723888614, 0.8069434560954991, 0.9135324789906287, 0.0167723415050971, 0.7247083044943167, 0.24279097958651907, 0.1262418650430479, 0.7444790609308004, 0.5774475811256551, 0.540279855419912, 0.711056752975533, 0.9717854079412255, 0.3615120765322857, 0.942953042498566, 0.6451605381839567, 0.3116061703365488, 0.47211856876519964, 0.031814487852397155, 0.24522885416295337, 0.7388307031249625, 0.5661980600627805, 0.8153110321771289, 0.6564908864181979, 0.12641494810618936, 0.9352696313283213, 0.6255437640993292, 0.9436518641887071, 0.7410386539534018, 0.11947271418850336, 0.7018430383957338, 0.005874832848406286, 0.8572938947620045, 0.40731963842419683, 0.21881783131027088, 0.0155595958337722, 0.2909723304919207, 0.7338942726922193, 0.17321631303615626, 0.589445255277991, 0.5748705891123912, 0.8896366245939447, 0.9824115462465475, 0.44060214648315643, 0.7046344854719155, 0.8825174320962269, 0.8670527142598754, 0.8311676926167891, 0.8675141220073419, 0.7583205703336474, 0.09139840692787415, 0.7482202330888492, 0.3335043589622795, 0.17691564840689, 0.917075587740018, 0.35897348831691345, 0.7361952695389284, 0.5668166172949176, 0.6894841885116844, 0.9665137733573047, 0.29976044728291895, 0.735986921703226, 0.8207939161496706, 0.383590679337495, 0.1788609716961821, 0.40376514257702834, 0.5594561537165852, 0.36951161211866734, 0.9698456475701519, 0.23694972631421374, 0.34338077882178664, 0.5339789279611485, 0.6244791199649246, 0.6224949568371468, 0.22240424826846317, 0.9017482375777964, 0.4515308504024155, 0.5899349135897497, 0.3054014237853462, 0.15327469320215015, 0.626910152826715, 0.008565626449598684, 0.43837065086956706, 0.4090539468200467, 0.6496333993467066, 0.42758025246049747, 0.35204809095054257, 0.30915285717276997, 0.47876139559224584, 0.7017656985307607, 0.3310836038813504, 0.05446458094334372, 0.6655465121859238, 0.851033591253752, 0.05153723882494121, 0.022511278819231872, 0.6553805913692865, 0.4389723149704492, 0.6094321102882387, 0.5481572370354459, 0.575736090138116, 0.12377085147514566, 0.9203255759259068, 0.46838402100716425, 0.2491449842836012, 0.9342793444636924, 0.6083375348918133, 0.07031795070806302, 0.8743608682667748, 0.2546354405203478, 0.22280128687872192, 0.15299019275459214, 0.8042018280582361, 0.4627994069250404, 0.12167844943341566, 0.01584788306659246, 0.11517265376814023, 0.6615048842446517, 0.6431066830023405, 0.320824130240592, 0.21181712065385638, 0.964546792619433, 0.24992496076034176, 0.9398141771904965, 0.5378522700585305, 0.3569912738051789, 0.17674816818329875, 0.09569322508831024, 0.5764880878982382, 0.23480703037139272, 0.7351387201725994, 0.33255148901186105, 0.7139379906005711, 0.3475816182762417, 0.8396503831390775, 0.1096099803672348, 0.21297646267675907, 0.017399563294174025, 0.5059949946264269, 0.10332090155954043, 0.49750250507442295, 0.18762440687994753, 0.04231026240924729, 0.6234441781303257, 0.1844182390741833, 0.06723966638024992, 0.40548282656819423, 0.9014320113895932, 0.8157345387312159, 0.8795685840912971, 0.7267073977891113, 0.3932415228640582, 0.0416662700367495, 0.4986061612523147, 0.3239397450312722, 0.6537347844107037, 0.084581696526009, 0.5618612638116002, 0.6136271503493332, 0.7861151885593674, 0.6740222745639511, 0.9855206228319271, 0.2100773006386487, 0.9473871710909708, 0.28461036229483727, 0.6759103188142359, 0.1580525098754969, 0.8996162538019371, 0.43151395989734176, 0.6306449237976175, 0.682653298548011, 0.1368049515948886, 0.9822393363318807, 0.5535181493048409, 0.06028110661817854, 0.6884893408311139, 0.9288739662767875, 0.569102923348292, 0.21544757567678008, 0.3036999423979303, 0.8315031980935035, 0.616193072273755, 0.43042345614386557, 0.3527199719571099, 0.1913767644145934, 0.6236328406699521, 0.11819703978162233, 0.4491127443549193, 0.34150159309746153, 0.6277441809973924, 0.9539390135406591, 0.49077938559107104, 0.052689609760897205, 0.5774763654907219, 0.7861464367503146, 0.546346543749208, 0.9446909597352505, 0.6915661834215929, 0.6558658271964469, 0.7719736605538001, 0.9648938997775942, 0.8814108598576894, 0.9408712118809993, 0.3337077514180754, 0.6511747982083416, 0.9340205977748439, 0.11140046526103475, 0.1318028387636473, 0.6308332692621863, 0.8613308748839038, 0.835028521724774, 0.9759604459667824, 0.824148468315057, 0.06531922554855996, 0.20048423597791998, 0.7442366789025213, 0.11894462837778641, 0.7427852695438126, 0.6436926356067809, 0.9733999814836013, 0.8616554006097948, 0.2593163621486979, 0.754052024819908, 0.27481321544826964, 0.3707281282533835, 0.05887607330909328, 0.5149312974918019, 0.9474528226258044, 0.8198102978794218, 0.04361589632389273, 0.6895998962741243, 0.16846615217535665, 0.26101289210995093, 0.257925461659549, 0.0022787732194642363, 0.18170834746854259, 0.26264598049054566, 0.1413997959272948, 0.483727939672817, 0.9759876891951798, 0.6211740720934086, 0.5773170831185725, 0.8517622953360929, 0.04728906258840482, 0.8737400411483515, 0.45638370643419923, 0.07931429084866437, 0.9730326859780819, 0.88545804741828, 0.4999178460775251, 0.36613801052792605, 0.6914654699624919, 0.6147774932341386, 0.6423066440603886, 0.5749769058685293, 0.5755707817801433, 0.2705716294768594, 0.3594866499276952, 0.8189924489787326, 0.6184217544833139, 0.46620570492211044, 0.9483602491329562, 0.294479085679602, 0.3056922641581019, 0.6486917989450861, 0.9114760719066366, 0.6413661943512564, 0.04107864342905099, 0.035137929902424814, 0.281964425096341, 0.08373515655851826, 0.311674463457678, 0.5240520119032963, 0.9356334420234853, 0.3535556917591388, 0.13287967374471477, 0.5656614661407364, 0.6802954919070134, 0.9330724616595877, 0.6962144118045867, 0.7732615031454998, 0.18680747393224773, 0.4647494328444862, 0.558447017308073, 0.13670705897504187, 0.6319728074816128, 0.27240591209052567, 0.15673444762596755, 0.05951363114593444, 0.2603666680508232, 0.8131549992201226, 0.9120132117945841, 0.08263546822135293, 0.9403105298443608, 0.5369814986809845, 0.69166667559487, 0.08083973010944745, 0.1886358112569444, 0.06927306183065884, 0.9425350888762335, 0.9216975697198472, 0.06954048108913091, 0.8513448266077615, 0.37662276185984433, 0.0625645806296824, 0.834756841612864, 0.3749744822152933, 0.6943960014993629, 0.32752420156566286, 0.16541242072354878, 0.9291909771844319, 0.46435520542027675, 0.1541198228205889, 0.4003801565808105, 0.341037023008408, 0.9426025749211545, 0.9288022670170227, 0.19157811419359871, 0.5367519750461229, 0.31241645375081206, 0.6403715501051053, 0.613592908852525, 0.8757977615068099, 0.5513827016480531, 0.9722928051359504, 0.8731652880892743, 0.11737821719123909, 0.8924218023698227, 0.1276181616573704, 0.4134901670892247, 0.567577333660074, 0.6350901928425046, 0.13434780192458573, 0.38894768646639155, 0.42496982173589026, 0.8848227966325568, 0.11441506185960304, 0.19779559745401287, 0.5935326760075396, 0.6503232012220608, 0.016081773387329856, 0.0035177891716835497, 0.2639144242061868, 0.6130969636852157, 0.6073821730112972, 0.9499375208813422, 0.3775938788283584, 0.79816202918291, 0.10735431958711772, 0.08086795212087816, 0.6831876399944743, 0.3212604214972399, 0.6921506633873546, 0.811986949811485, 0.4701421533042721, 0.3654329379829815, 0.2547199716986942, 0.17078673158255087, 0.22227214710996457, 0.548609364271407, 0.21960499844383763, 0.9198635710933247, 0.37208442910396866, 0.8839040262020977, 0.9185016130835782, 0.10947620457152285, 0.05655215174222039, 0.6055969785996014, 0.01757670981737902, 0.5672161521235565, 0.27598142872650444, 0.23631950274168267, 0.7541437144332025, 0.32579692074472266, 0.13983892999763048, 0.40475160339934424, 0.28814614637912717, 0.014383389079671072, 0.9468849957829616, 0.08817862374717433, 0.3030014479380776, 0.7945463500573477, 0.6916842306790724, 0.15054291896694227, 0.10070819220732985, 0.5088416668642314, 0.21554136709163474, 0.27416549205577856, 0.8277222856079174, 0.3281773796158569, 0.6271373144252865, 0.6421019707317634, 0.14095858081788426, 0.33354589117884703, 0.806616262623465, 0.01813586189284533, 0.577376064744187, 0.14836307416291794, 0.7766021533098394, 0.19270147777137014, 0.12595679796753678, 0.9495695270692284, 0.4745982224026938, 0.11556763170723994, 0.017489671204594215, 0.928813694837298, 0.9934510654050982, 0.4199027308609202, 0.5454218968952552, 0.5494503545370155, 0.6700364592802267, 0.45738054947080287, 0.8101430461673038, 0.7507524961176223, 0.4970508241233561, 0.4102750756311472, 0.6394174045809733, 0.5876479041964079, 0.2087694257166811, 0.5240321784107198, 0.5792823019559459, 0.6624566308691197, 0.04885770310504589, 0.012594561279813177, 0.7725818291517438, 0.1045190761207101, 0.6668003113385426, 0.7287957443574419, 0.7464063620605548, 0.7842688414866703, 0.8092374890156, 0.26342777276269014, 0.6150606117383747, 0.9102179719120453, 0.47347584076775984, 0.7391264730927244, 0.9717834995113774, 0.15048709406772098, 0.9726670794830874, 0.19900715123747637, 0.7902960850666465, 0.9449263611829654, 0.9256244171248486, 0.15502252316816179, 0.9863537193541082, 0.7295374685299343, 0.5289734228667035, 0.5573041112593504, 0.8998316471646371, 0.38182095404423866, 0.5953101371680238, 0.17328680220382164, 0.8494737095607794, 0.31383723063913893, 0.7482664841434687, 0.12420613284169835, 0.08528624308367305, 0.2891836996218723, 0.8538587011166938, 0.11659594350070845, 0.9176600304533805, 0.2207541215687645, 0.2372221798677271, 0.7277041592324578, 0.5376555343777868, 0.9180614535609993, 0.4848114972526726, 0.9562825894156303, 0.05948731912850125, 0.996067859633754, 0.6643718100286076, 0.13399636676090676, 0.6140960504048779, 0.9318812270891088, 0.6084642494258936, 0.20773734028858448, 0.9017973503234242, 0.5613405678229714, 0.5020538776059744, 0.34941485367217673, 0.4723484106218103, 0.14442709982592994, 0.3906463808981133, 0.8273366271299444, 0.14237549924396264, 0.4966020100143892, 0.3826850099145469, 0.08208120254561002, 0.3829559789918723, 0.5825854484967004, 0.2583972665845463, 0.9898026805930488, 0.21425081287292125, 0.3997561483313964, 0.917005775679165, 0.36719744086249884, 0.12943519613902266, 0.9402642831634893, 0.5951958326007288, 0.8749018022854115, 0.8367755274743162, 0.5141149417774145, 0.07195786606172061, 0.6098782872641005, 0.15655382370747895, 0.7398932015702719, 0.13839948891003673, 0.8423874462202807, 0.23864108072784085, 0.06546602526703427, 0.4558490817832451, 0.5494313943299814, 0.37687339871513637, 0.7679102822076499, 0.5515488763308938, 0.6240939215809916, 0.08798606132794196, 8.022644376082244E-5, 0.10846188675651591, 0.8989913934611976, 0.7957119162925357, 0.6006418231958858, 0.8941945850624529, 0.4120875151724881, 0.41475282410702563, 0.06506529863226107, 0.6437622162418303, 0.6644143707419777, 0.36468338877315676, 0.28698159776943255, 0.9619020652174654, 0.9717807776772289, 0.06044892132231683, 0.42247213278900486, 0.8428646203162771, 0.396338661320803, 0.7239701877680463, 0.504275600516854, 0.7190910131809888, 0.15891649641837435, 0.4404695193723458, 0.23855958093003404, 0.0449099761837376, 0.879318583733969, 0.7434846011237214, 0.7538185453773825, 0.29736550643771464, 0.46932759793636714, 0.6541370782424546, 0.9396242954607822, 0.9335120363804607, 0.011936994261944944, 0.023075757265513586, 0.4123685440334267, 0.28199105892785614, 0.5003790932998712, 0.22761460450632898, 0.07580173923842104, 0.5664291730633133, 0.881803275291032, 0.7619382668689118, 0.7060860394357616, 0.259174951530765, 0.45299852552402076, 0.02484871793004706, 0.9842445994283032, 0.7461173097640706, 0.2893427048258629, 0.6573786971081649, 0.9233032815396809, 0.84680604698912, 0.05320092025823131, 0.11169870094461731, 0.6930849462494906, 0.07882055725903914, 0.2242836199595699, 0.7430962805787648, 0.432530695660327, 0.6813102278060189, 0.5220146618636253, 0.6084077933852386, 0.7575863026157142, 0.31985574610305134, 0.04874852261283724, 0.32713401139597587, 0.3221062442609637, 0.08327795700045981, 0.4727145121091594, 0.8155731923358999, 0.9698919136126913, 0.8527468583870665, 0.39085562230505144, 0.4396563294003547, 0.7278941847364705, 0.37451992889018904, 0.8642680073419915, 0.14877063949794012, 0.13377544887336745, 0.3998660504573154, 0.0027366438938024595, 0.4507098504462309, 0.16543924204943738, 0.06920719802869502, 0.3899014737129173, 0.6669901229764134, 0.34580043424259366, 0.3122370977918685, 0.08687758131046219, 0.7681231872418987, 0.43298278504565435, 0.4117522228518997, 0.9296919186641546, 0.23003894098132593, 0.4742945340340967, 0.03615773770572994, 0.8446882922833181, 0.7757021175518162, 0.9017469880534709, 0.9840865639608174, 0.9460910457108868, 0.5700681700498547, 0.7775451367334426, 0.6042972104669138, 0.2512075033172816, 0.4218764795056883, 0.2598932164165312, 0.354992113179987, 0.9512876730755858, 0.8123789715511268, 0.8526223281969518, 0.24892493060222032, 0.3098492614826778, 0.11895507317647047, 0.026561191259067973, 0.9941416007685276, 0.42531479575594455, 0.2306649653441849, 0.35623550403458815, 0.4849269540536204, 0.2910970223025281, 0.8631444489832714, 0.40239473254900415, 0.923504832240531, 0.813807400222086, 0.2718468882838818, 0.18903007030522878, 0.2602662549203494, 0.709051954183215, 0.7354884655782187, 0.2729607475167538, 0.8287770950756342, 0.4843176215011662, 0.13565569939010114, 0.08473014893621234, 0.021542948456397926, 0.03974132830297328, 0.1938841624971389, 0.43146743485832684, 0.6034854640701697, 0.770093091074719, 0.4441205803430496, 0.7955338934577633, 0.7923111073578529, 0.4350934775455524, 0.8163307482767314, 0.33718811101030677, 0.5484298851939905, 0.4802249833904715, 0.7861179409659498, 0.3151673240136098, 0.6118079578324849, 0.9364855584719409, 0.4055677932104669, 0.9759968449921437, 0.6991148188574332, 0.5050720340970727, 0.17213757288407783, 0.8310033542936189, 0.9317520950354568, 0.941770130530921, 0.6152585557279646, 0.6394221069376561, 0.0038278828692593914, 0.39586641940527545, 0.6844226347161785, 0.3466517032829274, 0.8188666161222592, 0.9296872707890823, 0.5078753287822015, 0.6886248030756977, 0.3250216857719719, 0.04740838808220316, 0.8576391127983024, 0.16642649113326413, 0.0607838030521658, 0.6955679776107436, 0.7044424148543385, 0.6197068203254972, 0.4866553131870891, 0.8627552002061141, 0.5752314929501643, 0.6830973685131343, 0.5229871863380884, 0.6022353356992511, 0.036293444597168656, 0.9967564309148844, 0.8401512182725165, 0.028811107726102292, 0.5166207268683186, 0.16033076267572355, 0.3544476889313516, 0.6000098590317727, 0.8589989084972904, 0.06903677704445998, 0.07162434400305073, 0.7817244152418882, 0.4404005506534199, 0.4512271119529343, 0.8896096590855243, 0.019724880602033035, 0.43862057932410725, 0.13872355503792233, 0.22303947424531223, 0.7909979462662029, 0.838688857454053, 0.8443606495626704, 0.34438337962911847, 0.3926585768664592, 0.07044868729517728, 0.9955984691788967, 0.1499527994225358, 0.04121912474827483, 0.7477898911617568, 0.47872789901042667, 0.6538001530639378, 0.801288696973859, 0.8403783394614995, 0.9851042841018381, 0.8884945207549612, 0.8403159151645349, 0.7503238364798569, 0.01901110669617101, 0.04898612523578916, 0.5147762642991356, 0.18908121660561406, 0.5261680682890945, 0.6542481882986098, 0.8332449278125964, 0.4539798479722126, 0.5325627367546744, 0.22111146108440394, 0.9130846854396106, 0.6891291509148103, 0.14519876301550505, 0.4456834254048361, 0.15001786555940344, 0.9820490114581071, 0.7595176337198851, 0.1699704913268969, 0.9536400648078812, 0.6952253718531621, 0.34266525951068916, 0.47479801049492076, 0.06697262613017985, 0.26089316860067835, 0.21743859806189358, 0.08484988316586528, 0.6844396889710048, 0.7777000905499102, 0.8586613347472363, 0.8976257527052585, 0.8101952883431398, 0.1395062247149882, 0.8319022558585653, 0.8553403272165861, 0.5575140839891678, 0.09942645599706845, 0.15386359137205086, 0.5672662887595984, 0.379999229321367, 0.6263237439832571, 0.0344307217812283, 0.05974841376480222, 0.5466496173542096, 0.14631306908603658, 0.17228883414544838, 0.7820931854698273, 0.5253675489327575, 0.7784375489609114, 0.5191760484152045, 0.5287650175640037, 0.32327753206889887, 0.47152954226151245, 0.7022568421407415, 0.25179637836420565, 0.24726523475394946, 0.028371270122000358, 0.09976311755675782, 0.8320459776646028, 0.9944356319586934, 0.36362111945913234, 0.9019651404322669, 0.7539154724055762, 0.45972714695158623, 0.983573137644536, 0.357697675934612, 0.2853619353762924, 0.15670915395739038, 0.5986688366545523, 0.8060817230740103, 0.20351989804555437, 0.6876280701123213, 0.9837823858674078, 0.02374538706444429, 0.32597304980076125, 0.27005675588575706, 0.6866511259316894, 0.8797620852276212, 0.10869248583012203, 0.9300413360980065, 0.9514254508607157, 0.2836883707165093, 0.35388517836457445, 0.6054279841011949, 0.2721635743658347, 0.9364969260239074, 0.6344721771311523, 0.06809182537321601, 0.3201980558696911, 0.44986561579486284, 0.38664357706551755, 0.27007867852874823, 0.5996526437718094, 0.9861965000369908, 0.7479128141988972, 0.4462100520472225, 0.07698974505366063, 0.68990301540202, 0.1253205215976998, 0.06449015046028905, 0.20331993595300513, 0.8299182099232117, 0.16691364515357865, 0.505693266737451, 0.20230695282964162, 0.7540398494717734, 0.2793529711239392, 0.17479876199554223, 0.23185301066715658, 0.46764344045570716, 0.08547822634079494, 0.599479947220397, 0.044350670053122765, 0.8924575457003918, 0.24788663860782212, 0.9546420628867494, 0.0681392589883012, 0.6355099359341049, 0.8980576631426868, 0.3670440356601299, 0.41190542764497096, 0.4040173578944116, 0.5052825373198956, 0.3003274058554779, 0.15411878712670757, 0.038905952168258984, 0.39563467050389867, 0.2983148229937911, 0.42119529381856924, 0.5078126360030466, 0.2884425834972232, 0.373229933750853, 0.18093270162752217, 0.09783270108230446, 0.15620458052879638, 0.3655292043426557, 0.38186356826322154, 0.47894263242723456, 0.43361003419811917, 0.6733254945392698, 0.05452330980345821, 0.27094079014673533, 0.10230947293516945, 0.8519221687752656, 0.2572322345163801, 0.23991351142276585, 0.46030151169464373, 0.7177653551431216, 0.29684184401131275, 0.27464742055394353, 0.44828198040397427, 0.7561619269162361, 0.4839974142964756, 0.8490732454191903, 0.2500264754010638, 0.8283983371738272, 0.7928206334095724, 0.7637404561268544, 0.5098546391365439, 0.4014360389161439, 0.18651711599690501, 0.5774861768306565, 0.9174506319105389, 0.7821472828295954, 0.04326566708301638, 0.289875374367458, 0.09879126960359252, 0.12809449179068333, 0.07084757326701985, 0.5156541750495415, 0.7216593304027514, 0.3281455559595976, 0.33382561535481137, 0.6043716661202874, 0.47519660797472996, 0.1987562600078523, 0.533684264714995, 0.9014897723182512, 0.11517744144532394, 0.8255401661900186, 0.48019397587832413, 0.6217147623128664, 0.08016036773900892, 0.2947855143981891, 0.7713640820217746, 0.6109483646322429, 0.2784017590011587, 0.5058675116863018, 0.05970029957043632, 0.6101698083790228, 0.5213921084674137, 0.23304364818837697, 0.924084670445749, 0.5027251668434547, 0.7371022224988684, 0.11390838060112463, 0.2894467829989793, 0.4259134020799896, 0.5345028751609758, 0.7818234416954272, 0.5404974015567786, 0.5584234046201646, 0.9106482893510761, 0.9309278417039655, 0.9611465771668425, 0.8570898313960261, 0.8925903353127125, 0.7048717058451108, 0.8978300990367677, 0.009599946522526492, 0.6886167026236889, 0.4342069548144466, 0.09282001734898826, 0.3941976376308416, 0.4867832057637196, 0.4124063311710815, 0.9626957762197265, 0.8930946278818044, 0.38343664896479623, 0.09677213270099005, 0.20750498236389459, 0.9932132862707116, 0.0504013612054901, 0.8480344773391267, 0.027743647769556623, 0.7260494920942973, 0.6567290655863588, 0.08122839216297106, 0.3991376549908844, 0.6478575993772155, 0.24938819871974982, 0.49047771809428486, 0.30930875612488484, 0.24202431277668357, 0.2669957859335348, 0.8316031231700352, 0.5957599291677657, 0.8374117395060656, 0.11167077848995233, 0.599010645707264, 0.04121630374582508, 0.37961439142577746, 0.7363151710761003, 0.8171059655762487, 0.6802098474389505, 0.16648862989895652, 0.018104933473916396, 0.08151899568706156, 0.8498970690449, 0.9649772398985884, 0.2837003113375818, 0.9317119363728106, 0.37845100881467164, 0.7631662209612929, 0.7276606223025857, 0.6140838628914457, 0.4459700193887399, 0.7796740753004494, 0.6227760205134639, 0.30347304681970666, 0.0756975316771411, 0.2518889571593037, 0.15950469584265192, 0.8909977941307134, 0.9174486257126622, 0.9552324758267843, 0.47143104247021783, 0.5174656194752614, 0.9704906385541422, 0.3675431912477255, 0.9046365081502171, 0.13411944015509913, 0.15972679096907438, 0.8858366988409855, 0.8711014764096748, 0.5062787903331262, 0.22688311211976797, 0.5271137120748508, 0.6897333112852342, 0.24047276818808172, 0.22750087460006008, 0.10055136153346211, 0.6633419076457168, 0.6119509516002433, 0.03488795001312184, 0.925326544280255, 0.26586108078073967, 0.19699715281751806, 0.6437841201358626, 0.7864853207204549, 0.7213402427272274, 0.5732601195142245, 0.7393474305817896, 0.9706851488790943, 0.44470762928023344, 0.6413545773748477, 0.9511693646125988, 0.9043017277991596, 0.7840329071176294, 0.44227452824826774, 0.447378864986834, 0.12830590575460932, 0.25499361788431263, 0.6977003455706827, 0.04049677649517203, 0.08748028330447322, 0.9904760540876636, 0.6840698440839834, 0.7745531509185731, 0.4859589863231809, 0.44171834507165897, 0.46632312573509715, 0.04208250824929716, 0.76673852390067, 0.46212962929624957, 0.963519010327609, 0.6399625896244093, 0.6097212946056996, 0.7808960046918734, 0.7960613011256333, 0.8146646451701579, 0.211017801174874, 0.530710185585244, 0.3730611246005662, 0.2703341187508733, 0.5056472347923059, 0.932439032124934, 0.21840100906708537, 0.3172227165912195, 0.4264405242953142, 0.459268748570554, 0.10535566445364253, 0.8233441023261823, 0.7538639313801994, 0.8038447888983182, 0.17216289454014122, 0.3988269797173638, 0.10464492939825665, 0.7541501416454794, 0.824728068054981, 0.29029118056276826, 0.1314970548523442, 0.6473414225456023, 0.8976832962590712, 0.7916737049529656, 0.06190335917073364, 0.4154898400107465, 0.24131320196799544, 0.5882831196403958, 0.2908332903809038, 0.3631497405934446, 0.6293964214689655, 0.3424627847277879, 0.860430695472573, 0.7239046654895568, 0.6418027451211381, 0.0020942014022306, 0.30912604210748584, 0.7315168982078647, 0.965723518075352, 0.7672739617465387, 0.5532887720026572, 0.4110335780066291, 0.38070284962228407, 0.38584918998202555, 0.17645040303345028, 0.5461783733082738, 0.5451756673919236, 0.4650975888830349, 0.7442934173034945, 0.31158491274246336, 0.5860083384876551, 0.7846902737337531, 0.5380136626973956, 0.8719043341539746, 0.407575870843078, 0.17517671583371686, 0.4043300817689013, 0.8445460133679958, 0.5831995848712128, 0.38658307163591676, 0.2573275838387532, 0.8987868955633279, 0.6693073444796435, 0.5133162731904259, 0.13548442327739796, 0.9212119456470049, 0.7914685042277969, 0.9644182143005773, 0.6166488915879581, 0.11592410799997988, 0.3914937020950734, 0.6723158733757076, 0.8243940807875986, 0.12768915985504925, 0.0960797071383882, 0.21856438759365238, 0.22109402011760926, 0.7771574066543508),
    new Array(0.7700176651290012, 0.8216823492778406, 0.876227958364131, 0.2795304808284912, 0.9507731473732286, 0.6800294160517495, 0.9228342697224482, 0.8815183573041956, 0.026284300520404646, 0.9917783935666615, 0.4706989882000491, 0.696157882688258, 0.7141146481973005, 0.08438546036660532, 0.33177808236423967, 0.14104123981792127, 0.6276352086304339, 0.4775633822744837, 0.5315172091943338, 0.7927288235548623, 0.9737002466131292, 0.37661467515439484, 0.72914605965816, 0.6585975668547959, 0.7163197890570204, 0.04708284248072503, 0.35068866026386647, 0.8371029623777848, 0.8621210142168916, 0.7570314832373674, 0.45034554309548813, 0.28840871354728115, 0.8759299990107439, 0.4898626551351266, 0.05906687279440914, 0.9695650555474833, 0.618594137900601, 0.4284376412917209, 0.053550641249525244, 0.9018932847108482, 0.614204486204912, 0.29036422189017863, 0.38456316921512934, 0.8329604605323567, 0.9001669116257743, 0.9546668118827166, 0.8403941288787643, 0.03150492597992971, 0.19110895051358545, 0.46165709675956423, 0.38942163567979204, 0.4108996030024763, 0.596399772678635, 0.3906741536392707, 0.5451773485433982, 0.6152172277671103, 0.6710982810743785, 0.8244649910982772, 0.1279655793361849, 0.9216873205923498, 0.15143443013523294, 0.5943277563477353, 0.25900445769279934, 0.8143119723365925, 0.32846739014499016, 0.26674155586367354, 0.41622115190238407, 0.8656338644476239, 0.6473535989261445, 0.38005805111529445, 0.9052472934010904, 0.12712653097343096, 0.784696417050168, 0.7689323786443355, 0.15482491277852328, 0.5734031811353493, 0.1527384989878411, 0.42452126987404804, 0.832747011443926, 0.27141738424589157, 0.5066969776588988, 0.2300791002271091, 0.8966211698748665, 0.8530552635132936, 0.09033032741658786, 0.08443327064072281, 0.3431587048383775, 0.557995251967463, 0.5448654680046568, 0.37992206583745025, 0.6003555063063986, 0.5834384837105693, 0.6277019450683445, 0.5367301827826942, 0.21884550871633035, 0.72828873880065, 0.6398497771135366, 0.312157855407697, 0.7618709346317601, 0.3515883615389348, 0.3448461717850472, 0.9012118832314554, 0.5677282103887711, 0.4784921981759148, 0.07693558901645481, 0.42400783233692185, 0.36421242368507045, 0.48178883794923044, 0.6825867007227439, 0.25582457162969974, 0.5514965361952451, 0.14295456400570317, 0.9169586364608291, 0.7972538390301415, 0.33804676866968575, 0.05395243979707931, 0.925718227127637, 0.704738835332765, 0.8135887225917314, 0.25946491992214626, 0.48264898944037127, 0.3058977076717625, 0.4738032738909541, 0.7589755917968313, 0.7247814965617048, 0.9093793455907361, 0.6733452673997318, 0.9890915331666341, 0.22931380811362756, 0.9856002004309795, 0.976942107038307, 0.6887251713552371, 0.4103802032000784, 0.7425625087767267, 0.40274326750414546, 0.6132300707057864, 0.37876468048280576, 0.45005630832432275, 0.10775623397800216, 0.4083127186260218, 0.6039454804547505, 0.9758981767347367, 0.15211763380349852, 0.5805178513618874, 0.945395803040169, 0.38946261979062247, 0.5971134427895712, 0.9083125539390392, 0.8788543557532488, 0.16061188167363472, 0.34127526932513186, 0.8262698291805686, 0.03331943022733996, 0.43623335292745735, 0.7795443138532215, 0.2845798647678863, 0.4758085003227154, 0.11194360282311622, 0.5824086279687898, 0.3370929308558074, 0.5334645007375082, 0.9331210530170001, 0.6350829054915671, 0.2433252155553377, 0.32637954895047927, 0.6572796271357341, 0.4512148962534023, 0.18333477771115303, 0.599545052770398, 0.38889848223509993, 0.18126588531306764, 0.7791016990226688, 0.8886271194058857, 0.5581733845909803, 0.6726268802543791, 0.49202324369389283, 0.5318044927321827, 0.6567576361162915, 0.9066967799030032, 0.6233608172037811, 0.5486958139450505, 0.7664117384291331, 0.5375619518649165, 0.08295285752932913, 0.9474418750047858, 0.12058237641566572, 0.1875813635820064, 0.31123355669935737, 0.5922974443420133, 0.4242831249609047, 0.6170954569435997, 0.7405745526459443, 0.3666267117621731, 0.4242508608094523, 0.8786404639972076, 0.9641927836448617, 0.9999849342313089, 0.26920322606848235, 0.09046460420567626, 0.344344735765721, 0.5930083885016871, 0.5291239834037679, 0.5198063915305319, 0.13625323662309907, 0.5701237155223392, 0.3528552172445114, 0.25330905115576763, 0.33019027462794304, 0.5176263242884186, 0.1348760586474418, 0.8501095608618436, 0.3213653249715346, 0.12346739304552978, 0.23500010292125528, 0.022554779614101572, 0.20574529378435624, 0.22512739196492315, 0.7488241637840521, 0.5701609528779349, 0.969659107572636, 0.7932434420365886, 0.062113906265002905, 0.504347141857903, 0.09201619266950156, 0.531196744774855, 0.9389120520641168, 0.5446373205411799, 0.11019457762105211, 0.6546555859589811, 0.1910076647722121, 0.941439498566675, 0.5141313485788045, 0.33010812506857434, 0.5555054318321827, 0.886174928469882, 0.927874471993699, 0.19770874593081067, 0.2675866635663311, 0.606443724473778, 0.913831255656561, 0.3813001517165858, 0.9571541139278255, 0.6120782604575598, 0.8921761106961759, 0.3972631869044757, 0.9209050141939831, 0.45734866763691184, 0.6063558381978852, 0.4138847736575749, 0.5254780981867854, 0.815249924267452, 0.2853581348342954, 0.3842238040193552, 0.4826718990607426, 0.6217130840990687, 0.1543848756312728, 0.6779939466226432, 0.004333123832991559, 0.5407480314672969, 0.22779870073821562, 0.9717708688020925, 0.39236576066854534, 0.02593894758804738, 0.3816879571108839, 0.3218711749479274, 0.4484125086785432, 0.8093772443877612, 0.5481212594582757, 0.5405387225271112, 0.19811268873973464, 0.7360318273894487, 0.4991401787566765, 0.2236136849445588, 0.8164410775938806, 0.4797196562108662, 0.09576421848970562, 0.036648192519547984, 0.31348506832294665, 0.8262540328755685, 0.06575975560233738, 0.15647187918872818, 0.4941176996914095, 0.8900121358560436, 0.343650532988923, 0.08649955398936593, 0.9403770325384836, 0.8420773295838164, 0.7574238581466892, 0.41661217347694157, 0.28196268917022915, 0.47127578958010186, 0.37861388841703714, 0.4822317759259286, 0.8181128501136008, 0.17384105198694522, 0.16591894242606697, 0.2922493517191679, 0.6332260900763281, 0.7731043274209334, 0.6272373207075981, 0.541754612871476, 0.7089442027694898, 0.9075221719795626, 0.10098187605276421, 0.0030548757910937585, 0.17701339049853926, 0.5935173961831748, 0.914760749629694, 0.09725973558820344, 0.7800933245259916, 0.9690233046853999, 0.1179878683667186, 0.9887473973768931, 0.8117846641028783, 0.15428486988352486, 0.704713502411436, 0.11611702285312464, 0.2924973246864704, 0.628385113752262, 0.24394176791586042, 0.6757714543383112, 0.9043835280633642, 0.5131287777521244, 0.6169283852513171, 0.20806242346225934, 0.2564107783275922, 0.6803292393001666, 0.12442881736867906, 0.10097099352224359, 0.3797521909634266, 0.6542089873675708, 0.5715931488144878, 0.5225835181289085, 0.964022286036048, 0.867538054227403, 0.06418100439133756, 0.021163650388543176, 0.7364887338568418, 0.9482985407110106, 0.1569959127920162, 0.7904092127092968, 0.5592415130222599, 0.363077573205693, 0.683915582880628, 0.38752222620456134, 0.2734028906117185, 0.9240554983243606, 0.0686206861928167, 0.513009461472349, 0.05481286383852724, 0.37836944008957674, 0.16610162741361667, 0.31366946455151024, 0.062226686793314445, 0.5417970328959092, 0.7172491684667051, 0.5540117722218446, 0.45691211656713526, 0.21311883216126581, 0.31231120275585345, 0.9163925604385696, 0.4516361212528174, 0.41118227728105905, 0.35372521399742507, 0.6364401908220401, 0.9073821056506592, 0.31360381205531485, 0.8848111975535061, 0.6578834069122806, 0.13774003361103537, 0.6442100780633975, 0.3080381525146838, 0.49968349458326444, 0.003763978395660672, 0.15573304774074026, 0.9550520687751705, 0.06841122852398462, 0.08619260257444972, 0.2849380181028235, 0.19038113189720285, 0.720098523026574, 0.7072799429586564, 0.01927761766945213, 0.2317099260083253, 0.9783331967609167, 0.84108555121735, 0.5073287623183691, 0.15184086218033965, 0.44915508491132683, 0.49892405519729877, 0.9696836203029536, 0.5909380606151529, 0.6383501014868088, 0.005776526519247094, 0.022630216812315695, 0.5523749644931877, 0.5730285712104434, 0.6938170739543565, 0.6138713423790737, 0.2814840731812114, 0.3569125617389005, 0.9308095877302526, 0.38769559283614485, 0.6337331323753553, 0.04754658625733987, 0.07398182039872503, 0.4464276827789492, 0.5273292183517408, 0.5336845891568909, 0.894084352810006, 0.15564954532995978, 0.04497845075936513, 0.41239582360685034, 0.2496950784416364, 0.8525978173240175, 0.5005056660036739, 0.21797041207382584, 0.3084298343703856, 0.06030697672481489, 0.3182649385078412, 0.7384954764823823, 0.4095725687098476, 0.08448239158130533, 0.8867484990138067, 0.5710109190590377, 0.7417394324112001, 0.6757502808588207, 0.6425279056605859, 0.5124433869998786, 0.3695428319282975, 0.7768467261956737, 0.5166383030333975, 0.8610561291320294, 0.784823092927352, 0.2424717443563299, 0.5327428560045872, 0.21194115698560667, 0.0808668745689799, 0.8189477630337594, 0.7848907587477111, 0.870119578050844, 0.05213315183073697, 0.6014870516844245, 0.24240978689237802, 0.5761046108428628, 0.007359092243556131, 0.6487856166378853, 0.830449442208067, 0.8413212588618102, 0.8505196870008535, 0.4278261269482747, 0.016918698878176208, 0.8245655874154513, 0.031966420554002006, 0.2861855412310641, 0.700038087252719, 0.3457250880705911, 0.30117227788699685, 0.2048079366424208, 0.5354526083036824, 0.3292717418756702, 0.802861415143329, 0.6711167679894373, 0.9678286720663114, 0.6975772897522674, 0.949903704903371, 0.6305048680213587, 0.13908464281276312, 0.4928901483201499, 0.6792059051868676, 0.12365441770404362, 0.5338813082227618, 0.796851959533024, 0.15093245078708695, 0.3978036723849323, 0.692724969034516, 0.8377211829355976, 0.6867411977376382, 0.9919906678767769, 0.5740124954269915, 0.5280098356827246, 0.7593198118318644, 0.5394685953924921, 0.17857431867845808, 0.5590289627055354, 0.14336130580293938, 0.804901550735784, 0.8637477873555753, 0.09387694903287491, 0.9172180862866334, 0.7796132441170682, 0.36873989953423625, 0.046694588552084304, 0.8648251999174248, 0.4950755239622555, 0.9490151412390927, 0.9135489330900968, 0.9690861023172695, 0.5829875058575134, 0.17467033095973195, 0.1290981922124007, 0.11076448903457137, 0.5097101831632823, 0.886235406368183, 0.9632275990043938, 0.7910282920503383, 0.8434855394286404, 0.5210655170098282, 0.04313656473504113, 0.6811430147895473, 0.8747831312228607, 0.524465784581831, 0.6888957430268415, 0.06941340273372731, 0.40328125080485877, 0.8419179701298427, 0.38428182200347594, 0.8233238485339732, 0.5294036492371978, 0.5522529786902076, 0.869736828368886, 0.3139293868091708, 0.8439974601018504, 0.5463417742373752, 0.5405883545586073, 0.8599010320123488, 0.4966509233960844, 0.7818519438469769, 0.06120529303104871, 0.6402305693821251, 0.2413150153095931, 0.05184521582883406, 0.36455342026996307, 0.6974513052114828, 0.7073055842751903, 0.39346663744843113, 0.49665408826031743, 0.6073332847067101, 0.8244281268165015, 0.23270368171632538, 0.08673800872923376, 0.6263626183603118, 0.5428803352527957, 0.11216907745513482, 0.5764256536894365, 0.6449163111391758, 0.7317520365769606, 0.3810888743829096, 0.7250544609534928, 0.0718956327363448, 0.41435632965826386, 0.540152709832667, 0.3233124495296389, 0.8556824079363168, 0.3042894822265364, 0.028610548681136216, 0.49362654194919375, 0.2066343292532845, 0.943031304333766, 0.11697659617282108, 0.4332933487275805, 0.22793705238429496, 0.6080620923488806, 0.22592717104015259, 0.9651287253957667, 0.5844819518378019, 0.5598857045334723, 0.4304566531598487, 0.8004522106236946, 0.5435407178871977, 0.1270129422306162, 0.12808160804874702, 0.9905106040667433, 0.2063587100438239, 0.5898732325248118, 0.8508599110507239, 0.6449848421651815, 0.5163910969745951, 0.8177865329680911, 0.9832183126348487, 0.6300129095757536, 0.6777573859559185, 0.1375418983538238, 0.7110584773194292, 0.6232005564521382, 0.9465910510638791, 0.9677925350209933, 0.8723378986420084, 0.5993811966263528, 0.36831303886214384, 0.3403919380839773, 0.5052989863697269, 0.5484245570217897, 0.9254591752243866, 0.5479593430098813, 0.7977456837820877, 0.9851836082977957, 0.7335431837159412, 0.806376730124546, 0.8292441842135135, 0.6017076035184828, 0.37653864802038084, 0.001584043622940401, 0.9678503078315228, 0.2331387849962997, 0.2089145549110515, 0.30195308240849594, 0.03394279409766765, 0.16124883697711723, 0.467761023711895, 0.6606845528563776, 0.37596877508238946, 0.6633604453626222, 0.3363928835431026, 0.007087058288874681, 0.8163835743690141, 0.629438525841481, 0.6799209721666377, 0.2312606511136357, 0.02079393105808658, 0.016424530402137538, 0.033631762428939393, 0.903621661759598, 0.2192904223654688, 0.8864263650760008, 0.5666183778928063, 0.038869858652352485, 0.36618093857170464, 0.7841655359857902, 0.16595690039747812, 0.11341252751787867, 0.7628142493584721, 0.24912220125108953, 0.49082385570007125, 0.9759245893316045, 0.8879087258839924, 0.32910791753752644, 0.8313021157946369, 0.25263792902361304, 0.6807781301574883, 0.06453483831233775, 0.8732241763549632, 0.34211660710474734, 0.805072904983762, 0.04643915480367922, 0.018253184451608173, 0.11868946613980891, 0.48413195159057854, 0.31635581926547507, 0.7375036820896694, 0.019375275364454825, 0.34376624450635596, 0.07243047227861787, 0.5473558399049632, 0.27604939533207984, 0.3242727579980197, 0.8736937267286422, 0.5877179543624713, 0.6727657800474626, 0.13070288983921108, 0.2932116318187822, 0.4558442571846898, 0.3575611800781293, 0.87888705520588, 0.2608659050344748, 0.9029160446968288, 0.9187334366260085, 0.564442854514398, 0.6578058749758005, 0.23594610189181686, 0.14749921701466762, 0.7329714126775561, 0.07715342250502621, 0.7841675533490854, 0.6521005375649567, 0.2618726997656905, 0.049331543339518724, 0.5869205131346296, 0.762844308022104, 0.4776873645398598, 0.445425617788484, 0.5391505462568328, 0.9732217982175329, 0.9275989636029437, 0.2182762234536446, 0.5909853479142886, 0.49917072201574986, 0.9997073291612709, 0.11854065237773492, 0.23945706440448833, 0.40670480558459543, 0.24391029353424099, 0.5317501308593446, 0.4732896606480864, 0.15755157310606605, 0.6837071679993332, 0.1224281226270918, 0.5357718211773512, 0.35310169927372226, 0.6289647325298785, 0.5426245872800807, 0.3560879912903119, 0.9188882918414661, 0.5006621555488742, 0.06476002672736547, 0.2660810281052056, 0.9649781389057491, 0.9608584476347735, 0.6324620298315442, 0.6672724878930214, 0.08207078953633795, 0.20460243559344404, 0.48811641562707686, 0.6420669222149954, 0.8887661672846525, 0.6152318367333051, 0.23214383095306457, 0.11341920609869072, 0.23237442767392114, 0.11048417679810574, 0.8965518967001243, 0.048844853437251756, 0.5638068671162176, 0.4140697424574291, 0.3741020773717082, 0.3775048572762032, 0.6564999677036113, 0.17583251029655533, 0.3344692669936352, 0.7431987809572814, 0.019989234326870386, 0.3333515969833656, 0.5800616091471876, 0.9514501615276336, 0.0706630379054205, 0.35881309561005537, 0.6467065119115423, 0.9854715079645726, 0.3653915457477257, 0.06720784672809099, 0.3381985788675055, 0.7636460400243825, 0.9781388530569106, 0.4753877195483235, 0.7987434983216793, 0.39026610718845545, 0.4053313834449084, 0.7962392928042177, 0.6736217351859033, 0.5116192573855353, 0.22266908865377755, 0.02821093089205451, 0.8859343818750983, 0.5311145015950262, 0.08423055620829656, 0.7576548692300482, 0.5660827280219459, 0.8599930705541659, 0.5541365485618559, 0.7299234954868264, 0.7106723928015297, 0.08426949617117774, 0.6917013263489035, 0.4648848300295133, 0.21882166196905117, 0.9138999046663933, 0.2729143713895298, 0.6934991455568478, 0.0563927890016892, 0.046776977679386156, 0.024259981151372623, 0.6743251279891, 0.43245420268187595, 0.6280016347206527, 0.26929557092051026, 0.5123006835397782, 0.03732052894164439, 0.8139836022830387, 0.9440740900765747, 0.44686950172106477, 0.5878063510271612, 0.06127427747515091, 0.024409633544225318, 0.7025020409109487, 0.1528688182483935, 0.15163724671949597, 0.02614979253458738, 0.9018852102622303, 0.9916032270243487, 0.6377129480524508, 0.3890319605732019, 0.23053201702208936, 0.9255947174334199, 0.3477357738886748, 0.23536518165156384, 0.5112891181221748, 0.5889182391298928, 0.8231135056995449, 0.20669285603294196, 0.09819646978624197, 0.25161829991950235, 0.07928048701408985, 0.8247561959059956, 0.03138000295488719, 0.29628858601080954, 0.8780871380631318, 0.09749181056077183, 0.20813489930080364, 0.8424112125214175, 0.7790909035783274, 0.8964611660142642, 0.42008339388692617, 0.45940362282357705, 0.5974640625592987, 0.9690238788567141, 0.9822677119526413, 0.386861284018006, 0.5378365600882183, 0.3167303320834375, 0.337265386370862, 0.18927216580380157, 0.1962426612525483, 0.07082389387227883, 0.4558905158791532, 0.3125192202307562, 0.8264424714211004, 0.9264064709606245, 0.07577146592555739, 0.5807751405228933, 0.7522403246809188, 0.6587352034215161, 0.8200716235705114, 0.27493359166211906, 0.5740243208858877, 0.23828309035787798, 0.020846779181484143, 0.06750958056193657, 0.8656020900741411, 0.5856087394554522, 0.6350090305305728, 0.7539806661987701, 0.3865098184858219, 0.06274626262673211, 0.985593802636248, 0.4168305831246818, 0.44532350586377045, 0.38473912803599164, 0.18700305323227306, 0.3860947490406502, 0.941102057647464, 0.7531063535956866, 0.02012416791348126, 0.1189970867788066, 0.7829440239990755, 0.6624436875033125, 0.7117011262529928, 0.9113061411545429, 0.8417417325858946, 0.01202593541156416, 0.5420602735553125, 0.1743279958909878, 0.3235667931740789, 0.8661909409164489, 0.4562705171426107, 0.8639919984334118, 0.47072402421893955, 0.45045026545792377, 0.8860434197898291, 0.5322747926164181, 0.7943615344591393, 0.7446844679093463, 0.8031558686916712, 0.38624715070619053, 0.6216263387975556, 0.3404463744222931, 0.6199044911845142, 0.6863169002379822, 0.6007066481139541, 0.0663086996903437, 0.9280771110855414, 0.7927806917704723, 0.9487036235866055, 0.25335700402437467, 0.22515355854862584, 0.17858606537560007, 0.6501264954678921, 0.41234281760349334, 0.7149246461614032, 0.7662446172818268, 0.5179070190800631, 0.5246759366658877, 0.9894444175449165, 0.018125911102243264, 0.014180533635758441, 0.11134887469193278, 0.9002075921231192, 0.31190098477386685, 0.9946824007215243, 0.73705057753459, 0.20867063653934048, 0.26669318925745034, 0.08846035871360924, 0.6311405018473982, 0.6697114917419129, 0.8505335820701484, 0.253704860186709, 0.6628183537748833, 0.04634916840204706, 0.2960064891140779, 0.16085073172569098, 0.9947385489540913, 0.1800218758949349, 0.0785105709114442, 0.4457055525389573, 0.35748299242322257, 0.647947703907537, 0.4703493106687232, 0.5482112464641501, 0.03671950852092554, 0.7275696309842361, 0.4739042187193483, 0.8065471157765987, 0.3455370256538973, 0.3578122312292127, 0.25843301384239514, 0.7116344527222654, 0.5663636608062355, 0.5378546887480906, 0.5775739245494271, 0.7437036494989443, 0.09003668189094982, 0.13635094192329744, 0.0284265742136105, 0.010437071711109636, 0.7540084228505209, 0.3975042328763504, 0.4281190470356484, 0.9853020925091278, 0.18733556348586378, 0.5251306424235476, 0.030059021648942696, 0.005040258721421997, 0.30701369886028207, 0.6018214417528727, 0.7796074945101428, 0.8268805017928095, 0.9783830981534365, 0.7575421616190227, 0.3177006654387535, 0.46889522944563344, 0.251745258250899, 0.9404814758267633, 0.9809864584401601, 0.7610201993508376, 0.517994485240432, 0.8626906974695009, 0.6183298838233863, 0.5196106893095651, 0.38798242470155064, 0.6940303787581904, 0.646081496235434, 0.025007430885913617, 0.09349765463284987, 0.8601676006813828, 0.3982912760437475, 0.5294381214584203, 0.7321563334981261, 0.8638437871050257, 0.49309039672188104, 0.8516812569521951, 0.7341643393560188, 0.39335976936667105, 0.6327515003161387, 0.7252710970751083, 0.5158250032642193, 0.10820102083851935, 0.982477684157562, 0.45862361114052663, 0.40283080202509214, 0.39895280253058163, 0.03175924406577757, 0.6383152820737114, 0.5557914719055796, 0.10713142710252543, 0.632176439955987, 0.0608480000390732, 0.8111148915170588, 0.6602843917841769, 0.7268153592462263, 0.8135848046572324, 0.06227129502217399, 0.3286887953736418, 0.1390034246525671, 0.4421428614984312, 0.04963548411190888, 0.34220389796190065, 0.6718595718262638, 0.4393816950353354, 0.20151550015104114, 0.41931026195136734, 0.6851938738054861, 0.8702260484904135, 0.47464066509910097, 0.8550946292933098, 0.2625798653266451, 0.8069144864743139, 0.979295496259767, 0.6909159764210541, 0.05896212173015025, 0.390866522144807, 0.5424507423498748, 0.6457149987768788, 0.9279509251365425, 0.7602121450826145, 0.2616559349962171, 0.42740573195192166, 0.4679943746044256, 0.786129758506203, 0.5331226937207156, 0.7625146378209181, 0.6979078552508207, 0.5464897676814375, 0.999341941157968, 0.9832088097211704, 0.17477983899788385, 0.731902662022556, 0.35474167040193405, 0.29308202377909365, 0.0010613082887808156, 0.7271220736027116, 0.9723069100527478, 0.8965432616781995, 0.3326865646151713, 0.9398547510778907, 0.869746597660926, 0.021379541983393313, 0.19636047140352453, 0.05938113721454563, 0.6207071327511362, 0.4900409489951948, 0.6516880806468488, 0.3189915054383611, 0.4346954429400113, 0.9024225622537728, 0.5926099669861865, 0.5090945136763229, 0.7787894394522553, 0.6813946125721556, 0.7726471323637558, 0.4419563205491177, 0.5948767829764823, 0.2020584877402274, 0.9597471033236044, 0.8043800333601895, 0.3780781741177628, 0.976683076875788, 0.4790629624266951, 0.8512371448156995, 0.12517381359946678, 0.39950221451549073, 0.7857855266630962, 0.19061342489168132, 0.43626778745242933, 0.8690308858320752, 0.12518801886439512, 0.9904342969614699, 0.8585870091881436, 0.200284086433979, 0.7833317619969772, 0.29678527321423864, 0.8982272198255777, 0.11525885203156405, 0.9094206161479359, 0.7957454576384301, 0.9938217170069457, 0.2572669103350502, 0.3995805226571322, 0.2734031373542294, 0.14552229415644224, 0.6131813634817604, 0.8718798559976885, 0.23282417592073468, 0.8233470498644815, 0.4473878553358761, 0.3336955815060807, 0.6120956099627088, 0.24086246172107928, 0.8522070558255441, 0.7450686861504409, 0.3141682946401747, 0.07333211644265158, 0.8017817938414169, 0.3154819273526578, 0.30707407625531324, 0.22387821776143435, 0.1598988954256716, 0.03653179860353373, 0.38219431481798927, 0.2968659154897849, 0.4369422283917611, 0.6492556939049434, 0.26860869365619333, 0.024635090269942483, 0.21714999066163276, 0.9724142828165802, 0.6931539913935609, 0.01186728340156229, 0.08457605650051625, 0.2768182181879144, 0.1486748340551246, 0.8112909733156827, 0.5646314078069311, 0.18082744481495183, 0.5870495902862892, 0.525090930810909, 0.06780851877018934, 0.363440186747229, 0.9889261300040899, 0.8383026114279166, 0.07316815237085805, 0.24392805785289096, 0.7787039127266818, 0.6336360098646844, 0.8213942918655992, 0.6607624724357783, 0.3511504189165353, 0.11158762642342068, 0.600699689130381, 0.497617090501983, 0.5551411816168322, 0.6453632999624191, 0.30359136220390315, 0.15051946364222146, 0.8403648830577864, 0.43704851159163194, 0.3084811244833112, 0.7077645429012988, 0.9144355291556726, 0.40962737167853824, 0.8973537537009878, 0.722991764429621, 0.18070664213692422, 0.668864574842084, 0.3591814019966306, 0.5018662060669419, 0.9311826365967886, 0.29972992840203083, 0.6484992462439094, 0.8940937470684301, 0.2542748951229319, 0.22395811416712186, 0.9695347167375287, 0.6850388632386013, 0.8837515410456656, 0.33850061835977907, 0.9385083891971288, 0.8150029322894962, 0.7630810543599253, 0.17904145522488424, 0.040201387502320385, 0.8192601728439388, 0.9284721378124123, 0.9084114346011208, 0.9396113712953215, 0.07823690970932884, 0.42426299095602116, 0.5166504712938688, 0.8354944446848621, 0.6947594316834454, 0.35591529636928354, 0.7376312414790179, 0.4498184626346423, 0.07408442357601197, 0.8587197674654289, 0.3365714314709053, 0.4356282101525357, 0.5724653163555667, 0.7144211705831098, 0.1034263291385672, 0.9555507614785771, 0.9012965523548433, 0.583322969387743, 0.09906693892488594, 0.9341451194208407, 0.32641722620782265, 0.33603259892021853, 0.44431343769067966, 0.01952708825013061, 0.08594451044453166, 0.7668608699429869, 0.2163076039123989, 0.6031769358347926, 0.8650460799645633, 0.049989272151497954, 0.8223716070670788, 0.34156364766777614, 0.6123502017087165, 0.65987196432948, 0.5584155188414207, 0.49919677841152177, 0.4602310626572177, 0.11893946739764161, 0.9271187503420621, 0.08994247276026901, 0.019995688035185588, 0.8585237428446321, 0.6905257107026352, 0.23191809070052916, 0.8630385102838005, 0.6830250632951304, 0.5623595672874977, 0.3510049662439436, 0.5703179782790397, 0.8126931571193461, 0.9072719287271777, 0.8689968158538, 0.3350491829543768, 0.2469964786607931, 0.807410867309852, 0.794626769064435, 0.7372953529562453, 0.23840502882574777, 0.38110308415140415, 0.19919306172442497, 0.9741800617951845, 0.9955136443162775, 0.2941106428642394, 0.9032302641358634, 0.5257313245700169, 0.3447845794374397, 0.9908364689794852, 0.8266484839330276, 0.9639072109407576, 0.9717891512613717, 0.2910169103402268, 0.361990952530004, 0.37114272460795505, 0.035680442160704984, 0.6468539141622319, 0.8189355887642592, 0.6247955344129472, 0.4047300946394392, 0.536202920284703, 0.45789380898280385, 0.6251580394441217, 0.496114222857153, 0.1793474834695311, 0.8815354297018205, 0.39724217038185694, 0.7197345853205573, 0.010054716703642441, 0.5852961296422488, 0.880332076402046, 0.8237131126372614, 0.10602055800099264, 0.28139950458350105, 0.13433927065120432, 0.01829932188574912, 0.08947743124123941, 0.20565289696855826, 0.6382836261052276, 0.6152815071865977, 0.8456508703592832, 0.9922526773619811, 0.3337628706102228, 0.06159448541054091, 0.7749164931439146, 0.8590609735450341, 0.07506203100777398, 0.6686681131524347, 0.1939214551894587, 0.7842927898918574, 0.1875937390556458, 0.043162118863241616, 0.9316000439501235, 0.07527849988782753, 0.9076488717463252, 0.21008478722518387, 0.12792600805354315, 0.23094378027805684, 0.5789766076520836, 0.6858943056702362, 0.7364087750663726, 0.28187544293450273, 0.6155013890110582, 0.3070331337569471, 0.25575486521282764, 0.8553179061508741, 0.40452416862323437, 0.4484474657258821, 0.771779484620952, 0.05717202047694958, 0.5210435173007956, 0.3769953673219295, 0.4775677014063633, 0.8890441799754385, 0.8513718455614692, 0.8762487034196931, 0.45804851960172777, 0.32562070234936336, 0.4830109470943379, 0.9520455331162402, 0.674559255055672, 0.36611826458356145, 0.5077896588930053, 0.3822510698507805, 0.7656415114282095, 0.3432884912851015, 0.20655642707916988, 0.10953747984311579, 0.4922245877660807, 0.5244309583875101, 0.43625754106349746, 0.9925932193168217, 0.39851548900785194, 0.5710954450234587, 0.4240216708155945, 0.22902559602470463, 0.5343296138599948, 0.7376310027513951, 0.5879102516179066, 0.842320329698104, 0.8902595762611292, 0.783465852007524, 0.4502818485094473, 0.9855748012439959, 0.5339937271874868, 0.4499786331745659, 0.1872582844923787, 0.4563222362104945, 0.30426088715656185, 0.010048268123323933, 0.8665691996348001, 0.7396160044237075, 0.31829026840009356, 0.836846091050436, 0.9660905824158681, 0.1006451340578205, 0.47934140055714314, 0.15816058095225238, 0.3366819184431584, 0.7335029916544943, 0.6327714438663586, 0.16352142079758591, 0.37546608403858506, 0.7393330900301549, 0.012272331061795705, 0.4136164654491865, 0.8094844532197909, 0.7549275889786411, 0.14232375978998357, 0.06497156796089176, 0.15469949400191185, 0.3819554280058487, 0.4185722028263994, 0.7675895241781592, 0.6116055873905321, 0.17734859325502494, 0.17476030703764034, 0.21922154266377736, 0.8862481898081563, 0.8569766381857366, 0.1629948966788618, 0.26717099173024583, 0.18424056999956684, 0.5375913835667359, 0.023556071996016614, 0.13700509031463726, 0.41540609528904093, 0.2961246291481996, 0.5011138104575467, 0.8372779595572137, 0.46796347739702404, 0.060774130980234986, 0.8761325866134053, 0.040343999026975386, 0.26371111415633475, 0.8649138756959612, 0.3234085444485634, 0.7715675761624927, 0.18945606620630573, 0.792716826213444, 0.684098115297153, 0.0527116272173368, 0.41497197578526357, 0.5244795125513011, 0.443260259301813, 0.24001402242082703, 0.554059366465205, 0.24998957201286642, 0.5418497439763407, 0.17343735615748668, 0.10282110906584996, 0.8598788449141749, 0.02026182772865137, 0.41080433536635486, 0.09805431226364258, 0.7477562629395873, 0.38994339763765884, 0.7590076776047808, 0.4786996423419788, 0.2600162290823774, 0.06024950105576954, 0.03420926182228434, 0.7045776215191719, 0.8155698683962542, 0.1096383081060438, 0.4839209863656321, 0.28918070568908183, 0.9843478910057857, 0.18346163824344686, 0.586085446179915, 0.03707915515785731, 0.3612757172663661, 0.3250219956309379, 0.003751378134085992, 0.9415373794193996, 0.9015226583255596, 0.10223147921309872, 0.31866540937165155, 0.8942270343969004, 0.4931788733381043, 0.47912196567477694, 0.793078470306343, 0.5864615917255834, 0.9351150620116284, 0.4996195026416921, 0.8162910794533771, 0.2401668134518442, 0.16063188812532458, 4.1071345578913565E-4, 0.880939104906787, 0.09684009328475729, 0.501606954512696, 0.2503923575185315, 0.9037476363146381, 0.9140408746060228, 0.023199415138712487, 0.6261098129586149, 0.45645722862003957, 0.07149375957973969, 0.47577382486060826, 0.17575388627024902, 0.004853646998843275, 0.2726742163052137, 0.2085554283273402, 0.1986996606130893, 0.5673082933523376, 0.24278663933218825, 0.46863233762292766, 0.7732350871884667, 0.2989637400618703, 0.270333181194773, 0.8692698044151088, 0.5020410452354696, 0.38367442016269104, 0.9170107986386902, 0.4531049408694322, 0.6131488543409319, 0.2730402648378569, 0.7294631532011782, 0.6986403471284404, 0.9535148089586437, 0.7503464092167956, 0.32645328234701454, 0.022558211607413226, 0.34301608193027455, 0.516949833863284, 0.8063113309910027, 0.8157263201357089, 0.21858571859153952, 0.9996291440779632, 0.02205154773735396, 0.8173707614997486, 0.49136899363292574, 0.8596414849007725, 0.9053412253074398, 0.6797399317732223, 0.0641970431022677, 0.24770627182236826, 0.6855434461766108, 0.9046874383758515, 0.5123383360364125, 0.19386217454918264, 0.5463448012528804, 0.9439521140497291, 0.01740181510418659, 0.6471207892492593, 0.9900180109530095, 0.14651556439308422, 0.7624304680709225, 0.5870663026285363, 0.9381585926427005, 0.40926856961768254, 0.6456373092923272, 0.3180275284321422, 0.38777364104914913, 0.8413199240069941, 0.35090060557374125, 0.5261752400966742, 0.26289020868766155, 0.48763245155497725, 0.5250486337529774, 0.9308737919019758, 0.954389335563752, 0.17427233946551213, 0.05512855835626118, 0.39384326911352086, 0.9245611950516284, 0.8354101041308097, 0.21326812355605773, 0.16316455539147856, 0.6679157995082192, 0.2613124352267594, 0.7424030326476511, 0.5238860793732265, 0.26607270679491524, 0.06691590902440969, 0.7930563356955391, 0.5029683915740398, 0.7520922917550852, 0.822175600378956, 0.989521141758688, 0.4335280877590262, 0.5084002160202808, 0.7082323447953294, 0.803211252831149, 0.12182033156065875, 0.9624956856871979, 0.767544593999887, 0.8416087880579075, 0.08012494150792182, 0.9159234062580813, 0.8014821310884834, 0.6231517556669371, 0.7896779442482735, 0.9445278442927119, 0.23548072057803093, 0.9015687155657681, 0.24001724097203037, 0.4417976775732777, 0.819707768160503, 0.6275816510449805, 0.054586887535808204, 0.042147638693689204, 0.8622912961042896, 0.19156218683162873, 0.35717202842821794, 0.35727327286977406, 0.8025156784867237, 0.6776405316566387, 0.15971224875420142, 0.1862539726237199, 0.3229892500000371, 0.4779304948033667, 0.45926799706647703, 0.6188684568253656, 0.8726405069045297, 0.7649476873944109, 0.42039171225990835, 0.7416256128511308, 0.42650124821429947, 9.628817526257105E-4, 0.9888807803441501, 0.9773030783077373, 0.5435861527530242, 0.8749453964008708, 0.03386717701194364, 0.44132485116486897, 0.3007806967458455, 0.800916725788234, 0.6474246558160697, 0.08209837401008646, 0.47849970886293747, 0.3859476295732184, 0.5443505864104751, 0.7874703434342138, 0.4529817054491948, 0.08169645526207048, 0.5995069416713307, 0.08574981354338684, 0.6104345604817762, 0.570300757350241, 0.43608069007458294, 0.5472861886123035, 0.7398503937320647, 0.3035974613818543, 0.6353509656013465, 0.5013786723605159, 0.7841588860433529, 0.014062225485000801, 0.577026626497066, 0.22333286886611503, 0.5334896552561671, 0.9465211340590088, 0.1389444281222919, 0.31776914019984204, 0.3296659097242447, 0.021603527859719973, 0.4858948748905546, 0.6268267933279168, 0.6176537557982936, 0.13506738816362218, 0.9595688984155504, 0.625696688676395, 0.2275418273213552, 0.32154383792694985, 0.6450955322180364, 0.9329542827176698, 0.5997289931423118, 0.566910827566396, 0.534367033841271, 0.25945428964138284, 0.7763481651750632, 0.6404202766562104, 0.3323244413703156, 0.8470865212645597, 0.8735566366968162, 0.43586695139251086, 0.859603566662458, 0.20748270712707473, 0.9221744266169035, 0.960501513846311, 0.6934171637364125, 0.7608016931567461, 0.4182542639503489, 0.291054378503944, 0.15827650757366363, 0.7960109702100756, 0.6605173460820108, 0.5281504348133801, 0.029131329580004528, 0.026620315857449617, 0.9681921063397053, 0.0235597405043263, 0.3417344978130039, 0.8996132570605945, 0.1706431343564936, 0.929142517160751, 0.5185132924126918, 0.7303604420018812, 0.33928029067523957, 0.42201107772184665, 0.6129569755184001, 0.6825887817984674, 0.5925888488354544, 0.7973459551145338, 0.8515056431289295, 0.5900185559486169, 0.9467233279283681, 0.9884662618044171, 0.8091530359527029, 0.6250704152346397, 0.6069592350089194, 0.9731699451630242, 0.4934516367532784, 0.8600826653365701, 0.7993983539233706, 0.9560225103506065, 0.3313355096975724, 0.8377687577787386, 0.22767513579849152, 0.17818714813203795, 0.5541528118933369, 0.37018376389845375, 0.5060128106370169, 0.6995535991669429, 0.7585261905948336, 0.9192575669547932, 0.467829822412571, 0.5223368233907058, 0.48413616122280934, 0.07699193491388301, 0.07819849733121331, 0.9809804426943209, 0.49424893870085596, 0.8597071162447015, 0.7888095892121155, 0.410114717375044, 0.0707869468235568, 0.7582633535094002, 0.5656977174750978, 0.720481804656306, 0.042966418669324935, 0.7449712908439561, 0.4928346160774987, 0.6621561201674511, 0.45700358576631295, 0.7279443305287012, 0.8087980558010065, 0.23505117455052127, 0.7641169976622764, 0.26493530252302944, 0.46907664193411214, 0.9186181201653775, 0.15503058800020242, 0.7012388275436985, 0.8431717722210634, 0.13580607284701085, 0.20140801769017835, 0.28002952370512846, 0.9535093709708845, 0.6407674333244191, 0.278126202898741, 0.18854560808144294, 0.7422764736086847, 0.32545605148276024, 0.33502163120480544, 0.9498163751077822, 0.21264817756110677, 0.27718014248288503, 0.4627205404656186, 0.047171104460250746, 0.93247293841304, 0.7873355705598837, 0.35438951170323607, 0.17755599802697042, 0.3113352176842471, 0.41095944758160763, 0.20372087570200914, 0.0697246943012797, 0.26601640493347534, 0.10740818920001272, 0.7991926207161396, 0.3746574146432612, 0.37472608817505515, 0.9543777250331428, 0.5756200436997387, 0.738102101030452, 0.3870778315212896, 0.9206481546048468, 0.16624236529042302, 0.7989209148792408, 0.004634551380570451, 0.7073490939116764, 0.5620643582905744, 0.5219635155794219, 0.17595099995161478, 0.7232055665050809, 0.3298993794934697, 0.9704784700452568, 0.7603912504844959, 0.8461390181857835, 0.4665372076851252, 0.3506126527893819, 0.3066020372880176, 0.7417616853354079, 0.373686018179881, 0.9193378894510142, 0.8643729703324564, 0.1587166732787776, 0.1268147822833583, 0.13718285543867026, 0.2027174435494088, 0.8014802409428463, 0.6807491318240777, 0.26843751276946326, 0.542358540380956, 0.09315680734447418, 0.9058496932094514, 0.4840365860578423, 0.9274068354234287, 0.3839613027155111, 0.380829024395159, 0.4061170872752945, 0.6588675397227821, 0.9354972502261986, 0.6817394806453684, 0.9482846355200045, 0.7917168584143468, 0.316603813808236, 0.5013911705279568, 0.2519117494043517, 0.5576383254947643, 0.6834579585712558, 0.30943550974555556, 0.4963310681951111, 0.7171121572946748, 0.7847830597795231, 0.4205765865161012, 0.36957467779988884, 0.2674012838503157, 0.43242847277500984, 0.2768490073379889, 0.026350448722855635, 0.6370802372281434, 0.6082493158772596, 0.4696275133374215, 0.4312352106321129, 0.4831039812648561, 0.34012935385182397, 0.5280102810863527, 0.08760327333531348, 0.4730157254536329, 0.9731539358370954, 0.7824442391822748, 0.2865984488423552, 0.9827439588943535, 0.48635446845643004, 0.675937404932001, 0.17549626254267403, 0.4695409031506067, 0.061109163683826795, 0.7399297271457063, 0.14109250479896163, 0.38996587010682426, 0.19419987641749292, 0.07787062855732019, 0.23129320714522006, 0.9244185165645431, 0.2666878494432915, 0.60677785320229, 0.5968698426993403, 0.4425789944796711, 0.6291860176435833, 0.495528772337402, 0.22538334475986055, 0.5982129696031099, 0.9447694024091842, 0.20836200208094335, 0.5605688925569954, 0.17715137389728475, 0.7426788857081008, 0.3130438133675837, 0.9530127874610185, 0.3388564806762818, 0.8791381256193972, 0.7453798187079815, 0.27174203393070084, 0.6898368648121074, 0.8760171010401977, 0.5352300059901473, 0.4213856722503776, 0.7062761644301182, 0.9137402577357122, 0.09391058716422462, 0.955856555917736, 0.38359137465532656, 0.591750608281148, 0.03884364555018838, 0.45704127766160596, 0.6322384497840439, 0.43800606714712476, 0.18854153401332163, 0.8557743840945311, 0.8619344945040113, 0.5483975158524402, 0.799489856056852, 0.4124131747175317, 0.40056698118586587, 0.6676429147086961, 0.3362192075721404, 0.6456172032783876, 0.8794127736391154, 0.48512516737348843, 0.06683263713981091, 0.10047681200808345, 0.4828903623403058, 0.9123059801134988, 0.558482133122839, 0.4809230871685861, 0.008921004563355539, 0.6327618661176918, 0.7107642306022236, 0.336391685062855, 0.015075866973539687, 0.27155251615549025, 0.309731126605466, 0.1890008241562936, 0.9360374586395815, 0.11754548370576956, 0.2111904517419767, 0.7150443631267378, 0.9495055876482303, 0.4504861545175245, 0.16919345934012497, 0.3533881919226116, 0.5405297612936136, 0.17401480053039342, 0.014087695565161873, 0.503398784282802, 0.16835088642122686, 0.636497388112657, 0.35423708495419615, 0.2963207202914656, 0.17518732459042252, 0.2334506957301371, 0.22648850893275263, 0.7765597418535802, 0.0930018046229305, 0.6285063885345056, 0.1526912477235226, 0.21311663616313448, 0.8021366461480147, 0.20427238600625386, 0.8730512674010751, 0.1764561592894509, 0.5748074669138526, 0.6601146338221092, 0.6218296760524706, 0.9623848503700837, 0.8967958168809964, 0.5107957789462345, 0.18687091485226692, 0.9220500690246949, 0.10228377181891934, 0.6080715125456274, 0.15167265795003182, 0.26596177713845015, 0.27962446458178825, 0.7067598628539782, 0.6571864313351853, 0.949977959565147, 0.6099445305549137, 0.5274619100317454, 0.7402640308635224, 0.3224833915114246, 0.2858253640727566, 0.7300272823291131, 0.8066416370356715, 0.31453027962814484, 0.4239125922207738, 0.7050214270228673, 0.07857991171826917, 0.0884989934207151, 0.9331538142773654, 0.11486563999348753, 0.9207554522820501, 0.22587563693882962, 0.12946676698884751, 0.6719853036441864, 0.7927245513243262, 0.7310324504629877, 0.9979914078243828, 0.7282154724416964, 0.20225788622864216, 0.3554360243958816, 0.39568118222436965, 0.8678771103768481, 0.44107038486777106, 0.00549767864010775, 0.15983997315828213, 0.8463514184619181, 0.07294791137607382, 0.2873188885044291, 0.042313158842746335, 0.8966437781001951, 0.1139980277260747, 0.5628742001753058, 0.6243924414297433, 0.6383426244614759, 0.5957297573414817, 0.24471285707695178, 0.8840958777534612, 0.566543066154213, 0.7338926997292247, 0.4400493663007389, 0.8853362765783597, 0.37271871887888464, 0.23948346066242843, 0.4701528740446904, 0.13759193115076984, 0.15518958599974875, 0.40305308787641914, 0.23723315118379296, 0.5350464220471358, 0.9137476314847938, 0.459426226399374, 0.8885614317205172, 0.42576445318308986, 0.591165963715361, 0.3971692572898804, 0.7363521719428259, 0.2843234546949426, 0.32373150739720236, 0.815620863003609, 0.9319717303121621, 0.6654214702758393, 0.49360505774269625, 0.6520255980638622, 0.9643286993586638, 0.6013334299599387, 0.6377268352511638, 0.6022872129161447, 0.6548393134657181, 0.3726902475960143, 0.261149584151253, 0.841084978206148, 0.9551514259912599, 0.6299055931278653, 0.12709524051403254, 0.21057329484988296, 0.5188483300132898, 0.17167765191287, 0.6516956097268104, 0.39161072362946103, 0.7146438680665366, 0.2973444333076387, 0.6182910708370503, 0.6974419982641732, 0.47611869503322146, 0.5414726442413245, 0.54432584047129, 0.03698224521279703, 0.14183671335740444, 0.7719119196920248, 0.6832920083674874, 0.28332985971956715, 0.22972023334154745, 0.08664752601947534, 0.824839083861941, 0.7528608817360385, 0.9108505055140402, 0.6801365680691708, 0.7680790519789746, 0.7512339627875511, 0.8004005032061937, 0.8664137765353679, 0.5862822669430333, 0.1748620990828228, 0.5671948653087077, 0.7441052442180051, 0.5755720074866918, 0.9698833943455212, 0.7784318842136717, 0.567589053200341, 0.08589109802530559, 0.8453901302272869, 0.3423904082822049, 0.7488943745050228, 0.2694268809591137, 0.01365139578932928, 0.8894848729489567, 0.5565313935497637, 0.1498456423076432, 0.8872917402920453, 0.4408195816089644, 2.9629895211269464E-4, 0.3151012461377547, 0.6018644706303086, 0.7534332225723525, 0.0951970937109432, 0.9672470407572666, 0.9519847765099261, 0.8027129894498232, 0.68299751904933, 0.02459395872486969, 0.83016471366898),
];
