/*
 * Copyright (c) 2013, 2016, Oracle and/or its affiliates. All rights reserved.
 */

#ifndef PlatformStrategiesJava_h
#define PlatformStrategiesJava_h

#include "CookiesStrategy.h"
#include "LoaderStrategy.h"
#include "PasteboardStrategy.h"
#include "PlatformStrategies.h"
#include "PluginStrategy.h"
// #include "SharedWorkerStrategy.h"
// #include "StorageStrategy.h"
// #include "VisitedLinkStrategy.h"

class PlatformStrategiesJava : public WebCore::PlatformStrategies,
    private WebCore::CookiesStrategy,
    private WebCore::PluginStrategy
 {
    // ,private WebCore::SharedWorkerStrategy
    // ,private WebCore::StorageStrategy
    // ,private WebCore::VisitedLinkStrategy
public:
    static void initialize();

private:
    PlatformStrategiesJava();

    // WebCore::PlatformStrategies
    virtual WebCore::CookiesStrategy* createCookiesStrategy();
    virtual WebCore::LoaderStrategy* createLoaderStrategy();
    virtual WebCore::PasteboardStrategy* createPasteboardStrategy();
    virtual WebCore::PluginStrategy* createPluginStrategy();
    // virtual WebCore::SharedWorkerStrategy* createSharedWorkerStrategy();
    // virtual WebCore::StorageStrategy* createStorageStrategy();
    // virtual WebCore::VisitedLinkStrategy* createVisitedLinkStrategy();

    // WebCore::CookiesStrategy
    virtual String cookiesForDOM(const WebCore::NetworkStorageSession&, const WebCore::URL& firstParty, const WebCore::URL&);
    virtual void setCookiesFromDOM(const WebCore::NetworkStorageSession&, const WebCore::URL& firstParty, const WebCore::URL&, const String&);
    virtual bool cookiesEnabled(const WebCore::NetworkStorageSession&, const WebCore::URL& firstParty, const WebCore::URL&);
    virtual String cookieRequestHeaderFieldValue(const WebCore::NetworkStorageSession&, const WebCore::URL& firstParty, const WebCore::URL&);
    virtual bool getRawCookies(const WebCore::NetworkStorageSession&, const WebCore::URL& firstParty, const WebCore::URL&, Vector<WebCore::Cookie>&);
    virtual void deleteCookie(const WebCore::NetworkStorageSession&, const WebCore::URL&, const String&);

    // WebCore::DatabaseStrategy
    // - Using default implementation.

    // WebCore::PluginStrategy
    virtual void refreshPlugins();
    virtual void getPluginInfo(const WebCore::Page*, Vector<WebCore::PluginInfo>&);
    virtual void getWebVisiblePluginInfo(const WebCore::Page*, Vector<WebCore::PluginInfo>&);
    WebCore::BlobRegistry* createBlobRegistry() override;

    // // WebCore::VisitedLinkStrategy
    // virtual bool isLinkVisited(WebCore::Page*, WebCore::LinkHash, const WebCore::URL& baseURL, const WTF::AtomicString& attributeURL);
    // virtual void addVisitedLink(WebCore::Page*, WebCore::LinkHash);
};

#endif // PlatformStrategiesJava_h
