#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
TAR=../oscache_$2+ds1.orig.tar.gz
DIR=oscache-$2.orig
SVN=http://svn.opensymphony.com/svn/oscache/tags
TAG=$(echo "v$2" | sed "s,\.,_,g")

svn export $SVN/$TAG $DIR
rm -rf $DIR/trunk
tar -c -z -f $TAR --exclude '*.jar' --exclude '*/docs/api/*' $DIR
rm -rf ../$TAG $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
