# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ActionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
    """

    INTERNAL = "Internal"

class ApiVersionParameter(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    TWO_THOUSAND_TWENTY09_01_PREVIEW = "2020-09-01-preview"
    TWO_THOUSAND_TWENTY_ONE04_04_PREVIEW = "2021-04-04-preview"
    TWO_THOUSAND_TWENTY_TWO03_01 = "2022-03-01"

class AutoTrackingConfiguration(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Auto track configuration.
    """

    DISABLED = "disabled"
    X_BAND = "xBand"
    S_BAND = "sBand"

class Capability(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Capability of the Ground Station.
    """

    EARTH_OBSERVATION = "EarthObservation"
    COMMUNICATION = "Communication"

class CapabilityParameter(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    EARTH_OBSERVATION = "EarthObservation"
    COMMUNICATION = "Communication"

class ContactProfilesPropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current state of the resource's creation, deletion, or modification
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    UPDATING = "Updating"
    DELETING = "Deleting"

class ContactsPropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current state of the resource's creation, deletion, or modification
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    UPDATING = "Updating"
    DELETING = "Deleting"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class Direction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Direction (uplink or downlink)
    """

    UPLINK = "uplink"
    DOWNLINK = "downlink"

class Origin(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system"
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"

class Polarization(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """polarization. eg (RHCP, LHCP)
    """

    RHCP = "RHCP"
    LHCP = "LHCP"
    LINEAR_VERTICAL = "linearVertical"
    LINEAR_HORIZONTAL = "linearHorizontal"

class Protocol(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol either UDP or TCP.
    """

    TCP = "TCP"
    UDP = "UDP"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current state of the resource's creation, deletion, or modification
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    UPDATING = "Updating"
    DELETING = "Deleting"

class ReleaseMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Release Status of a ground station
    """

    PREVIEW = "Preview"
    GA = "GA"

class SpacecraftsPropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current state of the resource's creation, deletion, or modification
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    UPDATING = "Updating"
    DELETING = "Deleting"

class Status(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Status of a contact.
    """

    SCHEDULED = "scheduled"
    CANCELLED = "cancelled"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    PROVIDER_CANCELLED = "providerCancelled"
    CANCELED = "Canceled"
    RUNNING = "Running"
