# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class Configuration(ProxyResource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar value: Value of the configuration.
    :vartype value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration.
    :vartype data_type: str
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :ivar source: Source of the configuration.
    :vartype source: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        source: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Value of the configuration.
        :paramtype value: str
        :keyword source: Source of the configuration.
        :paramtype source: str
        """
        super(Configuration, self).__init__(**kwargs)
        self.value = value
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = source


class ConfigurationListResult(msrest.serialization.Model):
    """A list of server configurations.

    :ivar value: The list of server configurations.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.Configuration]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Configuration"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of server configurations.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.Configuration]
        """
        super(ConfigurationListResult, self).__init__(**kwargs)
        self.value = value


class Database(ProxyResource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar charset: The charset of the database.
    :vartype charset: str
    :ivar collation: The collation of the database.
    :vartype collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        charset: Optional[str] = None,
        collation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword charset: The charset of the database.
        :paramtype charset: str
        :keyword collation: The collation of the database.
        :paramtype collation: str
        """
        super(Database, self).__init__(**kwargs)
        self.charset = charset
        self.collation = collation


class DatabaseListResult(msrest.serialization.Model):
    """A List of databases.

    :ivar value: The list of databases housed in a server.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.Database]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Database"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of databases housed in a server.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.Database]
        """
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = value


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.rdbms.postgresql.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.rdbms.postgresql.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar start_ip_address: Required. The start IP address of the server firewall rule. Must be
     IPv4 format.
    :vartype start_ip_address: str
    :ivar end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
     format.
    :vartype end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_ip_address: str,
        end_ip_address: str,
        **kwargs
    ):
        """
        :keyword start_ip_address: Required. The start IP address of the server firewall rule. Must be
         IPv4 format.
        :paramtype start_ip_address: str
        :keyword end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
         format.
        :paramtype end_ip_address: str
        """
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class FirewallRuleListResult(msrest.serialization.Model):
    """A list of firewall rules.

    :ivar value: The list of firewall rules in a server.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.FirewallRule]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.FirewallRule"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of firewall rules in a server.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.FirewallRule]
        """
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = value


class LogFile(ProxyResource):
    """Represents a log file.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar size_in_kb: Size of the log file.
    :vartype size_in_kb: long
    :ivar created_time: Creation timestamp of the log file.
    :vartype created_time: ~datetime.datetime
    :ivar last_modified_time: Last modified timestamp of the log file.
    :vartype last_modified_time: ~datetime.datetime
    :ivar type_properties_type: Type of the log file.
    :vartype type_properties_type: str
    :ivar url: The url to download the log file from.
    :vartype url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'size_in_kb': {'key': 'properties.sizeInKB', 'type': 'long'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        size_in_kb: Optional[int] = None,
        type_properties_type: Optional[str] = None,
        url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword size_in_kb: Size of the log file.
        :paramtype size_in_kb: long
        :keyword type_properties_type: Type of the log file.
        :paramtype type_properties_type: str
        :keyword url: The url to download the log file from.
        :paramtype url: str
        """
        super(LogFile, self).__init__(**kwargs)
        self.size_in_kb = size_in_kb
        self.created_time = None
        self.last_modified_time = None
        self.type_properties_type = type_properties_type
        self.url = url


class LogFileListResult(msrest.serialization.Model):
    """A list of log files.

    :ivar value: The list of log files.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.LogFile]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LogFile]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.LogFile"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of log files.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.LogFile]
        """
        super(LogFileListResult, self).__init__(**kwargs)
        self.value = value


class NameAvailability(msrest.serialization.Model):
    """Represents a resource name availability.

    :ivar message: Error Message.
    :vartype message: str
    :ivar name_available: Indicates whether the resource name is available.
    :vartype name_available: bool
    :ivar reason: Reason for name being unavailable.
    :vartype reason: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message: Error Message.
        :paramtype message: str
        :keyword name_available: Indicates whether the resource name is available.
        :paramtype name_available: bool
        :keyword reason: Reason for name being unavailable.
        :paramtype reason: str
        """
        super(NameAvailability, self).__init__(**kwargs)
        self.message = message
        self.name_available = name_available
        self.reason = reason


class NameAvailabilityRequest(msrest.serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Resource name to verify.
    :vartype name: str
    :ivar type: Resource type used for verification.
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Resource name to verify.
        :paramtype name: str
        :keyword type: Resource type used for verification.
        :paramtype type: str
        """
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type


class Operation(msrest.serialization.Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.rdbms.postgresql.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Known values are: "NotSpecified", "user",
     "system".
    :vartype origin: str or ~azure.mgmt.rdbms.postgresql.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of resource provider operations.

    :ivar value: The list of resource provider operations.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Operation"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of resource provider operations.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.Operation]
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class PerformanceTierListResult(msrest.serialization.Model):
    """A list of performance tiers.

    :ivar value: The list of performance tiers.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.PerformanceTierProperties]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerformanceTierProperties]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PerformanceTierProperties"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of performance tiers.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.PerformanceTierProperties]
        """
        super(PerformanceTierListResult, self).__init__(**kwargs)
        self.value = value


class PerformanceTierProperties(msrest.serialization.Model):
    """Performance tier properties.

    :ivar id: ID of the performance tier.
    :vartype id: str
    :ivar max_backup_retention_days: Maximum Backup retention in days for the performance tier
     edition.
    :vartype max_backup_retention_days: int
    :ivar min_backup_retention_days: Minimum Backup retention in days for the performance tier
     edition.
    :vartype min_backup_retention_days: int
    :ivar max_storage_mb: Max storage allowed for a server.
    :vartype max_storage_mb: int
    :ivar min_large_storage_mb: Max storage allowed for a server.
    :vartype min_large_storage_mb: int
    :ivar max_large_storage_mb: Max storage allowed for a server.
    :vartype max_large_storage_mb: int
    :ivar min_storage_mb: Max storage allowed for a server.
    :vartype min_storage_mb: int
    :ivar service_level_objectives: Service level objectives associated with the performance tier.
    :vartype service_level_objectives:
     list[~azure.mgmt.rdbms.postgresql.models.PerformanceTierServiceLevelObjectives]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'int'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'int'},
        'max_storage_mb': {'key': 'maxStorageMB', 'type': 'int'},
        'min_large_storage_mb': {'key': 'minLargeStorageMB', 'type': 'int'},
        'max_large_storage_mb': {'key': 'maxLargeStorageMB', 'type': 'int'},
        'min_storage_mb': {'key': 'minStorageMB', 'type': 'int'},
        'service_level_objectives': {'key': 'serviceLevelObjectives', 'type': '[PerformanceTierServiceLevelObjectives]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        max_backup_retention_days: Optional[int] = None,
        min_backup_retention_days: Optional[int] = None,
        max_storage_mb: Optional[int] = None,
        min_large_storage_mb: Optional[int] = None,
        max_large_storage_mb: Optional[int] = None,
        min_storage_mb: Optional[int] = None,
        service_level_objectives: Optional[List["_models.PerformanceTierServiceLevelObjectives"]] = None,
        **kwargs
    ):
        """
        :keyword id: ID of the performance tier.
        :paramtype id: str
        :keyword max_backup_retention_days: Maximum Backup retention in days for the performance tier
         edition.
        :paramtype max_backup_retention_days: int
        :keyword min_backup_retention_days: Minimum Backup retention in days for the performance tier
         edition.
        :paramtype min_backup_retention_days: int
        :keyword max_storage_mb: Max storage allowed for a server.
        :paramtype max_storage_mb: int
        :keyword min_large_storage_mb: Max storage allowed for a server.
        :paramtype min_large_storage_mb: int
        :keyword max_large_storage_mb: Max storage allowed for a server.
        :paramtype max_large_storage_mb: int
        :keyword min_storage_mb: Max storage allowed for a server.
        :paramtype min_storage_mb: int
        :keyword service_level_objectives: Service level objectives associated with the performance
         tier.
        :paramtype service_level_objectives:
         list[~azure.mgmt.rdbms.postgresql.models.PerformanceTierServiceLevelObjectives]
        """
        super(PerformanceTierProperties, self).__init__(**kwargs)
        self.id = id
        self.max_backup_retention_days = max_backup_retention_days
        self.min_backup_retention_days = min_backup_retention_days
        self.max_storage_mb = max_storage_mb
        self.min_large_storage_mb = min_large_storage_mb
        self.max_large_storage_mb = max_large_storage_mb
        self.min_storage_mb = min_storage_mb
        self.service_level_objectives = service_level_objectives


class PerformanceTierServiceLevelObjectives(msrest.serialization.Model):
    """Service level objectives for performance tier.

    :ivar id: ID for the service level objective.
    :vartype id: str
    :ivar edition: Edition of the performance tier.
    :vartype edition: str
    :ivar v_core: vCore associated with the service level objective.
    :vartype v_core: int
    :ivar hardware_generation: Hardware generation associated with the service level objective.
    :vartype hardware_generation: str
    :ivar max_backup_retention_days: Maximum Backup retention in days for the performance tier
     edition.
    :vartype max_backup_retention_days: int
    :ivar min_backup_retention_days: Minimum Backup retention in days for the performance tier
     edition.
    :vartype min_backup_retention_days: int
    :ivar max_storage_mb: Max storage allowed for a server.
    :vartype max_storage_mb: int
    :ivar min_storage_mb: Max storage allowed for a server.
    :vartype min_storage_mb: int
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'edition': {'key': 'edition', 'type': 'str'},
        'v_core': {'key': 'vCore', 'type': 'int'},
        'hardware_generation': {'key': 'hardwareGeneration', 'type': 'str'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'int'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'int'},
        'max_storage_mb': {'key': 'maxStorageMB', 'type': 'int'},
        'min_storage_mb': {'key': 'minStorageMB', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        edition: Optional[str] = None,
        v_core: Optional[int] = None,
        hardware_generation: Optional[str] = None,
        max_backup_retention_days: Optional[int] = None,
        min_backup_retention_days: Optional[int] = None,
        max_storage_mb: Optional[int] = None,
        min_storage_mb: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: ID for the service level objective.
        :paramtype id: str
        :keyword edition: Edition of the performance tier.
        :paramtype edition: str
        :keyword v_core: vCore associated with the service level objective.
        :paramtype v_core: int
        :keyword hardware_generation: Hardware generation associated with the service level objective.
        :paramtype hardware_generation: str
        :keyword max_backup_retention_days: Maximum Backup retention in days for the performance tier
         edition.
        :paramtype max_backup_retention_days: int
        :keyword min_backup_retention_days: Minimum Backup retention in days for the performance tier
         edition.
        :paramtype min_backup_retention_days: int
        :keyword max_storage_mb: Max storage allowed for a server.
        :paramtype max_storage_mb: int
        :keyword min_storage_mb: Max storage allowed for a server.
        :paramtype min_storage_mb: int
        """
        super(PerformanceTierServiceLevelObjectives, self).__init__(**kwargs)
        self.id = id
        self.edition = edition
        self.v_core = v_core
        self.hardware_generation = hardware_generation
        self.max_backup_retention_days = max_backup_retention_days
        self.min_backup_retention_days = min_backup_retention_days
        self.max_storage_mb = max_storage_mb
        self.min_storage_mb = min_storage_mb


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
    :ivar private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection state of the private endpoint
         connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateProperty
        """
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointProperty(msrest.serialization.Model):
    """PrivateEndpointProperty.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource id of the private endpoint.
        :paramtype id: str
        """
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.rdbms.postgresql.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None


class PrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """PrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. The private link service connection status.
    :vartype status: str
    :ivar description: Required. The private link service connection description.
    :vartype description: str
    :ivar actions_required: The actions required for private link service connection.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: str,
        description: str,
        **kwargs
    ):
        """
        :keyword status: Required. The private link service connection status.
        :paramtype status: str
        :keyword description: Required. The private link service connection description.
        :paramtype description: str
        """
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class RecoverableServerResource(ProxyResource):
    """A recoverable server resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar last_available_backup_date_time: The last available backup date time.
    :vartype last_available_backup_date_time: str
    :ivar service_level_objective: The service level objective.
    :vartype service_level_objective: str
    :ivar edition: Edition of the performance tier.
    :vartype edition: str
    :ivar v_core: vCore associated with the service level objective.
    :vartype v_core: int
    :ivar hardware_generation: Hardware generation associated with the service level objective.
    :vartype hardware_generation: str
    :ivar version: The PostgreSQL version.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_available_backup_date_time': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'edition': {'readonly': True},
        'v_core': {'readonly': True},
        'hardware_generation': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_available_backup_date_time': {'key': 'properties.lastAvailableBackupDateTime', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'v_core': {'key': 'properties.vCore', 'type': 'int'},
        'hardware_generation': {'key': 'properties.hardwareGeneration', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RecoverableServerResource, self).__init__(**kwargs)
        self.last_available_backup_date_time = None
        self.service_level_objective = None
        self.edition = None
        self.v_core = None
        self.hardware_generation = None
        self.version = None


class ResourceIdentity(msrest.serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :ivar type: The identity type. Set this to 'SystemAssigned' in order to automatically create
     and assign an Azure Active Directory principal for the resource. Known values are:
     "SystemAssigned".
    :vartype type: str or ~azure.mgmt.rdbms.postgresql.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Set this to 'SystemAssigned' in order to automatically create
         and assign an Azure Active Directory principal for the resource. Known values are:
         "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.rdbms.postgresql.models.IdentityType
        """
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.type = type
        self.tenant_id = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: The Azure Active Directory identity of the server.
    :vartype identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :ivar sku: The SKU (pricing tier) of the server.
    :vartype sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :ivar administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :vartype administrator_login: str
    :ivar version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
    :vartype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :ivar ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values are:
     "Enabled", "Disabled".
    :vartype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :ivar minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
     "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :vartype minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar byok_enforcement: Status showing whether the server data encryption is enabled with
     customer-managed keys.
    :vartype byok_enforcement: str
    :ivar infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Known values are: "Enabled", "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :ivar user_visible_state: A state of a server that is visible to user. Known values are:
     "Ready", "Dropping", "Disabled", "Inaccessible".
    :vartype user_visible_state: str or ~azure.mgmt.rdbms.postgresql.models.ServerState
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :ivar earliest_restore_date: Earliest restore point creation time (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar storage_profile: Storage profile of a server.
    :vartype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :ivar replication_role: The replication role of the server.
    :vartype replication_role: str
    :ivar master_server_id: The master server id of a replica server.
    :vartype master_server_id: str
    :ivar replica_capacity: The maximum number of replicas that a master server can have.
    :vartype replica_capacity: int
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar private_endpoint_connections: List of private endpoint connections on a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.rdbms.postgresql.models.ServerPrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'byok_enforcement': {'readonly': True},
        'replica_capacity': {'minimum': 0},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'byok_enforcement': {'key': 'properties.byokEnforcement', 'type': 'str'},
        'infrastructure_encryption': {'key': 'properties.infrastructureEncryption', 'type': 'str'},
        'user_visible_state': {'key': 'properties.userVisibleState', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'master_server_id': {'key': 'properties.masterServerId', 'type': 'str'},
        'replica_capacity': {'key': 'properties.replicaCapacity', 'type': 'int'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        administrator_login: Optional[str] = None,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "_models.SslEnforcementEnum"]] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersionEnum"]] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryption"]] = None,
        user_visible_state: Optional[Union[str, "_models.ServerState"]] = None,
        fully_qualified_domain_name: Optional[str] = None,
        earliest_restore_date: Optional[datetime.datetime] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        replication_role: Optional[str] = None,
        master_server_id: Optional[str] = None,
        replica_capacity: Optional[int] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessEnum"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: The Azure Active Directory identity of the server.
        :paramtype identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
        :keyword sku: The SKU (pricing tier) of the server.
        :paramtype sku: ~azure.mgmt.rdbms.postgresql.models.Sku
        :keyword administrator_login: The administrator's login name of a server. Can only be specified
         when the server is being created (and is required for creation).
        :paramtype administrator_login: str
        :keyword version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
        :paramtype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
        :keyword ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values
         are: "Enabled", "Disabled".
        :paramtype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
        :keyword minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
         "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
        :paramtype minimal_tls_version: str or
         ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
        :keyword infrastructure_encryption: Status showing whether the server enabled infrastructure
         encryption. Known values are: "Enabled", "Disabled".
        :paramtype infrastructure_encryption: str or
         ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
        :keyword user_visible_state: A state of a server that is visible to user. Known values are:
         "Ready", "Dropping", "Disabled", "Inaccessible".
        :paramtype user_visible_state: str or ~azure.mgmt.rdbms.postgresql.models.ServerState
        :keyword fully_qualified_domain_name: The fully qualified domain name of a server.
        :paramtype fully_qualified_domain_name: str
        :keyword earliest_restore_date: Earliest restore point creation time (ISO8601 format).
        :paramtype earliest_restore_date: ~datetime.datetime
        :keyword storage_profile: Storage profile of a server.
        :paramtype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
        :keyword replication_role: The replication role of the server.
        :paramtype replication_role: str
        :keyword master_server_id: The master server id of a replica server.
        :paramtype master_server_id: str
        :keyword replica_capacity: The maximum number of replicas that a master server can have.
        :paramtype replica_capacity: int
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
        """
        super(Server, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.administrator_login = administrator_login
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.minimal_tls_version = minimal_tls_version
        self.byok_enforcement = None
        self.infrastructure_encryption = infrastructure_encryption
        self.user_visible_state = user_visible_state
        self.fully_qualified_domain_name = fully_qualified_domain_name
        self.earliest_restore_date = earliest_restore_date
        self.storage_profile = storage_profile
        self.replication_role = replication_role
        self.master_server_id = master_server_id
        self.replica_capacity = replica_capacity
        self.public_network_access = public_network_access
        self.private_endpoint_connections = None


class ServerAdministratorResource(ProxyResource):
    """Represents a and external administrator to be created.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar administrator_type: The type of administrator. The only acceptable values to pass in are
     None and "ActiveDirectory". The default value is None.
    :vartype administrator_type: str
    :ivar login: The server administrator login account name.
    :vartype login: str
    :ivar sid: The server administrator Sid (Secure ID).
    :vartype sid: str
    :ivar tenant_id: The server Active Directory Administrator tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[str] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword administrator_type: The type of administrator. The only acceptable values to pass in
         are None and "ActiveDirectory". The default value is None.
        :paramtype administrator_type: str
        :keyword login: The server administrator login account name.
        :paramtype login: str
        :keyword sid: The server administrator Sid (Secure ID).
        :paramtype sid: str
        :keyword tenant_id: The server Active Directory Administrator tenant id.
        :paramtype tenant_id: str
        """
        super(ServerAdministratorResource, self).__init__(**kwargs)
        self.administrator_type = administrator_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id


class ServerAdministratorResourceListResult(msrest.serialization.Model):
    """The response to a list Active Directory Administrators request.

    :ivar value: The list of server Active Directory Administrators for the server.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.ServerAdministratorResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerAdministratorResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ServerAdministratorResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of server Active Directory Administrators for the server.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.ServerAdministratorResource]
        """
        super(ServerAdministratorResourceListResult, self).__init__(**kwargs)
        self.value = value


class ServerForCreate(msrest.serialization.Model):
    """Represents a server to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar identity: The Azure Active Directory identity of the server.
    :vartype identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :ivar sku: The SKU (pricing tier) of the server.
    :vartype sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :ivar properties: Required. Properties of the server.
    :vartype properties: ~azure.mgmt.rdbms.postgresql.models.ServerPropertiesForCreate
    :ivar location: Required. The location the resource resides in.
    :vartype location: str
    :ivar tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'properties': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'properties': {'key': 'properties', 'type': 'ServerPropertiesForCreate'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        properties: "_models.ServerPropertiesForCreate",
        location: str,
        identity: Optional["_models.ResourceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword identity: The Azure Active Directory identity of the server.
        :paramtype identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
        :keyword sku: The SKU (pricing tier) of the server.
        :paramtype sku: ~azure.mgmt.rdbms.postgresql.models.Sku
        :keyword properties: Required. Properties of the server.
        :paramtype properties: ~azure.mgmt.rdbms.postgresql.models.ServerPropertiesForCreate
        :keyword location: Required. The location the resource resides in.
        :paramtype location: str
        :keyword tags: A set of tags. Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super(ServerForCreate, self).__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.properties = properties
        self.location = location
        self.tags = tags


class ServerKey(ProxyResource):
    """A PostgreSQL Server key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Kind of encryption protector used to protect the key.
    :vartype kind: str
    :ivar server_key_type: The key type like 'AzureKeyVault'. Known values are: "AzureKeyVault".
    :vartype server_key_type: str or ~azure.mgmt.rdbms.postgresql.models.ServerKeyType
    :ivar uri: The URI of the key.
    :vartype uri: str
    :ivar creation_date: The key creation date.
    :vartype creation_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'creation_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        server_key_type: Optional[Union[str, "_models.ServerKeyType"]] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword server_key_type: The key type like 'AzureKeyVault'. Known values are: "AzureKeyVault".
        :paramtype server_key_type: str or ~azure.mgmt.rdbms.postgresql.models.ServerKeyType
        :keyword uri: The URI of the key.
        :paramtype uri: str
        """
        super(ServerKey, self).__init__(**kwargs)
        self.kind = None
        self.server_key_type = server_key_type
        self.uri = uri
        self.creation_date = None


class ServerKeyListResult(msrest.serialization.Model):
    """A list of PostgreSQL Server keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of PostgreSQL Server keys.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.ServerKey]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerKey]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ServerKeyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    :ivar value: The list of servers.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.Server]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Server"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of servers.
        :paramtype value: list[~azure.mgmt.rdbms.postgresql.models.Server]
        """
        super(ServerListResult, self).__init__(**kwargs)
        self.value = value


class ServerPrivateEndpointConnection(msrest.serialization.Model):
    """A private endpoint connection under a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the Private Endpoint Connection.
    :vartype id: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties:
     ~azure.mgmt.rdbms.postgresql.models.ServerPrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ServerPrivateEndpointConnectionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ServerPrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.properties = None


class ServerPrivateEndpointConnectionProperties(msrest.serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
    :ivar private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.rdbms.postgresql.models.ServerPrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection. Known values are:
     "Approving", "Ready", "Dropping", "Failed", "Rejecting".
    :vartype provisioning_state: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'ServerPrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["_models.ServerPrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection state of the private endpoint
         connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.rdbms.postgresql.models.ServerPrivateLinkServiceConnectionStateProperty
        """
        super(ServerPrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class ServerPrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """ServerPrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. The private link service connection status. Known values are:
     "Approved", "Pending", "Rejected", "Disconnected".
    :vartype status: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateStatus
    :ivar description: Required. The private link service connection description.
    :vartype description: str
    :ivar actions_required: The actions required for private link service connection. Known values
     are: "None".
    :vartype actions_required: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateActionsRequire
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStateStatus"],
        description: str,
        **kwargs
    ):
        """
        :keyword status: Required. The private link service connection status. Known values are:
         "Approved", "Pending", "Rejected", "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateStatus
        :keyword description: Required. The private link service connection description.
        :paramtype description: str
        """
        super(ServerPrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ServerPropertiesForCreate(msrest.serialization.Model):
    """The properties used to create a new server.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServerPropertiesForDefaultCreate, ServerPropertiesForGeoRestore, ServerPropertiesForRestore, ServerPropertiesForReplica.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
    :vartype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :ivar ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values are:
     "Enabled", "Disabled".
    :vartype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :ivar minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
     "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :vartype minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Known values are: "Enabled", "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar storage_profile: Storage profile of a server.
    :vartype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :ivar create_mode: Required. The mode to create a new server.Constant filled by server. Known
     values are: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :vartype create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    """

    _validation = {
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
    }

    _subtype_map = {
        'create_mode': {'Default': 'ServerPropertiesForDefaultCreate', 'GeoRestore': 'ServerPropertiesForGeoRestore', 'PointInTimeRestore': 'ServerPropertiesForRestore', 'Replica': 'ServerPropertiesForReplica'}
    }

    def __init__(
        self,
        *,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "_models.SslEnforcementEnum"]] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersionEnum"]] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryption"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
        :paramtype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
        :keyword ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values
         are: "Enabled", "Disabled".
        :paramtype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
        :keyword minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
         "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
        :paramtype minimal_tls_version: str or
         ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
        :keyword infrastructure_encryption: Status showing whether the server enabled infrastructure
         encryption. Known values are: "Enabled", "Disabled".
        :paramtype infrastructure_encryption: str or
         ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
        :keyword storage_profile: Storage profile of a server.
        :paramtype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
        """
        super(ServerPropertiesForCreate, self).__init__(**kwargs)
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.minimal_tls_version = minimal_tls_version
        self.infrastructure_encryption = infrastructure_encryption
        self.public_network_access = public_network_access
        self.storage_profile = storage_profile
        self.create_mode = None  # type: Optional[str]


class ServerPropertiesForDefaultCreate(ServerPropertiesForCreate):
    """The properties used to create a new server.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
    :vartype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :ivar ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values are:
     "Enabled", "Disabled".
    :vartype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :ivar minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
     "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :vartype minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Known values are: "Enabled", "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar storage_profile: Storage profile of a server.
    :vartype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :ivar create_mode: Required. The mode to create a new server.Constant filled by server. Known
     values are: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :vartype create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :ivar administrator_login: Required. The administrator's login name of a server. Can only be
     specified when the server is being created (and is required for creation).
    :vartype administrator_login: str
    :ivar administrator_login_password: Required. The password of the administrator login.
    :vartype administrator_login_password: str
    """

    _validation = {
        'create_mode': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        administrator_login: str,
        administrator_login_password: str,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "_models.SslEnforcementEnum"]] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersionEnum"]] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryption"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
        :paramtype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
        :keyword ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values
         are: "Enabled", "Disabled".
        :paramtype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
        :keyword minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
         "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
        :paramtype minimal_tls_version: str or
         ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
        :keyword infrastructure_encryption: Status showing whether the server enabled infrastructure
         encryption. Known values are: "Enabled", "Disabled".
        :paramtype infrastructure_encryption: str or
         ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
        :keyword storage_profile: Storage profile of a server.
        :paramtype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
        :keyword administrator_login: Required. The administrator's login name of a server. Can only be
         specified when the server is being created (and is required for creation).
        :paramtype administrator_login: str
        :keyword administrator_login_password: Required. The password of the administrator login.
        :paramtype administrator_login_password: str
        """
        super(ServerPropertiesForDefaultCreate, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'Default'  # type: str
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password


class ServerPropertiesForGeoRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring to a different region from a geo replicated backup.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
    :vartype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :ivar ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values are:
     "Enabled", "Disabled".
    :vartype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :ivar minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
     "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :vartype minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Known values are: "Enabled", "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar storage_profile: Storage profile of a server.
    :vartype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :ivar create_mode: Required. The mode to create a new server.Constant filled by server. Known
     values are: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :vartype create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :ivar source_server_id: Required. The source server id to restore from.
    :vartype source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_server_id: str,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "_models.SslEnforcementEnum"]] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersionEnum"]] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryption"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
        :paramtype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
        :keyword ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values
         are: "Enabled", "Disabled".
        :paramtype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
        :keyword minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
         "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
        :paramtype minimal_tls_version: str or
         ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
        :keyword infrastructure_encryption: Status showing whether the server enabled infrastructure
         encryption. Known values are: "Enabled", "Disabled".
        :paramtype infrastructure_encryption: str or
         ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
        :keyword storage_profile: Storage profile of a server.
        :paramtype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
        :keyword source_server_id: Required. The source server id to restore from.
        :paramtype source_server_id: str
        """
        super(ServerPropertiesForGeoRestore, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'GeoRestore'  # type: str
        self.source_server_id = source_server_id


class ServerPropertiesForReplica(ServerPropertiesForCreate):
    """The properties to create a new replica.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
    :vartype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :ivar ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values are:
     "Enabled", "Disabled".
    :vartype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :ivar minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
     "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :vartype minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Known values are: "Enabled", "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar storage_profile: Storage profile of a server.
    :vartype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :ivar create_mode: Required. The mode to create a new server.Constant filled by server. Known
     values are: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :vartype create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :ivar source_server_id: Required. The master server id to create replica from.
    :vartype source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_server_id: str,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "_models.SslEnforcementEnum"]] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersionEnum"]] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryption"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
        :paramtype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
        :keyword ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values
         are: "Enabled", "Disabled".
        :paramtype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
        :keyword minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
         "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
        :paramtype minimal_tls_version: str or
         ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
        :keyword infrastructure_encryption: Status showing whether the server enabled infrastructure
         encryption. Known values are: "Enabled", "Disabled".
        :paramtype infrastructure_encryption: str or
         ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
        :keyword storage_profile: Storage profile of a server.
        :paramtype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
        :keyword source_server_id: Required. The master server id to create replica from.
        :paramtype source_server_id: str
        """
        super(ServerPropertiesForReplica, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'Replica'  # type: str
        self.source_server_id = source_server_id


class ServerPropertiesForRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring from a backup.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
    :vartype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :ivar ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values are:
     "Enabled", "Disabled".
    :vartype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :ivar minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
     "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :vartype minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar infrastructure_encryption: Status showing whether the server enabled infrastructure
     encryption. Known values are: "Enabled", "Disabled".
    :vartype infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar storage_profile: Storage profile of a server.
    :vartype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :ivar create_mode: Required. The mode to create a new server.Constant filled by server. Known
     values are: "Default", "PointInTimeRestore", "GeoRestore", "Replica".
    :vartype create_mode: str or ~azure.mgmt.rdbms.postgresql.models.CreateMode
    :ivar source_server_id: Required. The source server id to restore from.
    :vartype source_server_id: str
    :ivar restore_point_in_time: Required. Restore point creation time (ISO8601 format), specifying
     the time to restore from.
    :vartype restore_point_in_time: ~datetime.datetime
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
        'restore_point_in_time': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
        'restore_point_in_time': {'key': 'restorePointInTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        source_server_id: str,
        restore_point_in_time: datetime.datetime,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "_models.SslEnforcementEnum"]] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersionEnum"]] = None,
        infrastructure_encryption: Optional[Union[str, "_models.InfrastructureEncryption"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessEnum"]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword version: Server version. Known values are: "9.5", "9.6", "10", "10.0", "10.2", "11".
        :paramtype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
        :keyword ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values
         are: "Enabled", "Disabled".
        :paramtype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
        :keyword minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
         "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
        :paramtype minimal_tls_version: str or
         ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
        :keyword infrastructure_encryption: Status showing whether the server enabled infrastructure
         encryption. Known values are: "Enabled", "Disabled".
        :paramtype infrastructure_encryption: str or
         ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
        :keyword storage_profile: Storage profile of a server.
        :paramtype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
        :keyword source_server_id: Required. The source server id to restore from.
        :paramtype source_server_id: str
        :keyword restore_point_in_time: Required. Restore point creation time (ISO8601 format),
         specifying the time to restore from.
        :paramtype restore_point_in_time: ~datetime.datetime
        """
        super(ServerPropertiesForRestore, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.create_mode = 'PointInTimeRestore'  # type: str
        self.source_server_id = source_server_id
        self.restore_point_in_time = restore_point_in_time


class ServerSecurityAlertPolicy(ProxyResource):
    """A server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar state: Specifies the state of the policy, whether it is enabled or disabled. Known values
     are: "Enabled", "Disabled".
    :vartype state: str or ~azure.mgmt.rdbms.postgresql.models.ServerSecurityAlertPolicyState
    :ivar disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly.
    :vartype disabled_alerts: list[str]
    :ivar email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :vartype email_addresses: list[str]
    :ivar email_account_admins: Specifies that the alert is sent to the account administrators.
    :vartype email_account_admins: bool
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :vartype storage_account_access_key: str
    :ivar retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :vartype retention_days: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.ServerSecurityAlertPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword state: Specifies the state of the policy, whether it is enabled or disabled. Known
         values are: "Enabled", "Disabled".
        :paramtype state: str or ~azure.mgmt.rdbms.postgresql.models.ServerSecurityAlertPolicyState
        :keyword disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
         Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly.
        :paramtype disabled_alerts: list[str]
        :keyword email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
        :paramtype email_addresses: list[str]
        :keyword email_account_admins: Specifies that the alert is sent to the account administrators.
        :paramtype email_account_admins: bool
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
         audit logs.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the Threat Detection audit
         storage account.
        :paramtype storage_account_access_key: str
        :keyword retention_days: Specifies the number of days to keep in the Threat Detection audit
         logs.
        :paramtype retention_days: int
        """
        super(ServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days


class ServerSecurityAlertPolicyListResult(msrest.serialization.Model):
    """A list of the server's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.ServerSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ServerSecurityAlertPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerUpdateParameters(msrest.serialization.Model):
    """Parameters allowed to update for a server.

    :ivar identity: The Azure Active Directory identity of the server.
    :vartype identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :ivar sku: The SKU (pricing tier) of the server.
    :vartype sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :ivar tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar storage_profile: Storage profile of a server.
    :vartype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :ivar administrator_login_password: The password of the administrator login.
    :vartype administrator_login_password: str
    :ivar version: The version of a server. Known values are: "9.5", "9.6", "10", "10.0", "10.2",
     "11".
    :vartype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :ivar ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values are:
     "Enabled", "Disabled".
    :vartype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :ivar minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
     "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
    :vartype minimal_tls_version: str or ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar replication_role: The replication role of the server.
    :vartype replication_role: str
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'str'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ResourceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        ssl_enforcement: Optional[Union[str, "_models.SslEnforcementEnum"]] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersionEnum"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessEnum"]] = None,
        replication_role: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword identity: The Azure Active Directory identity of the server.
        :paramtype identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
        :keyword sku: The SKU (pricing tier) of the server.
        :paramtype sku: ~azure.mgmt.rdbms.postgresql.models.Sku
        :keyword tags: A set of tags. Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword storage_profile: Storage profile of a server.
        :paramtype storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
        :keyword administrator_login_password: The password of the administrator login.
        :paramtype administrator_login_password: str
        :keyword version: The version of a server. Known values are: "9.5", "9.6", "10", "10.0",
         "10.2", "11".
        :paramtype version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
        :keyword ssl_enforcement: Enable ssl enforcement or not when connect to server. Known values
         are: "Enabled", "Disabled".
        :paramtype ssl_enforcement: str or ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
        :keyword minimal_tls_version: Enforce a minimal Tls version for the server. Known values are:
         "TLS1_0", "TLS1_1", "TLS1_2", "TLSEnforcementDisabled".
        :paramtype minimal_tls_version: str or
         ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
        :keyword replication_role: The replication role of the server.
        :paramtype replication_role: str
        """
        super(ServerUpdateParameters, self).__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.tags = tags
        self.storage_profile = storage_profile
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.minimal_tls_version = minimal_tls_version
        self.public_network_access = public_network_access
        self.replication_role = replication_role


class Sku(msrest.serialization.Model):
    """Billing information related properties of a server.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1,
     GP_Gen5_8.
    :vartype name: str
    :ivar tier: The tier of the particular SKU, e.g. Basic. Known values are: "Basic",
     "GeneralPurpose", "MemoryOptimized".
    :vartype tier: str or ~azure.mgmt.rdbms.postgresql.models.SkuTier
    :ivar capacity: The scale up/out capacity, representing server's compute units.
    :vartype capacity: int
    :ivar size: The size code, to be interpreted by resource as appropriate.
    :vartype size: str
    :ivar family: The family of hardware.
    :vartype family: str
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        capacity: Optional[int] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1,
         GP_Gen5_8.
        :paramtype name: str
        :keyword tier: The tier of the particular SKU, e.g. Basic. Known values are: "Basic",
         "GeneralPurpose", "MemoryOptimized".
        :paramtype tier: str or ~azure.mgmt.rdbms.postgresql.models.SkuTier
        :keyword capacity: The scale up/out capacity, representing server's compute units.
        :paramtype capacity: int
        :keyword size: The size code, to be interpreted by resource as appropriate.
        :paramtype size: str
        :keyword family: The family of hardware.
        :paramtype family: str
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity
        self.size = size
        self.family = family


class StorageProfile(msrest.serialization.Model):
    """Storage Profile properties of a server.

    :ivar backup_retention_days: Backup retention days for the server.
    :vartype backup_retention_days: int
    :ivar geo_redundant_backup: Enable Geo-redundant or not for server backup. Known values are:
     "Enabled", "Disabled".
    :vartype geo_redundant_backup: str or ~azure.mgmt.rdbms.postgresql.models.GeoRedundantBackup
    :ivar storage_mb: Max storage allowed for a server.
    :vartype storage_mb: int
    :ivar storage_autogrow: Enable Storage Auto Grow. Known values are: "Enabled", "Disabled".
    :vartype storage_autogrow: str or ~azure.mgmt.rdbms.postgresql.models.StorageAutogrow
    """

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'geo_redundant_backup': {'key': 'geoRedundantBackup', 'type': 'str'},
        'storage_mb': {'key': 'storageMB', 'type': 'int'},
        'storage_autogrow': {'key': 'storageAutogrow', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        backup_retention_days: Optional[int] = None,
        geo_redundant_backup: Optional[Union[str, "_models.GeoRedundantBackup"]] = None,
        storage_mb: Optional[int] = None,
        storage_autogrow: Optional[Union[str, "_models.StorageAutogrow"]] = None,
        **kwargs
    ):
        """
        :keyword backup_retention_days: Backup retention days for the server.
        :paramtype backup_retention_days: int
        :keyword geo_redundant_backup: Enable Geo-redundant or not for server backup. Known values are:
         "Enabled", "Disabled".
        :paramtype geo_redundant_backup: str or ~azure.mgmt.rdbms.postgresql.models.GeoRedundantBackup
        :keyword storage_mb: Max storage allowed for a server.
        :paramtype storage_mb: int
        :keyword storage_autogrow: Enable Storage Auto Grow. Known values are: "Enabled", "Disabled".
        :paramtype storage_autogrow: str or ~azure.mgmt.rdbms.postgresql.models.StorageAutogrow
        """
        super(StorageProfile, self).__init__(**kwargs)
        self.backup_retention_days = backup_retention_days
        self.geo_redundant_backup = geo_redundant_backup
        self.storage_mb = storage_mb
        self.storage_autogrow = storage_autogrow


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class VirtualNetworkRule(ProxyResource):
    """A virtual network rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar virtual_network_subnet_id: The ARM resource id of the virtual network subnet.
    :vartype virtual_network_subnet_id: str
    :ivar ignore_missing_vnet_service_endpoint: Create firewall rule before the virtual network has
     vnet service endpoint enabled.
    :vartype ignore_missing_vnet_service_endpoint: bool
    :ivar state: Virtual Network Rule State. Known values are: "Initializing", "InProgress",
     "Ready", "Deleting", "Unknown".
    :vartype state: str or ~azure.mgmt.rdbms.postgresql.models.VirtualNetworkRuleState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'properties.ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_subnet_id: Optional[str] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword virtual_network_subnet_id: The ARM resource id of the virtual network subnet.
        :paramtype virtual_network_subnet_id: str
        :keyword ignore_missing_vnet_service_endpoint: Create firewall rule before the virtual network
         has vnet service endpoint enabled.
        :paramtype ignore_missing_vnet_service_endpoint: bool
        """
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_subnet_id = virtual_network_subnet_id
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint
        self.state = None


class VirtualNetworkRuleListResult(msrest.serialization.Model):
    """A list of virtual network rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.rdbms.postgresql.models.VirtualNetworkRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(VirtualNetworkRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
