% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{is.Date}
\alias{is.Date}
\title{Test if object is a \code{Date} object}
\usage{
is.Date(obj)
}
\arguments{
\item{obj}{object to test on}
}
\description{
Tests if an object is a \code{Date} object and returns
a logical vector of length 1. \code{IDate} objects are also 
\code{Date} objects, but \code{date} objects from package \pkg{date}
are not.
}
\examples{
## the base "capital Date" format
da <- as.Date("2000-01-01")
is.Date(da) ## TRUE
date::is.date(da) ## FALSE

## IDate format from data.table
library("data.table")
da <- as.IDate("2000-01-01")
is.Date(da) ## TRUE
date::is.date(da) ## FALSE

## from package "date"
da <- date::as.date("1jan2000")
is.Date(da) ## FALSE
date::is.date(da) ## TRUE
 
}
\seealso{
\code{\link{get.yrs}}, \code{\link{is_leap_year}}, \code{\link{as.Date}}
}
\author{
Joonas Miettinen
}
