% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGEMatrix.R
\name{compareSingleCellsAgainstBulk}
\alias{compareSingleCellsAgainstBulk}
\title{Compare gene expression between single cell sample and bulk}
\usage{
compareSingleCellsAgainstBulk(single.cells, bulk.data, method = "pearson",
  ylab = "single cell sample", col = "steelblue", ...)
}
\arguments{
\item{single.cells}{A \code{data.frame} containing genes as rownames and columns as cells.}

\item{bulk.data}{A \code{data.frame} containing genes as rownames and a single column
with transcript counts.}

\item{ylab}{Label of the single cell sample.}

\item{col}{The color of the scatterplot points.}

\item{log.space}{If True (default value) then the average of single cells data is
performed in log space.}
}
\value{
A scatterplot comparing the gene expression levels and with the correlation
among the samples computed.
}
\description{
Compares the gene expression measurements from single cell data against bulk data.
}
