/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Surf Box Fold v2
 * based on DarkBeam's code "Mixed fold by Luca 2016".
 * @reference
 * http:// http://www.fractalforums.com/amazing-box-amazing-surf-and-variations/
 * httpwww-shaperich-comproshred-elite-review
 * This formula contains aux.color,

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfSurfBoxFoldV2Iteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSurfBoxFoldV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(aux);

	REAL colorAdd = 0.0f;
	REAL4 oldZ = z;
	REAL4 foldMod = fractal->transformCommon.offset222;
	REAL4 fold = fractal->transformCommon.additionConstant111;
	REAL4 sg = z;
	sg.x = sign(z.x);
	sg.y = sign(z.y);
	sg.z = sign(z.z);

	REAL4 folder = z;
	REAL4 Tglad = z;

	Tglad.x = fabs(z.x + fold.x) - fabs(z.x - fold.x) - z.x;
	Tglad.y = fabs(z.y + fold.y) - fabs(z.y - fold.y) - z.y;

	folder.x = sg.x * (z.x - Tglad.x);
	folder.y = sg.y * (z.y - Tglad.y);
	folder.x = fabs(folder.x);
	folder.y = fabs(folder.y);
	folder.x = min(folder.x, foldMod.x);
	folder.y = min(folder.y, foldMod.y);
	z.x -= sg.x * folder.x;
	z.y -= sg.y * folder.y;

	if (fractal->transformCommon.functionEnabled)
	{
		Tglad.z = fabs(z.z + fold.z) - fabs(z.z - fold.z) - z.z;
		folder.z = sg.z * (z.z - Tglad.z);
		folder.z = fabs(folder.z);
		folder.z = min(folder.z, foldMod.z);
		z.z -= sg.z * folder.z;
	}

	// analyic DE tweak
	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = mad(aux->DE, fractal->analyticDE.scale1, fractal->analyticDE.offset0);
	}
	// color
	if (fractal->foldColor.auxColorEnabledFalse)
	{
		REAL4 zCol = z;
		if (fractal->transformCommon.functionEnabledCxFalse)
		{
			if (zCol.x != oldZ.x)
				colorAdd += fractal->mandelbox.color.factor.x
										* (fabs(zCol.x) - fractal->transformCommon.additionConstant111.x);
			if (zCol.y != oldZ.y)
				colorAdd += fractal->mandelbox.color.factor.y
										* (fabs(zCol.y) - fractal->transformCommon.additionConstant111.y);
			if (zCol.z != oldZ.z)
				colorAdd += fractal->mandelbox.color.factor.z
										* (fabs(zCol.z) - fractal->transformCommon.additionConstant111.z);
		}
		else
		{
			if (zCol.x != oldZ.x) colorAdd += fractal->mandelbox.color.factor.x;
			if (zCol.y != oldZ.y) colorAdd += fractal->mandelbox.color.factor.y;
			if (zCol.z != oldZ.z) colorAdd += fractal->mandelbox.color.factor.z;
		}
		aux->color += colorAdd;
	}
	return z;
}