/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1),	/* CORE_VID0 */
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1),	/* CORE_VID1 */
	PAD_CFG_NF(GPP_B2, NONE, PLTRST, NF1),	/* VRALERT# */
	PAD_NC(GPP_B3, NONE),
	PAD_NC(GPP_B4, NONE),
	PAD_NC(GPP_B5, NONE),
	PAD_NC(GPP_B6, NONE),
	PAD_NC(GPP_B7, NONE),
	PAD_NC(GPP_B8, NONE),
	PAD_NC(GPP_B9, NONE),
	PAD_NC(GPP_B10, NONE),
	PAD_CFG_NF(GPP_B11, NONE, RSMRST, NF1),	/* PMCALERT# */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),	/* SLP_S0# */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),	/* PLTRST# */
	PAD_CFG_NF(GPP_B14, NONE, PLTRST, NF1),	/* SPKR */
	PAD_NC(GPP_B15, NONE),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_CFG_GPO(GPP_B18, 0, DEEP),
	PAD_NC(GPP_B19, NONE),
	PAD_NC(GPP_B20, NONE),
	PAD_NC(GPP_B21, NONE),
	PAD_NC(GPP_B22, NONE),
	PAD_CFG_GPO(GPP_B23, 0, DEEP),
	PAD_CFG_NF(GPP_B24, NONE, DEEP, NF1),	/* GSPI0_CLK_LOOPBK */
	PAD_CFG_NF(GPP_B25, NONE, DEEP, NF1),	/* GSPI1_CLK_LOOPBK */

	/* ------- GPIO Group GPP_T ------- */
	PAD_NC(GPP_T0, NONE),
	PAD_NC(GPP_T1, NONE),
	PAD_CFG_NF(GPP_T2, DN_20K, DEEP, NF2),	/* FUSA_DIAGTEST_EN */
	PAD_CFG_NF(GPP_T3, DN_20K, DEEP, NF2),	/* FUSA_DIAGTEST_MODE */
	PAD_NC(GPP_T4, NONE),
	PAD_NC(GPP_T5, NONE),
	PAD_NC(GPP_T6, NONE),
	PAD_NC(GPP_T7, NONE),
	PAD_NC(GPP_T8, NONE),
	PAD_NC(GPP_T9, NONE),
	PAD_NC(GPP_T10, NONE),
	PAD_NC(GPP_T11, NONE),
	PAD_NC(GPP_T12, NONE),
	PAD_NC(GPP_T13, NONE),
	PAD_NC(GPP_T14, NONE),
	PAD_NC(GPP_T15, NONE),

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1),	/* ESPI_IO0 */
	PAD_CFG_NF(GPP_A1, NONE, DEEP, NF1),	/* ESPI_IO1 */
	PAD_CFG_NF(GPP_A2, NONE, DEEP, NF1),	/* ESPI_IO2 */
	PAD_CFG_NF(GPP_A3, NONE, DEEP, NF1),	/* ESPI_IO3 */
	PAD_CFG_NF(GPP_A4, NONE, DEEP, NF1),	/* ESPI_CS0# */
	PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1),	/* ESPI_ALERT0# */
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1),	/* ESPI_ALERT1# */
	PAD_NC(GPP_A7, NONE),
	PAD_NC(GPP_A8, NONE),
	PAD_CFG_NF(GPP_A9, NONE, DEEP, NF1),	/* ESPI_CLK */
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1),	/* ESPI_RESET# */
	PAD_NC(GPP_A11, NONE),
	PAD_CFG_NF(GPP_A12, UP_20K, DEEP, NF1),	/* SATAXPCIE1 */
	PAD_CFG_GPO(GPP_A13, 1, PLTRST),
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1),	/* USB_OC1# */
	PAD_CFG_NF(GPP_A15, NONE, DEEP, NF1),	/* USB_OC2# */
	PAD_CFG_NF(GPP_A16, NONE, DEEP, NF1),	/* USB_OC3# */
	PAD_NC(GPP_A17, NONE),
	PAD_CFG_NF(GPP_A18, NONE, DEEP, NF1),	/* DDSP_HPDB */
	PAD_CFG_NF(GPP_A19, NONE, DEEP, NF1),	/* DDSP_HPD1 */
	PAD_NC(GPP_A20, NONE),
	PAD_CFG_GPO(GPP_A21, 1, PLTRST),
	PAD_CFG_NF(GPP_A22, NONE, DEEP, NF1),	/* DDPC_CTRLDATA */
	PAD_CFG_NF(GPP_A23, UP_20K, DEEP, NF1),	/* ESPI_CS1# */
	PAD_CFG_NF(GPP_ESPI_CLK_LOOPBK, NONE, DEEP, NF1),	/* GPP_ESPI_CLK_LOOPBK */

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),
	PAD_NC(GPP_S1, NONE),
	PAD_NC(GPP_S2, NONE),
	PAD_NC(GPP_S3, NONE),
	PAD_NC(GPP_S4, NONE),
	PAD_NC(GPP_S5, NONE),
	PAD_NC(GPP_S6, NONE),
	PAD_NC(GPP_S7, NONE),

	/* ------- GPIO Group GPP_I ------- */
	PAD_NC(GPP_I0, NONE),
	PAD_NC(GPP_I1, NONE),
	PAD_NC(GPP_I2, NONE),
	PAD_NC(GPP_I3, NONE),
	PAD_NC(GPP_I4, NONE),
	PAD_NC(GPP_I5, NONE),
	PAD_NC(GPP_I6, NONE),
	PAD_NC(GPP_I7, NONE),
	PAD_NC(GPP_I8, NONE),
	PAD_NC(GPP_I9, NONE),
	PAD_NC(GPP_I10, NONE),
	PAD_NC(GPP_I11, NONE),
	PAD_NC(GPP_I12, NONE),
	PAD_NC(GPP_I13, NONE),
	PAD_NC(GPP_I14, NONE),
	PAD_NC(GPP_I15, NONE),
	PAD_NC(GPP_I16, NONE),
	PAD_NC(GPP_I17, NONE),
	PAD_NC(GPP_I18, NONE),
	PAD_NC(GPP_I19, NONE),

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_GPO(GPP_H0, 0, DEEP),
	PAD_CFG_GPO(GPP_H1, 0, DEEP),
	PAD_CFG_GPO(GPP_H2, 0, DEEP),
	PAD_CFG_GPO(GPP_H3, 1, PLTRST),
	PAD_NC(GPP_H4, NONE),
	PAD_NC(GPP_H5, NONE),
	PAD_NC(GPP_H6, NONE),
	PAD_NC(GPP_H7, NONE),
	PAD_NC(GPP_H8, NONE),
	PAD_NC(GPP_H9, NONE),
	PAD_NC(GPP_H10, NONE),
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF1),	/* n/a */
	PAD_NC(GPP_H12, NONE),
	PAD_NC(GPP_H13, NONE),
	PAD_NC(GPP_H14, NONE),
	PAD_CFG_NF(GPP_H15, NONE, DEEP, NF1),	/* DDPB_CTRLCLK */
	PAD_NC(GPP_H16, NONE),
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1),	/* DDPB_CTRLDATA */
	PAD_CFG_NF(GPP_H18, NONE, DEEP, NF1),	/* PROC_C10_GATE# */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),	/* SRCCLKREQ4# */
	PAD_NC(GPP_H20, NONE),
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	PAD_NC(GPP_H23, NONE),

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_NC(GPP_D1, NONE),
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	PAD_NC(GPP_D4, NONE),
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF1),	/* SRCCLKREQ0# */
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF1),	/* SRCCLKREQ1# */
	PAD_CFG_NF(GPP_D7, NONE, DEEP, NF1),	/* SRCCLKREQ2# */
	PAD_CFG_NF(GPP_D8, NONE, DEEP, NF1),	/* SRCCLKREQ3# */
	PAD_CFG_NF(GPP_D9, NATIVE, DEEP, NF5),	/* BSSB_LS2_RX */
	PAD_CFG_NF(GPP_D10, NATIVE, DEEP, NF5),	/* BSSB_LS2_TX */
	PAD_CFG_NF(GPP_D11, NATIVE, DEEP, NF5),	/* BSSB_LS3_RX */
	PAD_CFG_NF(GPP_D12, NATIVE, DEEP, NF5),	/* BSSB_LS3_TX */
	PAD_NC(GPP_D13, NONE),
	PAD_CFG_GPO(GPP_D14, 1, PLTRST),
	PAD_NC(GPP_D15, NONE),
	PAD_NC(GPP_D16, NONE),
	PAD_CFG_NF(GPP_D17, NONE, DEEP, NF1),	/* UART1_RXD */
	PAD_CFG_NF(GPP_D18, NONE, DEEP, NF1),	/* UART1_TXD */
	PAD_NC(GPP_D19, NONE),
	PAD_CFG_NF(GPP_GSPI2_CLK_LOOPBK, NONE, DEEP, NF1),	/* GPP_GSPI2_CLK_LOOPBK */

	/* ------- GPIO Group vGPIO ------- */
	PAD_CFG_GPO(GPP_VGPIO_0, 0, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_VGPIO_4, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPIO_BIDIRECT(GPP_VGPIO_5, 1, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_NF(GPP_VGPIO_6, NONE, DEEP, NF1),	/* GPP_VGPIO_6 */
	PAD_CFG_NF(GPP_VGPIO_7, NONE, DEEP, NF1),	/* GPP_VGPIO_7 */
	PAD_CFG_NF(GPP_VGPIO_8, NONE, DEEP, NF1),	/* GPP_VGPIO_8 */
	PAD_CFG_NF(GPP_VGPIO_9, NONE, DEEP, NF1),	/* GPP_VGPIO_9 */
	PAD_CFG_NF(GPP_VGPIO_10, NONE, DEEP, NF1),	/* GPP_VGPIO_10 */
	PAD_CFG_NF(GPP_VGPIO_11, NONE, DEEP, NF1),	/* GPP_VGPIO_11 */
	PAD_CFG_NF(GPP_VGPIO_12, NONE, DEEP, NF1),	/* GPP_VGPIO_12 */
	PAD_CFG_NF(GPP_VGPIO_13, NONE, DEEP, NF1),	/* GPP_VGPIO_13 */
	PAD_CFG_NF(GPP_VGPIO_18, NONE, DEEP, NF1),	/* GPP_VGPIO_18 */
	PAD_CFG_NF(GPP_VGPIO_19, NONE, DEEP, NF1),	/* GPP_VGPIO_19 */
	PAD_CFG_NF(GPP_VGPIO_20, NONE, DEEP, NF1),	/* GPP_VGPIO_20 */
	PAD_CFG_NF(GPP_VGPIO_21, NONE, DEEP, NF1),	/* GPP_VGPIO_21 */
	PAD_CFG_NF(GPP_VGPIO_22, NONE, DEEP, NF1),	/* GPP_VGPIO_22 */
	PAD_CFG_NF(GPP_VGPIO_23, NONE, DEEP, NF1),	/* GPP_VGPIO_23 */
	PAD_CFG_NF(GPP_VGPIO_24, NONE, DEEP, NF1),	/* GPP_VGPIO_24 */
	PAD_CFG_NF(GPP_VGPIO_25, NONE, DEEP, NF1),	/* GPP_VGPIO_25 */
	PAD_CFG_NF(GPP_VGPIO_30, NONE, DEEP, NF1),	/* GPP_VGPIO_30 */
	PAD_CFG_NF(GPP_VGPIO_31, NONE, DEEP, NF1),	/* GPP_VGPIO_31 */
	PAD_CFG_NF(GPP_VGPIO_32, NONE, DEEP, NF1),	/* GPP_VGPIO_32 */
	PAD_CFG_NF(GPP_VGPIO_33, NONE, DEEP, NF1),	/* GPP_VGPIO_33 */
	PAD_CFG_NF(GPP_VGPIO_34, NONE, DEEP, NF1),	/* GPP_VGPIO_34 */
	PAD_CFG_NF(GPP_VGPIO_35, NONE, DEEP, NF1),	/* GPP_VGPIO_35 */
	PAD_CFG_NF(GPP_VGPIO_36, NONE, DEEP, NF1),	/* GPP_VGPIO_36 */
	PAD_CFG_NF(GPP_VGPIO_37, NONE, DEEP, NF1),	/* GPP_VGPIO_37 */

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPP_GPD ------- */
	PAD_CFG_NF(GPD0, NONE, PWROK, NF1),	/* BATLOW# */
	PAD_CFG_NF(GPD1, NONE, PWROK, NF1),	/* ACPRESENT */
	PAD_CFG_GPO(GPD2, 1, PLTRST),
	PAD_CFG_NF(GPD3, NONE, PWROK, NF1),	/* PWRBTN# */
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),	/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),	/* SLP_S4# */
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1),	/* SLP_A# */
	PAD_CFG_GPO(GPD7, 0, PWROK),
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1),	/* SUSCLK */
	PAD_CFG_NF(GPD9, NONE, PWROK, NF1),	/* SLP_WLAN# */
	PAD_CFG_NF(GPD10, NONE, PWROK, NF1),	/* SLP_S5# */
	PAD_CFG_GPO(GPD11, 0, PWROK),
	PAD_CFG_NF(GPD_INPUT3VSEL, NONE, PWROK, NF1),	/* GPD_INPUT3VSEL */
	PAD_CFG_NF(GPD_SLP_LANB, NONE, PWROK, NF1),	/* GPD_SLP_LANB */
	PAD_CFG_NF(GPD_SLP_SUSB, NONE, PWROK, NF1),	/* GPD_SLP_SUSB */
	PAD_CFG_NF(GPD_WAKEB, NONE, PWROK, NF1),	/* GPD_WAKEB */
	PAD_CFG_NF(GPD_DRAM_RESETB, NONE, PWROK, NF1),	/* GPD_DRAM_RESETB */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),	/* SMBCLK */
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1),	/* SMBDATA */
	PAD_CFG_NF(GPP_C2, NONE, DEEP, NF1),	/* SMBALERT# */
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1),	/* SML0CLK */
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1),	/* SML0DATA */
	PAD_CFG_TERM_GPO(GPP_C5, 1, DN_20K, PLTRST),
	PAD_CFG_NF(GPP_C6, NONE, RSMRST, NF1),	/* SML1CLK */
	PAD_CFG_NF(GPP_C7, NONE, RSMRST, NF1),	/* SML1DATA */
	PAD_NC(GPP_C8, NONE),
	PAD_NC(GPP_C9, NONE),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_NC(GPP_C12, NONE),
	PAD_NC(GPP_C13, NONE),
	PAD_NC(GPP_C14, NONE),
	PAD_NC(GPP_C15, NONE),
	PAD_NC(GPP_C16, NONE),
	PAD_NC(GPP_C17, NONE),
	PAD_NC(GPP_C18, NONE),
	PAD_NC(GPP_C19, NONE),
	PAD_NC(GPP_C20, NONE),
	PAD_NC(GPP_C21, NONE),
	PAD_NC(GPP_C22, NONE),
	PAD_NC(GPP_C23, NONE),

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1),	/* CNV_BRI_DT */
	PAD_CFG_NF(GPP_F1, NONE, DEEP, NF1),	/* CNV_BRI_RSP */
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1),	/* CNV_RGI_DT */
	PAD_CFG_NF(GPP_F3, NONE, DEEP, NF1),	/* CNV_RGI_RSP */
	PAD_CFG_NF(GPP_F4, NONE, DEEP, NF1),	/* CNV_RF_RESET# */
	PAD_CFG_NF(GPP_F5, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_F6, NONE, DEEP, NF1),	/* CNV_PA_BLANKING */
	PAD_CFG_GPO(GPP_F7, 0, DEEP),
	PAD_NC(GPP_F8, NONE),
	PAD_CFG_NF(GPP_F9, NONE, DEEP, NF1),	/* BOOTMPC */
	PAD_CFG_GPO(GPP_F10, 0, DEEP),
	PAD_NC(GPP_F11, NONE),
	PAD_NC(GPP_F12, NONE),
	PAD_NC(GPP_F13, NONE),
	PAD_NC(GPP_F14, NONE),
	PAD_NC(GPP_F15, NONE),
	PAD_NC(GPP_F16, NONE),
	PAD_NC(GPP_F17, NONE),
	PAD_NC(GPP_F18, NONE),
	PAD_NC(GPP_F19, NONE),
	PAD_CFG_NF(GPP_F20, NONE, DEEP, NF1),	/* Reserved */
	PAD_CFG_NF(GPP_F21, NONE, DEEP, NF1),	/* Reserved */
	PAD_NC(GPP_F22, NONE),
	PAD_NC(GPP_F23, NONE),
	PAD_NC(GPP_F_CLK_LOOPBK, NONE),

	/* ------- GPIO Group GPP_HVCMOS ------- */
	PAD_CFG_NF(GPP_L_BKLTEN, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_L_BKLTCTL, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_L_VDDEN, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_SYS_PWROK, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_SYS_RESETB, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_MLK_RSTB, NONE, DEEP, NF1),	/* n/a */

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, UP_20K, DEEP, NF1),	/* SATAXPCIE0 */
	PAD_NC(GPP_E1, NONE),
	PAD_NC(GPP_E2, NONE),
	PAD_NC(GPP_E3, NONE),
	PAD_NC(GPP_E4, NONE),
	PAD_NC(GPP_E5, NONE),
	PAD_CFG_TERM_GPO(GPP_E6, 1, DN_20K, PLTRST),
	PAD_NC(GPP_E7, NONE),
	PAD_CFG_GPO(GPP_E8, 0, PLTRST),
	PAD_CFG_NF(GPP_E9, NONE, DEEP, NF1),	/* USB_OC0# */
	PAD_NC(GPP_E10, NONE),
	PAD_NC(GPP_E11, NONE),
	PAD_NC(GPP_E12, NONE),
	PAD_NC(GPP_E13, NONE),
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),	/* DDSP_HPDA */
	PAD_CFG_NF(GPP_E15, NONE, DEEP, NF2),	/* Reserved */
	PAD_CFG_GPO(GPP_E16, 0, PLTRST),
	PAD_NC(GPP_E17, NONE),
	PAD_NC(GPP_E18, NATIVE),
	PAD_NC(GPP_E19, NATIVE),
	PAD_CFG_NF(GPP_E20, NATIVE, DEEP, NF5),	/* BSSB_LS1_RX */
	PAD_CFG_NF(GPP_E21, NATIVE, DEEP, NF5),	/* BSSB_LS1_TX */
	PAD_CFG_NF(GPP_E22, DN_20K, DEEP, NF1),	/* DDPA_CTRLCLK */
	PAD_CFG_NF(GPP_E23, NONE, DEEP, NF1),	/* DDPA_CTRLDATA */
	PAD_NC(GPP_E_CLK_LOOPBK, NONE),

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),	/* HDA_BCLK */
	PAD_CFG_NF(GPP_R1, NONE, DEEP, NF1),	/* HDA_SYNC */
	PAD_CFG_NF(GPP_R2, NONE, DEEP, NF1),	/* HDA_SDO */
	PAD_CFG_NF(GPP_R3, NONE, DEEP, NF1),	/* HDA_SDI0 */
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1),	/* HDA_RST# */
	PAD_NC(GPP_R5, NONE),
	PAD_NC(GPP_R6, NONE),
	PAD_NC(GPP_R7, NONE),
};

#endif /* CFG_GPIO_H */
