/*
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

@TraceResolve
class PrimitiveReturnTypeInference {
    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Byte", mostSpecific=true)
    static <B> B m_byte() { return null; }

    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Short", mostSpecific=true)
    static <S> S m_short() { return null; }

    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Integer", mostSpecific=true)
    static <I> I m_int() { return null; }

    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Long", mostSpecific=true)
    static <L> L m_long() { return null; }

    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Float", mostSpecific=true)
    static <F> F m_float() { return null; }

    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Double", mostSpecific=true)
    static <D> D m_double() { return null; }

    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Character", mostSpecific=true)
    static <C> C m_char() { return null; }

    @Candidate(applicable=Phase.BASIC, sig="()java.lang.Boolean", mostSpecific=true)
    static <Z> Z m_bool() { return null; }

    {
        byte b = m_byte();
        short s = m_short();
        int i = m_int();
        long l = m_long();
        float f = m_float();
        double d = m_double();
        char c= m_char();
        boolean z = m_bool();
    }
}
