# trajectory generated by Raimund Dutzler
from PyQt5 import QtCore
scene.RemoveAll()


class Anim(QtCore.QTimer):
  """
  Timer used to animate the trajectory on screen. Each time the OnTimer
  method gets called we advance the trajectory by one step and render
  the scene on the screen.
  """
  def __init__(self,cg,go):
      QtCore.QTimer.__init__(self)
      self.cg_=cg
      self.go_=go
      self.frame_=0
      self.timeout.connect(self.OnTimer)
      
  def OnTimer(self):
    self.frame_=(self.frame_+1)%self.cg_.GetFrameCount()
    self.go_.BlurSnapshot()
    self.cg_.CopyFrame(self.frame_)
    self.go_.UpdatePositions()
        

# load CHARMM trajectory from sample.pdb and sample.dcd
cg = io.LoadCHARMMTraj("data/sample.pdb","data/sample.dcd")
# create graphical representation of the entity
eh=cg.GetEntity()
# we don't want to display the hydrogen atoms, so select everything that is 
# not a hydrogen and pass that view to the gfx.Entity() constructor.
ev=eh.Select("not ele=H")
go=gfx.Entity("mol",gfx.SIMPLE, ev)
# enable the blur effect
go.SetBlur(True)

# add it to the scene for rendering
scene.Add(go)
scene.SetCenter(go.GetCenter())
scene.AutoAutoslab(True)

# create an animation timer and start it
anim=Anim(cg,go)
print('Demo 6: Import of a CHARMM trajectory. Type anim.stop() to halt animation, anim.start(100) to start it again with stepsize 100!Starting animation now....')
anim.start(50)
